/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import com.intellij.vfs.AsyncVfsEventsPostProcessorImplKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u0007*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessor;", "Lcom/intellij/openapi/Disposable;", "()V", "listeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "queue", "Lcom/intellij/util/concurrency/QueueProcessor;", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "addListener", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "dispose", "processEvents", "events", "Companion", "ListenerAndDisposable", "intellij.platform.vcs.impl"})
public final class AsyncVfsEventsPostProcessorImpl
implements AsyncVfsEventsPostProcessor,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueueProcessor<List<VFileEvent>> queue = new QueueProcessor(arg_0 -> AsyncVfsEventsPostProcessorImpl.queue$lambda$0((Function1)new Function1<List<? extends VFileEvent>, Unit>((Object)this){

        public final void invoke(@NotNull List<? extends VFileEvent> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            AsyncVfsEventsPostProcessorImpl.access$processEvents((AsyncVfsEventsPostProcessorImpl)this.receiver, p0);
        }
    }, arg_0));
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final ConcurrentList<ListenerAndDisposable> listeners;

    public AsyncVfsEventsPostProcessorImpl() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.messageBus = messageBus;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.listeners = concurrentList;
        MessageBusConnection messageBusConnection = this.messageBus.connect();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                queue.add(events);
            }
        });
    }

    public void addListener(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ListenerAndDisposable element = new ListenerAndDisposable(listener2, disposable);
        Disposer.register((Disposable)disposable, () -> AsyncVfsEventsPostProcessorImpl.addListener$lambda$1(this, element));
        this.listeners.add((Object)element);
    }

    public void dispose() {
        this.queue.clear();
        this.listeners.clear();
    }

    @RequiresBackgroundThread
    private final void processEvents(List<? extends VFileEvent> events) {
        for (ListenerAndDisposable listenerAndDisposable : this.listeners) {
            AsyncVfsEventsListener listener2 = listenerAndDisposable.component1();
            Disposable parentDisposable = listenerAndDisposable.component2();
            try {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)parentDisposable, () -> AsyncVfsEventsPostProcessorImpl.processEvents$lambda$2(listener2, events));
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                AsyncVfsEventsPostProcessorImplKt.access$getLOG$p().error(e);
            }
        }
    }

    private static final void queue$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addListener$lambda$1(AsyncVfsEventsPostProcessorImpl this$0, ListenerAndDisposable $element) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        this$0.listeners.remove((Object)$element);
    }

    private static final void processEvents$lambda$2(AsyncVfsEventsListener $listener, List $events) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$events, (String)"$events");
        $listener.filesChanged($events);
    }

    @JvmStatic
    @TestOnly
    public static final void waitEventsProcessed() {
        Companion.waitEventsProcessed();
    }

    public static final /* synthetic */ void access$processEvents(AsyncVfsEventsPostProcessorImpl $this, List events) {
        $this.processEvents(events);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$Companion;", "", "()V", "waitEventsProcessed", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        public final void waitEventsProcessed() {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            AsyncVfsEventsPostProcessor asyncVfsEventsPostProcessor = AsyncVfsEventsPostProcessor.getInstance();
            Intrinsics.checkNotNull((Object)asyncVfsEventsPostProcessor, (String)"null cannot be cast to non-null type com.intellij.vfs.AsyncVfsEventsPostProcessorImpl");
            ((AsyncVfsEventsPostProcessorImpl)asyncVfsEventsPostProcessor).queue.waitFor();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vfs/AsyncVfsEventsPostProcessorImpl$ListenerAndDisposable;", "", "listener", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vfs/AsyncVfsEventsListener;Lcom/intellij/openapi/Disposable;)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getListener", "()Lcom/intellij/vfs/AsyncVfsEventsListener;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class ListenerAndDisposable {
        @NotNull
        private final AsyncVfsEventsListener listener;
        @NotNull
        private final Disposable disposable;

        public ListenerAndDisposable(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            this.listener = listener2;
            this.disposable = disposable;
        }

        @NotNull
        public final AsyncVfsEventsListener getListener() {
            return this.listener;
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        @NotNull
        public final AsyncVfsEventsListener component1() {
            return this.listener;
        }

        @NotNull
        public final Disposable component2() {
            return this.disposable;
        }

        @NotNull
        public final ListenerAndDisposable copy(@NotNull AsyncVfsEventsListener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            return new ListenerAndDisposable(listener2, disposable);
        }

        public static /* synthetic */ ListenerAndDisposable copy$default(ListenerAndDisposable listenerAndDisposable, AsyncVfsEventsListener asyncVfsEventsListener, Disposable disposable, int n, Object object) {
            if ((n & 1) != 0) {
                asyncVfsEventsListener = listenerAndDisposable.listener;
            }
            if ((n & 2) != 0) {
                disposable = listenerAndDisposable.disposable;
            }
            return listenerAndDisposable.copy(asyncVfsEventsListener, disposable);
        }

        @NotNull
        public String toString() {
            return "ListenerAndDisposable(listener=" + this.listener + ", disposable=" + this.disposable + ")";
        }

        public int hashCode() {
            int result2 = this.listener.hashCode();
            result2 = result2 * 31 + this.disposable.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListenerAndDisposable)) {
                return false;
            }
            ListenerAndDisposable listenerAndDisposable = (ListenerAndDisposable)other;
            if (!Intrinsics.areEqual((Object)this.listener, (Object)listenerAndDisposable.listener)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.disposable, (Object)listenerAndDisposable.disposable);
        }
    }
}

