/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ExtensionListener;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactoryKt;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ex.VcsActivationListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StatusText;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "window", "isAvailable", "", "setEmptyState", "state", "Lcom/intellij/util/ui/StatusText;", "shouldBeAvailable", "updateEmptyState", "updateState", "intellij.platform.vcs.impl"})
public abstract class VcsToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void init(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        MessageBus messageBus = window.getProject().getMessageBus();
        Disposable disposable = window.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VCS_CONFIGURATION_CHANGED");
        connection.subscribe(topic, () -> VcsToolWindowFactory.init$lambda$1(window, this));
        Topic<VcsActivationListener> topic2 = ProjectLevelVcsManagerEx.VCS_ACTIVATED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"VCS_ACTIVATED");
        connection.subscribe(topic2, arg_0 -> VcsToolWindowFactory.init$lambda$3(window, this, arg_0));
        connection.subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(this, window){
            final /* synthetic */ VcsToolWindowFactory this$0;
            final /* synthetic */ ToolWindow $window;
            {
                this.this$0 = $receiver;
                this.$window = $window;
            }

            public void toolWindowMappingChanged() {
                this.this$0.updateState(this.$window);
            }
        });
        Project project = window.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ChangesViewContentEP.EP_NAME.addExtensionPointListener((AreaInstance)project, (ExtensionPointListener)new ExtensionListener(window), window.getDisposable());
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)window.getProject());
        if (vcsManager2 != null && vcsManager2.areVcsesActivated()) {
            ApplicationManager.getApplication().invokeLater(() -> VcsToolWindowFactory.init$lambda$4(this, window), window.getProject().getDisposed());
        }
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        VcsToolWindowFactoryKt.access$updateContent(toolWindow);
        ChangesViewContentManager.Companion.getInstance(project).attachToolWindow(toolWindow);
        toolWindow.getComponent().putClientProperty(VcsToolWindowFactoryKt.access$getIS_CONTENT_CREATED$p(), true);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.addDataProvider(arg_0 -> VcsToolWindowFactory.createToolWindowContent$lambda$5(contentManager2, arg_0));
    }

    protected void updateState(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        toolWindow.setAvailable(this.isAvailable(project));
        VcsToolWindowFactoryKt.access$updateContentIfCreated(toolWindow);
        this.updateEmptyState(toolWindow);
    }

    public abstract boolean isAvailable(@NotNull Project var1);

    public final boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    private final void updateEmptyState(ToolWindow toolWindow) {
        ToolWindowEx toolWindowEx = toolWindow instanceof ToolWindowEx ? (ToolWindowEx)toolWindow : null;
        if (toolWindowEx == null || (toolWindowEx = toolWindowEx.getEmptyText()) == null) {
            return;
        }
        ToolWindowEx emptyText = toolWindowEx;
        ToolWindowEmptyStateAction.setEmptyStateBackground((ToolWindow)toolWindow);
        emptyText.clear();
        ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(((ToolWindowEx)toolWindow).getProject());
        if (vcsManager2.areVcsesActivated() && !vcsManager2.hasActiveVcss()) {
            Project project = ((ToolWindowEx)toolWindow).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.setEmptyState(project, (StatusText)emptyText);
        }
    }

    protected void setEmptyState(@NotNull Project project, @NotNull StatusText state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    private static final void init$lambda$1$lambda$0(VcsToolWindowFactory this$0, ToolWindow $window) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        this$0.updateState($window);
    }

    private static final void init$lambda$1(ToolWindow $window, VcsToolWindowFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith($window.getDisposable())).execute(() -> VcsToolWindowFactory.init$lambda$1$lambda$0(this$0, $window));
    }

    private static final void init$lambda$3$lambda$2(VcsToolWindowFactory this$0, ToolWindow $window) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        this$0.updateState($window);
    }

    private static final void init$lambda$3(ToolWindow $window, VcsToolWindowFactory this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith($window.getDisposable())).execute(() -> VcsToolWindowFactory.init$lambda$3$lambda$2(this$0, $window));
    }

    private static final void init$lambda$4(VcsToolWindowFactory this$0, ToolWindow $window) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
        this$0.updateState($window);
    }

    private static final Object createToolWindowContent$lambda$5(ContentManager $contentManager, String dataId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$contentManager, (String)"$contentManager");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (ChangesViewContentManager.CONTENT_TAB_NAME_KEY.is(dataId)) {
            Content content = $contentManager.getSelectedContent();
            string = content != null ? content.getTabName() : null;
        } else {
            string = null;
        }
        return string;
    }
}

