/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManagerKt;
import com.intellij.vcsUtil.RollbackUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Manager", "intellij.platform.vcs.impl"})
public final class RollbackFilesAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!Manager.isPreferCheckboxesOverSelection()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!(CommitModeManagerKt.getProjectCommitMode(e) instanceof CommitMode.NonModalCommitMode)) {
            return;
        }
        if (e.getData(ChangesListView.DATA_KEY) == null) {
            return;
        }
        Change[] changeArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changeArray == null) {
            return;
        }
        Change[] changes = changeArray;
        Presentation $this$update_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.setVisible(true);
        $this$update_u24lambda_u240.setEnabled(!(changes.length == 0));
        Object[] objectArray = new Object[]{RollbackUtil.getRollbackOperationName(project2), changes.length};
        $this$update_u24lambda_u240.setText(VcsBundle.message((String)"action.for.file.with.dialog.text", (Object[])objectArray));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Manager.checkClmActive(e)) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (objectArray == null) {
            return;
        }
        Object[] changes = objectArray;
        FileDocumentManager.getInstance().saveAllDocuments();
        RollbackChangesDialog.Companion.rollbackChanges(project2, ArraysKt.asList((Object[])changes));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/RollbackFilesAction$Manager;", "", "()V", "checkClmActive", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPreferCheckboxesOverSelection", "intellij.platform.vcs.impl"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        @JvmStatic
        public static final boolean checkClmActive(@NotNull AnActionEvent e) {
            String string;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            if (Intrinsics.areEqual((Object)"ChangesViewToolbar", (Object)e.getPlace())) {
                string = null;
            } else {
                Object[] objectArray = new Object[1];
                String string2 = RollbackUtil.getRollbackOperationName(project2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRollbackOperationName(...)");
                objectArray[0] = AbstractCommitWorkflowKt.cleanActionText$default(string2, false, 2, null);
                string = VcsBundle.message((String)"error.cant.perform.operation.now", (Object[])objectArray);
            }
            String title2 = string;
            return !ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(title2);
        }

        @JvmStatic
        public static final boolean isPreferCheckboxesOverSelection() {
            return Registry.is((String)"vcs.prefer.checkboxes.over.selection");
        }
    }
}

