/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.StartUseVcsDialog;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartUseVcsAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(StartUseVcsAction.class);

    public StartUseVcsAction() {
        super(VcsBundle.messagePointer((String)"action.enable.version.control.integration.text", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            StartUseVcsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            StartUseVcsAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = StartUseVcsAction.isEnabled(project);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            StartUseVcsAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        if (!StartUseVcsAction.isEnabled(project)) {
            return;
        }
        VirtualFile targetDirectory = ProjectUtil.guessProjectDir((Project)project);
        if (targetDirectory == null) {
            LOG.warn("Project directory is null");
            return;
        }
        StartUseVcsDialog dialog = new StartUseVcsDialog(project, targetDirectory.getPath());
        if (dialog.showAndGet()) {
            AbstractVcs vcs = dialog.getVcs();
            vcs.enableIntegration();
        }
    }

    private static boolean isEnabled(@Nullable Project project) {
        if (project == null || !TrustedProjects.isTrusted((Project)project)) {
            return false;
        }
        ProjectLevelVcsManagerImpl manager = ProjectLevelVcsManagerImpl.getInstanceImpl(project);
        return manager.haveVcses() && !manager.hasAnyMappings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/StartUseVcsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/StartUseVcsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

