/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.west;

import com.intellij.clion.west.CLionWestBundle;
import com.intellij.clion.west.settings.WestSettings;
import com.intellij.clion.west.settings.WestSettingsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.toolchains.CPPBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/intellij/clion/west/WestRunner;", "", "()V", "runWest", "Lcom/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput;", "executable", "", "parameters", "Lcom/jetbrains/cidr/cpp/cmake/CMakeRunnerStep$Parameters;", "runWestBuild", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.west"})
public final class WestRunner {
    @NotNull
    public static final WestRunner INSTANCE = new WestRunner();

    private WestRunner() {
    }

    private final CMakeRunner.CMakeOutput runWest(String executable, CMakeRunnerStep.Parameters parameters) {
        GeneralCommandLine generalCommandLine;
        try {
            generalCommandLine = CPPBuildUtil.buildCommandLine((CPPEnvironment)parameters.getEnvironment(), (String)executable, (Path)parameters.getOutputDir(), (List)parameters.getParameters(), (boolean)parameters.isPassSystemEnvironment(), (Map)parameters.getAdditionalEnvironment(), (boolean)false);
        }
        catch (ExecutionException ex) {
            throw new CMakeException((Throwable)ex);
        }
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        Intrinsics.checkNotNull((Object)generalCommandLine2);
        GeneralCommandLine cl = generalCommandLine2;
        try {
            CMakeRunner.CMakeOutput cMakeOutput = CMakeRunner.runCMakeBasedTool((CMakeRunnerStep.Parameters)parameters, (GeneralCommandLine)cl);
            Intrinsics.checkNotNullExpressionValue((Object)cMakeOutput, (String)"runCMakeBasedTool(...)");
            return cMakeOutput;
        }
        catch (CMakeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessNotCreatedException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = executable;
                String string = ((ProcessNotCreatedException)cause).getMessage();
                if (string == null) {
                    string = "";
                }
                objectArray[1] = string;
                throw new CMakeException(CLionWestBundle.message("west.executable.failed.to.launch", objectArray));
            }
            throw new CMakeException((Throwable)ex);
        }
    }

    @NotNull
    public final CMakeRunner.CMakeOutput runWestBuild(@NotNull Project project, @NotNull CMakeRunnerStep.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        WestSettings.State state = WestSettings.Companion.getInstance(project).getState();
        Object object = new String[]{"build", "--cmake-only", "--build-dir=" + parameters.getOutputDir(), "--board=" + state.getBoardName(), ((Object)parameters.getProjectDir()).toString(), "--"};
        List allParams = CollectionsKt.mutableListOf((Object[])object);
        object = allParams;
        List list = parameters.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        CollectionsKt.addAll((Collection)object, (Iterable)list);
        CMakeRunnerStep.Parameters parameters2 = parameters.withParameters(allParams);
        Intrinsics.checkNotNullExpressionValue((Object)parameters2, (String)"withParameters(...)");
        CMakeRunnerStep.Parameters newParameters = parameters2;
        return this.runWest(WestSettingsKt.calculateWestExecutablePath(project), newParameters);
    }
}

