/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.runfile.projectStatus;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.widget.DefaultWidgetStatus;
import com.jetbrains.cidr.project.ui.widget.Scope;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import com.jetbrains.cidr.project.ui.widget.WidgetStatusProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/projectStatus/CppFileWidgetStatusProvider;", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatusProvider;", "()V", "getWidgetStatus", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatus;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.clion.runFile"})
public final class CppFileWidgetStatusProvider
implements WidgetStatusProvider {
    @Nullable
    public WidgetStatus getWidgetStatus(@NotNull Project project, @Nullable VirtualFile currentFile) {
        WidgetStatus widgetStatus;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (currentFile == null) {
            return null;
        }
        if (!ProjectStatusHelperKt.isProjectAwareFile((VirtualFile)currentFile, (Project)project)) {
            return null;
        }
        List list = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(currentFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationsForFile(...)");
        List currentFileConfigs = list;
        List list2 = OCWorkspace.getInstance((Project)project).getConfigurations("SINGLE_FILE");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getConfigurations(...)");
        List singleFileConfigs = list2;
        if (currentFileConfigs.size() == 1 && singleFileConfigs.contains(currentFileConfigs.get(0))) {
            String string = CidrWorkspaceBundle.message((String)"project.status.widget.configured", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            widgetStatus = (WidgetStatus)new DefaultWidgetStatus(Status.OK, Scope.Project, string);
        } else {
            widgetStatus = null;
        }
        return widgetStatus;
    }
}

