/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.runfile.projectStatus;

import com.intellij.execution.actions.CreateAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.cpp.runfile.CLionRunFileBundle;
import com.jetbrains.cidr.cpp.runfile.CppFileEntryPointDetector;
import com.jetbrains.cidr.cpp.runfile.CppFileTargetRunConfigurationProducer;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesProvider;
import com.jetbrains.cidr.project.ui.popup.ProjectStatusUpdatingWrappingActionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/projectStatus/CppFileProjectFixesProvider;", "Lcom/jetbrains/cidr/project/ui/popup/ProjectFixesProvider;", "()V", "collectFixes", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "AddSingleFileConfigurationAction", "intellij.clion.runFile"})
public final class CppFileProjectFixesProvider
implements ProjectFixesProvider {
    @NotNull
    public List<AnAction> collectFixes(@NotNull Project project, @Nullable VirtualFile file, @NotNull DataContext context) {
        boolean hasEntryPoint;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        if (!file.isValid() || !(file instanceof VirtualFileWithId)) {
            return CollectionsKt.emptyList();
        }
        if (!ProjectStatusHelperKt.isProjectAwareFile((VirtualFile)file, (Project)project) || OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, file).isUnknownOrInProject()) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        CppFileEntryPointDetector cppFileEntryPointDetector = CppFileEntryPointDetector.Companion.getInstance();
        boolean bl = hasEntryPoint = cppFileEntryPointDetector != null ? cppFileEntryPointDetector.hasEntryPoint(psiFile) : false;
        if (hasEntryPoint) {
            return CollectionsKt.listOf((Object)ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction$default((AnAction)new AddSingleFileConfigurationAction(context), null, (int)1, null));
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/projectStatus/CppFileProjectFixesProvider$AddSingleFileConfigurationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/actionSystem/DataContext;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.runFile"})
    private static final class AddSingleFileConfigurationAction
    extends AnAction {
        @NotNull
        private final DataContext context;

        public AddSingleFileConfigurationAction(@NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(CLionRunFileBundle.Companion.message("notification.link.create.current.file", new Object[0]));
            this.context = context;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CreateAction action = new CreateAction();
            DataContext dataContext = SimpleDataContext.builder().setParent(this.context).add(CppFileTargetRunConfigurationProducer.Companion.getALLOW_CPP_FILE_CONFIGURATION(), (Object)true).build();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
            DataContext dataContext2 = dataContext;
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)((AnAction)action), null, (String)"unknown", (DataContext)dataContext2);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
            AnActionEvent event = anActionEvent;
            action.actionPerformed(event);
        }
    }
}

