/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.runfile;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTargetData;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import com.jetbrains.cidr.execution.CidrProgramParametersConfigurator;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\tJ\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010#\u001a\u00020\tH\u0016J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\tH\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006."}, d2={"Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildConfiguration;", "data", "Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildTargetData;", "forceDebugCompilation", "", "(Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildTargetData;Z)V", "additionalEnvironment", "", "", "getAdditionalEnvironment", "()Ljava/util/Map;", "artifactName", "getArtifactName", "()Ljava/lang/String;", "compilerOptions", "forcedCompiler", "isPassParentEnv", "()Z", "isSupported", "sourceFile", "Ljava/io/File;", "getSourceFile", "()Ljava/io/File;", "toolchainName", "getToolchainName", "calculateBuildDirectory", "equals", "other", "", "getCompilerFile", "env", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getName", "getSwitchBuilder", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSpecificSwitchBuilder;", "compilerKind", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "hashCode", "", "resolveSourceFile", "file", "withForceDebugCompilation", "Companion", "intellij.clion.runFile"})
public final class CppFileBuildConfiguration
implements CidrBuildConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CppFileBuildTargetData data;
    private final boolean forceDebugCompilation;
    @Nullable
    private final String toolchainName;
    @Nullable
    private final String forcedCompiler;
    @NotNull
    private final File sourceFile;
    @Nullable
    private final String compilerOptions;
    @NotNull
    private final String artifactName;
    private final boolean isPassParentEnv;
    @NotNull
    private final Map<String, String> additionalEnvironment;

    /*
     * WARNING - void declaration
     */
    public CppFileBuildConfiguration(@NotNull CppFileBuildTargetData data, boolean forceDebugCompilation) {
        void $this$sourceFile_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.forceDebugCompilation = forceDebugCompilation;
        this.toolchainName = this.data.getCppFileRunConfigurationData().getToolchainName();
        this.forcedCompiler = this.data.getCppFileRunConfigurationData().getCompilerFile();
        CppFileBuildConfiguration cppFileBuildConfiguration = this;
        CppFileBuildConfiguration cppFileBuildConfiguration2 = this;
        boolean bl = false;
        String file = $this$sourceFile_u24lambda_u240.data.getCppFileRunConfigurationData().getSourceFile();
        if (file == null) {
            throw new IllegalStateException("cppFileRunConfigurationData.sourceFile in CppFileBuildTargetData cannot be null");
        }
        cppFileBuildConfiguration2.sourceFile = super.resolveSourceFile(file);
        this.compilerOptions = this.data.getCppFileRunConfigurationData().getCompilerOptions();
        String string = FileUtil.getNameWithoutExtension((File)this.sourceFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        this.artifactName = string;
        this.isPassParentEnv = this.data.isPassParentEnvs();
        this.additionalEnvironment = this.data.getEnvs();
    }

    public /* synthetic */ CppFileBuildConfiguration(CppFileBuildTargetData cppFileBuildTargetData, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(cppFileBuildTargetData, bl);
    }

    @NotNull
    public String getName() {
        return Companion.generateName(this.data);
    }

    @Nullable
    public final String getToolchainName() {
        return this.toolchainName;
    }

    @NotNull
    public final File getCompilerFile(@NotNull CPPEnvironment env, @Nullable OCLanguageKind languageKind) {
        File file;
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        String finalFile = this.forcedCompiler;
        if (finalFile != null) {
            file = new File(finalFile);
        } else if (languageKind == CLanguageKind.C) {
            String string = env.getToolchain().getCustomCCompilerPath();
            if (string == null) {
                string = CppFileBuildConfiguration.Companion.getFallbackCompiler(env, languageKind);
            }
            file = new File(string);
        } else {
            String string = env.getToolchain().getCustomCXXCompilerPath();
            if (string == null) {
                string = CppFileBuildConfiguration.Companion.getFallbackCompiler(env, languageKind);
            }
            file = new File(string);
        }
        return file;
    }

    @NotNull
    public final String calculateBuildDirectory() {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        CidrProgramParameters params = new CidrProgramParameters();
        CidrProgramParametersConfigurator configurator = new CidrProgramParametersConfigurator();
        configurator.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)this.data.getRunConfiguration());
        String string = params.getWorkingDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirectory(...)");
        return string;
    }

    @NotNull
    public final File getSourceFile() {
        return this.sourceFile;
    }

    private final File resolveSourceFile(String file) {
        ThreadingAssertions.softAssertBackgroundThread();
        if (!OSAgnosticPathUtil.isAbsolute((String)file)) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.data.getProject());
            if (projectDir != null) {
                Path path = projectDir.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                Path nioProjectDir = path;
                Path sourceFile = nioProjectDir.resolve(file);
                if (Files.exists(sourceFile, new LinkOption[0])) {
                    File file2 = sourceFile.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                    return file2;
                }
            }
            return FilesKt.resolve((File)new File(this.calculateBuildDirectory()), (String)file);
        }
        return new File(file);
    }

    @NotNull
    public final CompilerSpecificSwitchBuilder getSwitchBuilder(@NotNull OCCompilerKind compilerKind, @NotNull CPPEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)compilerKind, (String)"compilerKind");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        CompilerSpecificSwitchBuilder compilerSpecificSwitchBuilder = compilerKind.getSwitchBuilder(new CidrSwitchBuilder());
        String string = this.compilerOptions;
        if (string == null) {
            string = "";
        }
        CompilerSpecificSwitchBuilder builder = compilerSpecificSwitchBuilder.withCommandLine(string, env.isMSVC() || env.isMinGW() ? CidrCompilerSwitches.Format.WINDOWS_SHELL : CidrCompilerSwitches.Format.BASH_SHELL).withExecutable(this.artifactName);
        return this.forceDebugCompilation ? CompilerSpecificSwitchBuilder.withDebugInfo$default((CompilerSpecificSwitchBuilder)builder, (int)0, (int)1, null) : builder;
    }

    @NotNull
    public final String getArtifactName() {
        return this.artifactName;
    }

    public final boolean isPassParentEnv() {
        return this.isPassParentEnv;
    }

    @NotNull
    public final Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnvironment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSupported() {
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(this.toolchainName);
        if (toolchain == null) return false;
        Object[] objectArray = new CPPToolSet.Kind[]{CPPToolSet.Kind.SSH, CPPToolSet.Kind.DOCKER};
        if (CollectionsKt.listOf((Object[])objectArray).contains(toolchain.getToolSetKind())) return false;
        return true;
    }

    @NotNull
    public final CppFileBuildConfiguration withForceDebugCompilation(boolean forceDebugCompilation) {
        return new CppFileBuildConfiguration(this.data, forceDebugCompilation);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.runfile.CppFileBuildConfiguration");
        CppFileBuildConfiguration cfr_ignored_0 = (CppFileBuildConfiguration)other;
        if (this.forceDebugCompilation != ((CppFileBuildConfiguration)other).forceDebugCompilation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.toolchainName, (Object)((CppFileBuildConfiguration)other).toolchainName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.forcedCompiler, (Object)((CppFileBuildConfiguration)other).forcedCompiler)) {
            return false;
        }
        if (!FileUtil.filesEqual((File)this.sourceFile, (File)((CppFileBuildConfiguration)other).sourceFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.compilerOptions, (Object)((CppFileBuildConfiguration)other).compilerOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifactName, (Object)((CppFileBuildConfiguration)other).artifactName)) {
            return false;
        }
        if (this.isPassParentEnv != ((CppFileBuildConfiguration)other).isPassParentEnv) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalEnvironment, ((CppFileBuildConfiguration)other).additionalEnvironment);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.forceDebugCompilation);
        String string = this.toolchainName;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        String string2 = this.forcedCompiler;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        result = 31 * result + FileUtil.fileHashCode((File)this.sourceFile);
        String string3 = this.compilerOptions;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        result = 31 * result + this.artifactName.hashCode();
        result = 31 * result + Boolean.hashCode(this.isPassParentEnv);
        result = 31 * result + ((Object)this.additionalEnvironment).hashCode();
        return result;
    }

    @JvmStatic
    @NotNull
    public static final String generateName(@NotNull CppFileBuildTargetData data) {
        return Companion.generateName(data);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildConfiguration$Companion;", "", "()V", "generateName", "", "data", "Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildTargetData;", "getFallbackCompiler", "env", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "intellij.clion.runFile"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFallbackCompiler(CPPEnvironment env, OCLanguageKind languageKind) {
            String compilerName = env.isMSVC() ? "cl" : (env.isMinGW() ? (languageKind == CLanguageKind.C ? "gcc" : "g++") : (env.isCygwin() && languageKind == CLanguageKind.C ? "gcc" : (languageKind == CLanguageKind.C ? "cc" : "c++")));
            String extension = env.isMSVC() || env.isMinGW() || env.isCygwin() ? ".exe" : "";
            return compilerName + extension;
        }

        @JvmStatic
        @NotNull
        public final String generateName(@NotNull CppFileBuildTargetData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.getRunConfigurationName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

