/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.runfile;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.runfile.CLionRunFileBundle;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildConfiguration;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTarget;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTargetData;
import com.jetbrains.cidr.cpp.runfile.CppFileBuildTargetsService;
import com.jetbrains.cidr.cpp.runfile.CppFileWorkspace;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/runfile/AddResolveConfigurationsTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "configurationDataList", "", "Lcom/jetbrains/cidr/cpp/runfile/CppFileBuildTargetData;", "clearModel", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Z)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.clion.runFile"})
@SourceDebugExtension(value={"SMAP\nAddResolveConfigurationsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddResolveConfigurationsTask.kt\ncom/jetbrains/cidr/cpp/runfile/AddResolveConfigurationsTask\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n31#2,2:89\n31#2,2:98\n766#3:91\n857#3,2:92\n1549#3:94\n1620#3,3:95\n*S KotlinDebug\n*F\n+ 1 AddResolveConfigurationsTask.kt\ncom/jetbrains/cidr/cpp/runfile/AddResolveConfigurationsTask\n*L\n33#1:89,2\n38#1:98,2\n36#1:91\n36#1:92,2\n36#1:94\n36#1:95,3\n*E\n"})
public final class AddResolveConfigurationsTask
extends Task.Backgroundable {
    @NotNull
    private final List<CppFileBuildTargetData> configurationDataList;
    private final boolean clearModel;

    public AddResolveConfigurationsTask(@NotNull Project project, @NotNull List<CppFileBuildTargetData> configurationDataList, boolean clearModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configurationDataList, (String)"configurationDataList");
        super(project, CLionRunFileBundle.Companion.message("progress.title.collecting.compiler.information", new Object[0]));
        this.configurationDataList = configurationDataList;
        this.clearModel = clearModel;
    }

    public /* synthetic */ AddResolveConfigurationsTask(Project project, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(project, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CppFileBuildTargetData it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        OCWorkspace workspace = oCWorkspace;
        OCWorkspace.ModifiableModel modifiableModel = workspace.getModifiableModel("SINGLE_FILE", this.clearModel);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel workspaceModel = modifiableModel;
        if (this.clearModel) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CppFileBuildTargetsService> serviceClass$iv = CppFileBuildTargetsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((CppFileBuildTargetsService)object).getTargets().clear();
        }
        Iterable $this$filter$iv = this.configurationDataList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CppFileBuildTargetData)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it.getCppFileRunConfigurationData().getSourceFile();
            boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CppFileBuildTargetData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CppFileBuildTarget(it));
        }
        List targets = (List)destination$iv$iv;
        for (CppFileBuildTarget buildTarget : targets) {
            OCCompilerSettings.ModifiableModel langSettings;
            OCResolveConfiguration.ModifiableModel resolveModel;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CppFileBuildTargetsService> serviceClass$iv = CppFileBuildTargetsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((CppFileBuildTargetsService)object).getTargets().add(buildTarget);
            CppFileBuildConfiguration buildConfiguration = buildTarget.getBuildConfiguration();
            if (workspaceModel.getConfigurationById(buildTarget.getId()) != null) {
                OCResolveConfiguration.ModifiableModel it2;
                boolean bl = false;
                workspaceModel.removeConfiguration(it2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)workspaceModel.addConfiguration(buildTarget.getId(), buildConfiguration.getName()), (String)"addConfiguration(...)");
            EnvironmentProblems problems = new EnvironmentProblems();
            Project project2 = this.getProject();
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            Object object2 = ProjectUtil.guessProjectDir((Project)project3);
            CPPEnvironment env = CPPToolchains.createCPPEnvironment((Project)project2, (File)(object2 != null && (object2 = object2.toNioPath()) != null ? object2.toFile() : null), (String)buildConfiguration.getToolchainName(), (EnvironmentProblems)problems, (boolean)true, null);
            if (!((Collection)problems.getProblems()).isEmpty() || env == null || !buildConfiguration.isSupported()) continue;
            File sourceFile = buildConfiguration.getSourceFile();
            OCLanguageKind oCLanguageKind = OCFileTypeHelpers.getLanguageKind((String)sourceFile.getName());
            if (oCLanguageKind == null) {
                oCLanguageKind = (OCLanguageKind)CLanguageKind.CPP;
            }
            OCLanguageKind bl = oCLanguageKind;
            Intrinsics.checkNotNull((Object)bl);
            OCLanguageKind languageKind = bl;
            File compilerFile = buildConfiguration.getCompilerFile(env, languageKind);
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            Path path = compilerFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            OCCompilerKind compilerKind = OCCompilerResolver.Companion.resolve(project4, path, (CidrToolEnvironment)env);
            Intrinsics.checkNotNullExpressionValue((Object)resolveModel.getLanguageCompilerSettings(languageKind), (String)"getLanguageCompilerSettings(...)");
            String buildDirectory = buildConfiguration.calculateBuildDirectory();
            langSettings.setCompiler(compilerKind, compilerFile, new File(buildDirectory));
            langSettings.setCompilerSwitches(buildConfiguration.getSwitchBuilder(compilerKind, env).build());
            resolveModel.addSource(VfsUtilCore.fileToUrl((File)new File(env.toLocalPath(buildConfiguration.getSourceFile().toString()))), languageKind);
            CompilerInfoCache.Session compilerInfoSession = new CompilerInfoCache().createSession(indicator);
            compilerInfoSession.schedule((Object)buildTarget.getId(), resolveModel, (CidrToolEnvironment)env, buildDirectory);
            MultiMap messages = new MultiMap();
            compilerInfoSession.waitForAll(messages);
        }
        workspaceModel.preCommit();
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(workspaceModel, this){
            final /* synthetic */ OCWorkspace.ModifiableModel $workspaceModel;
            final /* synthetic */ AddResolveConfigurationsTask this$0;
            {
                this.$workspaceModel = $workspaceModel;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$workspaceModel, this.this$0){
                    final /* synthetic */ OCWorkspace.ModifiableModel $workspaceModel;
                    final /* synthetic */ AddResolveConfigurationsTask this$0;
                    {
                        this.$workspaceModel = $workspaceModel;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$workspaceModel.commit();
                        OCRootsSynchronizer oCRootsSynchronizer = OCRootsSynchronizer.getInstance((Project)this.this$0.getProject());
                        Project project = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        ComponentManager $this$service$iv = (ComponentManager)project;
                        boolean $i$f$service = false;
                        Class<CppFileWorkspace> serviceClass$iv = CppFileWorkspace.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        oCRootsSynchronizer.updateRoots((CidrWorkspace)object);
                    }
                }));
            }
        }), (int)1, null);
    }
}

