/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.packagemanager.bundle.PackageManagerBundle;
import com.jetbrains.cidr.packagemanager.calling.CallEngineContextUtils;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatus;
import com.jetbrains.cidr.packagemanager.calling.CallEngineStatusContext;
import com.jetbrains.cidr.packagemanager.calling.TaskBuilder;
import com.jetbrains.cidr.packagemanager.fus.PackageManagerCollector;
import com.jetbrains.cidr.packagemanager.utils.PackageManagerUtils;
import com.jetbrains.cidr.packagemanager.vcpkg.PackageManagerEventListener;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGPackageManager;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgExecutorService;
import com.jetbrains.cidr.packagemanager.vcpkg.service.VcpkgPackageManagerModelService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service
@State(name="PackageManager", storages={@Storage(value="packageManager.xml")}, reloadable=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\r\u001a\u00020\u0002H\u0016J1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J(\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00072\u000b\u0010 \u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u000b\u0010!\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014J3\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0007J\u0011\u0010#\u001a\u00070\u0013\u00a2\u0006\u0002\b$*\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable$Default;", "()V", "packagesModel", "", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGPackageManager;", "add", "", "packageManager", "addWithDispose", "getPackages", "getState", "install", "Lcom/jetbrains/cidr/packagemanager/calling/TaskBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lorg/jetbrains/annotations/Nls;", "path", "Ljava/nio/file/Path;", "url", "loadState", "state", "remove", "vcpkgPackageManager", "isRemoveFolder", "", "removeWithDispose", "rename", "oldName", "newName", "testInstall", "getElementName", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.clion.packageManager"})
@SourceDebugExtension(value={"SMAP\nVcpkgPackageManagerModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcpkgPackageManagerModelService.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1855#2,2:155\n1549#2:157\n1620#2,3:158\n1855#2,2:161\n*S KotlinDebug\n*F\n+ 1 VcpkgPackageManagerModelService.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService\n*L\n53#1:155,2\n69#1:157\n69#1:158,3\n134#1:161,2\n*E\n"})
public final class VcpkgPackageManagerModelService
implements PersistentStateComponent<Element>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<VCPKGPackageManager> packagesModel = new LinkedHashSet();

    @NotNull
    public Element getState() {
        Element mainElement = new Element("mainNode");
        Iterable $this$forEach$iv = this.packagesModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VCPKGPackageManager packageManager = (VCPKGPackageManager)element$iv;
            boolean bl = false;
            Element packageManagerElement = new Element("repository");
            packageManagerElement.setAttribute("name", packageManager.getName());
            packageManagerElement.setAttribute("path", ((Object)packageManager.getPath()).toString());
            packageManagerElement.setAttribute("baseUrl", packageManager.getBaseUrl());
            packageManagerElement.setAttribute("forcedCMakeNinja", String.valueOf((Boolean)packageManager.isForcedBundledNinjaCMake().get()));
            mainElement.addContent(packageManagerElement);
        }
        return mainElement;
    }

    private final String getElementName(Element $this$getElementName) {
        String string = $this$getElementName.getAttributeValue("name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element state) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = state.getChildren("repository");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable iterable = list;
        VcpkgPackageManagerModelService vcpkgPackageManagerModelService = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            void repository;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)repository);
            String name = this.getElementName((Element)repository);
            Path path = Path.of(repository.getAttributeValue("path"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            String string3 = repository.getAttributeValue("baseUrl");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            String string4 = string2 = repository.getAttributeValue("forcedCMakeNinja");
            if (string4 == null) {
                string = "false";
            } else {
                Intrinsics.checkNotNull((Object)string4);
                string = string2;
            }
            VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, string3, (AtomicProperty<Boolean>)new AtomicProperty((Object)Boolean.parseBoolean(string)));
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)packageManager));
            collection.add(packageManager);
        }
        vcpkgPackageManagerModelService.packagesModel = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<VCPKGPackageManager> getPackages() {
        return this.packagesModel;
    }

    private final void addWithDispose(VCPKGPackageManager packageManager) {
        this.packagesModel.add(packageManager);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)packageManager));
    }

    private final void removeWithDispose(VCPKGPackageManager packageManager) {
        this.packagesModel.remove(packageManager);
        Disposer.dispose((Disposable)((Disposable)packageManager));
    }

    @TestOnly
    public final void add(@NotNull VCPKGPackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        this.addWithDispose(packageManager);
    }

    @TestOnly
    public final void remove(@NotNull VCPKGPackageManager packageManager) {
        Intrinsics.checkNotNullParameter((Object)packageManager, (String)"packageManager");
        this.removeWithDispose(packageManager);
    }

    @NotNull
    public final TaskBuilder<VCPKGPackageManager> install(@NotNull Project project, @NotNull String name, @NotNull Path path, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, url, null, 8, null);
        this.addWithDispose(packageManager);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerAdded(packageManager);
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("progress.title.checking.for.install", new Object[0])).task((Function1)new Function1<ProgressIndicator, CallEngineStatus<VCPKGPackageManager>>(packageManager, project){
            final /* synthetic */ VCPKGPackageManager $packageManager;
            final /* synthetic */ Project $project;
            {
                this.$packageManager = $packageManager;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final CallEngineStatus<VCPKGPackageManager> invoke(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return this.$packageManager.safeStartWithInstall(this.$project, VcpkgExecutorService.Companion.getInstance(this.$project).getExecutor(this.$packageManager).runner(indicator), indicator).withTransformResult((Function1)new Function1<Unit, VCPKGPackageManager>(this.$packageManager){
                    final /* synthetic */ VCPKGPackageManager $packageManager;
                    {
                        this.$packageManager = $packageManager;
                        super(1);
                    }

                    @NotNull
                    public final VCPKGPackageManager invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$packageManager;
                    }
                });
            }
        }).onSuccess(install.2.INSTANCE).onFailure((Function1<CallEngineStatusContext.FailedContext, Unit>)((Function1)new Function1<CallEngineStatusContext.FailedContext, Unit>(packageManager){
            final /* synthetic */ VCPKGPackageManager $packageManager;
            {
                this.$packageManager = $packageManager;
                super(1);
            }

            public final void invoke(@NotNull CallEngineStatusContext.FailedContext $this$onFailure) {
                Intrinsics.checkNotNullParameter((Object)$this$onFailure, (String)"$this$onFailure");
                CallEngineContextUtils.Companion.showErrorWithOutputLink($this$onFailure, $this$onFailure.getProblem().getShortError(), this.$packageManager);
            }
        }));
    }

    @TestOnly
    @NotNull
    public final TaskBuilder<VCPKGPackageManager> testInstall(@NotNull Project project, @NotNull String name, @NotNull Path path, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VCPKGPackageManager packageManager = new VCPKGPackageManager(name, path, url, null, 8, null);
        this.addWithDispose(packageManager);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerAdded(packageManager);
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("progress.title.checking.for.install", new Object[0])).task((Function1)new Function1<ProgressIndicator, CallEngineStatus<VCPKGPackageManager>>(packageManager){
            final /* synthetic */ VCPKGPackageManager $packageManager;
            {
                this.$packageManager = $packageManager;
                super(1);
            }

            @NotNull
            public final CallEngineStatus<VCPKGPackageManager> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$packageManager.testInstall().withTransformResult((Function1)new Function1<Unit, VCPKGPackageManager>(this.$packageManager){
                    final /* synthetic */ VCPKGPackageManager $packageManager;
                    {
                        this.$packageManager = $packageManager;
                        super(1);
                    }

                    @NotNull
                    public final VCPKGPackageManager invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$packageManager;
                    }
                });
            }
        });
    }

    @NotNull
    public final TaskBuilder<Unit> remove(@NotNull Project project, @NotNull VCPKGPackageManager vcpkgPackageManager, boolean isRemoveFolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcpkgPackageManager, (String)"vcpkgPackageManager");
        Iterable $this$forEach$iv = PackageManagerUtils.Companion.getProfilesPackageManagerWithLocks(project, (Function1<? super VCPKGPackageManager, Boolean>)((Function1)remove.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackageManagerUtils.ProfilePackageManagerInfo info2 = (PackageManagerUtils.ProfilePackageManagerInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info2.getPackageManager(), (Object)vcpkgPackageManager)) continue;
            PackageManagerUtils.Companion.setActiveToolchain(project, info2.getProfile(), null);
        }
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerRemoved(vcpkgPackageManager);
        this.removeWithDispose(vcpkgPackageManager);
        PackageManagerCollector.countOfRemoveVCPKG.log();
        Object[] objectArray = new Object[]{vcpkgPackageManager.getName()};
        return TaskBuilder.TaskBuilderInfo.Companion.taskBuilder(project, PackageManagerBundle.message("vcpkg.toolwindow.task.remove.package.manager", objectArray)).task((Function1)new Function1<ProgressIndicator, CallEngineStatus<Unit>>(vcpkgPackageManager, isRemoveFolder){
            final /* synthetic */ VCPKGPackageManager $vcpkgPackageManager;
            final /* synthetic */ boolean $isRemoveFolder;
            {
                this.$vcpkgPackageManager = $vcpkgPackageManager;
                this.$isRemoveFolder = $isRemoveFolder;
                super(1);
            }

            @NotNull
            public final CallEngineStatus<Unit> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$vcpkgPackageManager.safeRemove(it, this.$isRemoveFolder);
            }
        }).onSuccess(remove.4.INSTANCE).onFailure((Function1<CallEngineStatusContext.FailedContext, Unit>)((Function1)remove.5.INSTANCE));
    }

    public final void rename(@NotNull VCPKGPackageManager vcpkgPackageManager, @NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)vcpkgPackageManager, (String)"vcpkgPackageManager");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        vcpkgPackageManager.setName(newName);
        ((PackageManagerEventListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PackageManagerEventListener.Companion.getTOPIC())).onPackageManagerRenamed(vcpkgPackageManager, oldName, newName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/packagemanager/vcpkg/service/VcpkgPackageManagerModelService;", "intellij.clion.packageManager"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VcpkgPackageManagerModelService getInstance() {
            Object object = ApplicationManager.getApplication().getService(VcpkgPackageManagerModelService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (VcpkgPackageManagerModelService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

