/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.packagemanager.vcpkg.parser;

import com.jetbrains.cidr.packagemanager.vcpkg.PackageNameWithTriplet;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGTripletPackage;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGVersion;
import com.jetbrains.cidr.packagemanager.vcpkg.VCPKGVersionWithPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/parser/VCPKGOutputParser;", "", "()V", "Companion", "intellij.clion.packageManager"})
public final class VCPKGOutputParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern SEMVER_VERSION_REGEX = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<prerelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<buildmetadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    @NotNull
    private static final Regex DOT_SEPARATED_VERSION_REGEX = new Regex("^(?:(\\d+)\\.)*(\\d+)$");
    private static final Pattern DATE_VERSION_REGEX = Pattern.compile("^(?<year>(\\d){4})-(?<month>(\\d){2})-(?<day>(\\d){2})(\\.\\d+)*$");
    @NotNull
    private static final Regex STRING_VERSION = new Regex("[\\w-.]+");
    @NotNull
    private static final Regex NAME_REGEX = new Regex("[\\w-]+");
    @NotNull
    private static final Regex TRIPLET_REGEX = new Regex("\\w+-[\\w-]+");

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u000eJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0017\u0010\u0017\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J(\u0010\u0019\u001a\u001a\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u001b\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u001b\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0017\u0010\u001c\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0017\u0010$\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J,\u0010%\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0\u001a0\u001a0\r2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\u0010\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/packagemanager/vcpkg/parser/VCPKGOutputParser$Companion;", "", "()V", "DATE_VERSION_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "DOT_SEPARATED_VERSION_REGEX", "Lkotlin/text/Regex;", "NAME_REGEX", "SEMVER_VERSION_REGEX", "STRING_VERSION", "TRIPLET_REGEX", "getParseableLines", "", "", "startPhrase", "s", "parseDateVersion", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersion$VCPKGDateVersion;", "parseDotSeparatedVersion", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersion$VCPKGNumberVersion;", "parseInstallConsoleOutput", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGTripletPackage;", "parseName", "Lcom/intellij/openapi/util/NlsSafe;", "parseNameWithFeatureAndTriplet", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "parseNameWithFeatures", "parseNameWithTriplet", "Lcom/jetbrains/cidr/packagemanager/vcpkg/PackageNameWithTriplet;", "parseRemoveConsoleOutput", "parseSemverVersion", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersion$VCPKGSemverVersion;", "parseStringVersion", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersion$VCPKGStringVersion;", "parseTriplet", "parseUpdateConsoleOutput", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersionWithPort;", "parseUpgradeConsoleOutput", "parseVersion", "Lcom/jetbrains/cidr/packagemanager/vcpkg/VCPKGVersion;", "parseVersionWithPort", "intellij.clion.packageManager"})
    @SourceDebugExtension(value={"SMAP\nVCPKGOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VCPKGOutputParser.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/parser/VCPKGOutputParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,192:1\n1#2:193\n1#2:243\n1#2:256\n1#2:269\n1855#3,2:194\n1549#3:196\n1620#3,3:197\n1549#3:200\n1620#3,2:201\n1622#3:226\n766#3:227\n857#3,2:228\n766#3:230\n857#3,2:231\n1603#3,9:233\n1855#3:242\n1856#3:244\n1612#3:245\n1603#3,9:246\n1855#3:255\n1856#3:257\n1612#3:258\n1603#3,9:259\n1855#3:268\n1856#3:270\n1612#3:271\n107#4:203\n79#4,22:204\n*S KotlinDebug\n*F\n+ 1 VCPKGOutputParser.kt\ncom/jetbrains/cidr/packagemanager/vcpkg/parser/VCPKGOutputParser$Companion\n*L\n153#1:243\n165#1:256\n173#1:269\n43#1:194,2\n53#1:196\n53#1:197,3\n95#1:200\n95#1:201,2\n95#1:226\n95#1:227\n95#1:228,2\n125#1:230\n125#1:231,2\n153#1:233,9\n153#1:242\n153#1:244\n153#1:245\n165#1:246,9\n165#1:255\n165#1:257\n165#1:258\n173#1:259,9\n173#1:268\n173#1:270\n173#1:271\n95#1:203\n95#1:204,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VCPKGVersion.VCPKGSemverVersion parseSemverVersion(@NotNull String s) {
            List buildId;
            Object object;
            List list;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Matcher semverMatch = SEMVER_VERSION_REGEX.matcher(s);
            if (!semverMatch.find()) {
                return null;
            }
            String string = semverMatch.group("major");
            Integer major = string != null ? StringsKt.toIntOrNull((String)string) : null;
            String string2 = semverMatch.group("minor");
            Integer minor = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
            String string3 = semverMatch.group("patch");
            Integer patch = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
            String string4 = semverMatch.group("prerelease");
            if (string4 != null) {
                String[] stringArray = new String[]{"."};
                list = StringsKt.split$default((CharSequence)string4, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = null;
            }
            List prereleaseId = list;
            String string5 = semverMatch.group("buildmetadata");
            if (string5 != null) {
                object = new String[]{"."};
                v6 = StringsKt.split$default((CharSequence)string5, (String[])object, (boolean)false, (int)0, (int)6, null);
            } else {
                v6 = buildId = null;
            }
            if (major != null && minor != null && patch != null) {
                VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId;
                VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId2;
                VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId3;
                List it;
                int n;
                int n2;
                int n3;
                int n4 = major;
                int n5 = minor;
                int n6 = patch;
                List list2 = prereleaseId;
                if (list2 != null) {
                    object = list2;
                    n3 = n6;
                    n2 = n5;
                    n = n4;
                    boolean bl = false;
                    preBuildReleaseId3 = new VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId(it);
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    preBuildReleaseId2 = preBuildReleaseId3;
                } else {
                    preBuildReleaseId2 = null;
                }
                List list3 = buildId;
                if (list3 != null) {
                    it = list3;
                    preBuildReleaseId3 = preBuildReleaseId2;
                    n3 = n6;
                    n2 = n5;
                    n = n4;
                    boolean bl = false;
                    VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId4 = new VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId(it);
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    preBuildReleaseId2 = preBuildReleaseId3;
                    preBuildReleaseId = preBuildReleaseId4;
                } else {
                    preBuildReleaseId = null;
                }
                VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId5 = preBuildReleaseId;
                VCPKGVersion.VCPKGSemverVersion.PreBuildReleaseId preBuildReleaseId6 = preBuildReleaseId2;
                int n7 = n6;
                int n8 = n5;
                int n9 = n4;
                return new VCPKGVersion.VCPKGSemverVersion(n9, n8, n7, preBuildReleaseId6, preBuildReleaseId5);
            }
            return null;
        }

        @Nullable
        public final VCPKGVersion.VCPKGNumberVersion parseDotSeparatedVersion(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (Regex.find$default((Regex)DOT_SEPARATED_VERSION_REGEX, (CharSequence)s, (int)0, (int)2, null) == null) {
                return null;
            }
            String[] stringArray = new String[]{"."};
            List numbers = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv = numbers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                if (n != null) {
                    n.intValue();
                    continue;
                }
                return null;
            }
            return new VCPKGVersion.VCPKGNumberVersion(numbers);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final VCPKGVersion.VCPKGDateVersion parseDateVersion(@NotNull String s) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Matcher dateSeparatedMatch = DATE_VERSION_REGEX.matcher(s);
            if (!dateSeparatedMatch.find()) {
                return null;
            }
            Object object = dateSeparatedMatch.group("year");
            if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return null;
            }
            int year = (Integer)object;
            Object object2 = dateSeparatedMatch.group("month");
            if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                return null;
            }
            int month = (Integer)object2;
            Object object3 = dateSeparatedMatch.group("day");
            if (object3 == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
                return null;
            }
            int day = (Integer)object3;
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)s, (String)(year + "-" + month + "-" + day), null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                if (n == null) {
                    return null;
                }
                collection.add(Integer.valueOf(n));
            }
            List numbers = (List)destination$iv$iv;
            return new VCPKGVersion.VCPKGDateVersion(year, month, day, numbers);
        }

        private final VCPKGVersion.VCPKGStringVersion parseStringVersion(String s) {
            if (STRING_VERSION.matches((CharSequence)s)) {
                return new VCPKGVersion.VCPKGStringVersion(s);
            }
            return null;
        }

        private final VCPKGVersion parseVersion(String s) {
            VCPKGVersion vCPKGVersion;
            VCPKGVersion.VCPKGSemverVersion vCPKGSemverVersion = this.parseSemverVersion(s);
            if (vCPKGSemverVersion != null) {
                vCPKGVersion = vCPKGSemverVersion;
            } else {
                VCPKGVersion.VCPKGNumberVersion vCPKGNumberVersion = this.parseDotSeparatedVersion(s);
                if (vCPKGNumberVersion != null) {
                    vCPKGVersion = vCPKGNumberVersion;
                } else {
                    VCPKGVersion.VCPKGDateVersion vCPKGDateVersion = this.parseDateVersion(s);
                    vCPKGVersion = vCPKGDateVersion != null ? (VCPKGVersion)vCPKGDateVersion : (VCPKGVersion)this.parseStringVersion(s);
                }
            }
            return vCPKGVersion;
        }

        @Nullable
        public final VCPKGVersionWithPort parseVersionWithPort(@NotNull String s) {
            Integer port;
            VCPKGVersion vCPKGVersion;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String[] stringArray = new String[]{"#"};
            List splitted = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (splitted.size() > 2) {
                return null;
            }
            String string = (String)CollectionsKt.getOrNull((List)splitted, (int)0);
            if (string != null) {
                String it = string;
                boolean bl = false;
                vCPKGVersion = Companion.parseVersion(it);
            } else {
                vCPKGVersion = null;
            }
            VCPKGVersion version = vCPKGVersion;
            String string2 = (String)CollectionsKt.getOrNull((List)splitted, (int)1);
            Integer n = port = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
            if (version != null) {
                return new VCPKGVersionWithPort(version, port);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getParseableLines(String startPhrase, String s) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean isTakeLines = false;
            List correctLines = new ArrayList();
            for (String line : lines) {
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)startPhrase, (boolean)false, (int)2, null)) {
                    isTakeLines = true;
                    continue;
                }
                Character c = StringsKt.firstOrNull((CharSequence)line);
                boolean bl = c != null ? CharsKt.isWhitespace((char)c.charValue()) : false;
                if (bl && isTakeLines) {
                    correctLines.add(line);
                    continue;
                }
                isTakeLines = false;
            }
            Iterable iterable = correctLines;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void $this$trim$iv = line;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char c = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = CharsKt.isWhitespace((char)c) || c == '*';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                collection.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final String parseName(String s) {
            if (NAME_REGEX.matches((CharSequence)s)) {
                return s;
            }
            return null;
        }

        private final String parseTriplet(String s) {
            if (TRIPLET_REGEX.matches((CharSequence)s)) {
                return s;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final String parseNameWithFeatures(String s) {
            if (StringsKt.contains$default((CharSequence)s, (CharSequence)"[", (boolean)false, (int)2, null)) {
                void $this$filterTo$iv$iv;
                String[] stringArray = new String[]{"["};
                List nameAndFeatures = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (nameAndFeatures.size() != 2) {
                    return null;
                }
                String string = this.parseName((String)nameAndFeatures.get(0));
                if (string == null) {
                    return null;
                }
                String name = string;
                String[] it = (String[])nameAndFeatures.get(1);
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)((CharSequence)it)) || StringsKt.last((CharSequence)((CharSequence)it)) != ']') {
                    return null;
                }
                String string2 = it.substring(0, it.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String nonParsedFeatures = string2;
                it = new String[]{","};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)nonParsedFeatures, (String[])it, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)"core"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List features = (List)destination$iv$iv;
                return name + (features.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)features, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null));
            }
            return this.parseName(s);
        }

        private final Pair<String, String> parseNameWithFeatureAndTriplet(String s) {
            String[] stringArray = new String[]{":"};
            List splitted = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (splitted.size() != 2) {
                return null;
            }
            String string = this.parseNameWithFeatures((String)splitted.get(0));
            if (string == null) {
                return null;
            }
            String nameWithFeature = string;
            String string2 = this.parseTriplet((String)splitted.get(1));
            if (string2 == null) {
                return null;
            }
            String triplet = string2;
            return new Pair((Object)nameWithFeature, (Object)triplet);
        }

        private final PackageNameWithTriplet parseNameWithTriplet(String s) {
            String[] stringArray = new String[]{":"};
            List splitted = StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (splitted.size() != 2) {
                return null;
            }
            String string = this.parseName((String)splitted.get(0));
            if (string == null) {
                return null;
            }
            String nameWithFeature = string;
            String string2 = this.parseTriplet((String)splitted.get(1));
            if (string2 == null) {
                return null;
            }
            String triplet = string2;
            return new PackageNameWithTriplet(nameWithFeature, triplet);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VCPKGTripletPackage> parseInstallConsoleOutput(@NotNull String s) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Iterable $this$mapNotNull$iv = this.getParseableLines("The following packages will be", s);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VCPKGTripletPackage it$iv$iv;
                VCPKGVersionWithPort version;
                Pair<String, String> nameWithFeatureAndTriplet;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String candidate = (String)element$iv$iv;
                boolean bl2 = false;
                Regex regex = new Regex("@|->");
                CharSequence charSequence = candidate;
                int n = 0;
                List splitted = regex.split(charSequence, n);
                if ((splitted.size() != 2 ? null : (Companion.parseNameWithFeatureAndTriplet(((Object)StringsKt.trim((CharSequence)((String)splitted.get(0)))).toString()) == null ? null : (Companion.parseVersionWithPort(((Object)StringsKt.trim((CharSequence)((String)splitted.get(1)))).toString()) == null ? null : new VCPKGTripletPackage((String)nameWithFeatureAndTriplet.getFirst(), (String)nameWithFeatureAndTriplet.getSecond(), version)))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PackageNameWithTriplet> parseRemoveConsoleOutput(@NotNull String s) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Iterable $this$mapNotNull$iv = this.getParseableLines("The following packages will be", s);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String candidate = (String)element$iv$iv;
                boolean bl2 = false;
                PackageNameWithTriplet packageNameWithTriplet = Companion.parseNameWithTriplet(candidate);
                if (packageNameWithTriplet == null) {
                    packageNameWithTriplet = null;
                }
                if (packageNameWithTriplet == null) continue;
                PackageNameWithTriplet it$iv$iv = packageNameWithTriplet;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<PackageNameWithTriplet, Pair<VCPKGVersionWithPort, VCPKGVersionWithPort>>> parseUpdateConsoleOutput(@NotNull String s) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Iterable $this$mapNotNull$iv = this.getParseableLines("The following packages differ from", s);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String candidate = (String)element$iv$iv;
                boolean bl2 = false;
                Regex regex = new Regex(" ");
                CharSequence charSequence = candidate;
                int n = 2;
                List splittedByFirstSpace = regex.split(charSequence, n);
                if (splittedByFirstSpace.size() != 2) {
                    pair = null;
                } else if (Companion.parseNameWithTriplet((String)splittedByFirstSpace.get(0)) == null) {
                    pair = null;
                } else {
                    VCPKGVersionWithPort versionTo;
                    VCPKGVersionWithPort versionFrom;
                    PackageNameWithTriplet nameWithTriplet;
                    String[] stringArray = new String[]{"->"};
                    List versions = StringsKt.split$default((CharSequence)((CharSequence)splittedByFirstSpace.get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    pair = versions.size() != 2 ? null : (Companion.parseVersionWithPort(((Object)StringsKt.trim((CharSequence)((String)versions.get(0)))).toString()) == null ? null : (Companion.parseVersionWithPort(((Object)StringsKt.trim((CharSequence)((String)versions.get(1)))).toString()) == null ? null : new Pair((Object)nameWithTriplet, (Object)new Pair((Object)versionFrom, (Object)versionTo))));
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<VCPKGTripletPackage> parseUpgradeConsoleOutput(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.parseInstallConsoleOutput(s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

