/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.zephyr.binding;

import com.intellij.dts.api.DtsTreeSearchKt;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.zephyr.DtsZephyrProvider;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingSerachKt;
import com.intellij.dts.zephyr.binding.DtsZephyrBundledBindings;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/dts/zephyr/DtsZephyrProvider;", "getProvider", "()Lcom/intellij/dts/zephyr/DtsZephyrProvider;", "getAllBindings", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "getBinding", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "compatible", "", "", "getBindings", "Companion", "intellij.dts"})
public final class DtsZephyrBindingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public DtsZephyrBindingProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DtsZephyrProvider getProvider() {
        return DtsZephyrProvider.Companion.of(this.project);
    }

    @NotNull
    public final Collection<DtsZephyrBinding> getBindings(@NotNull String compatible) {
        Intrinsics.checkNotNullParameter((Object)compatible, (String)"compatible");
        Collection collection = this.getProvider().getBindings().get((Object)compatible);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    @Nullable
    public final DtsZephyrBinding getBinding(@NotNull DtsNode node, @NotNull List<String> compatible) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(compatible, (String)"compatible");
        return DtsZephyrBindingSerachKt.searchBinding(this.getProvider().getBindings(), node, compatible);
    }

    @Nullable
    public final DtsZephyrBinding getBinding(@NotNull DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBinding(node, DtsPsiUtilKt.getDtsCompatibleStrings(node));
    }

    @NotNull
    public final Collection<DtsZephyrBinding> getAllBindings() {
        Collection collection = this.getProvider().getBindings().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        return collection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0003\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion;", "", "()V", "bindingFor", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "fallbackBinding", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrPropertyBinding;", "property", "Lcom/intellij/dts/lang/psi/DtsProperty;", "of", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.dts"})
    @SourceDebugExtension(value={"SMAP\nDtsZephyrBindingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsZephyrBindingProvider.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n31#2,2:64\n*S KotlinDebug\n*F\n+ 1 DtsZephyrBindingProvider.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBindingProvider$Companion\n*L\n16#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtsZephyrBindingProvider of(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DtsZephyrBindingProvider> serviceClass$iv = DtsZephyrBindingProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DtsZephyrBindingProvider)object;
        }

        @Nullable
        public final DtsZephyrBinding bindingFor(@NotNull DtsNode node, boolean fallbackBinding) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DtsZephyrBindingProvider provider = this.of(project);
            DtsZephyrBinding nodeBinding2 = (DtsZephyrBinding)DtsTreeSearchKt.dtsSearch$default(node, false, null, (Function1)new Function1<DtsNode, DtsZephyrBinding>((Object)provider){

                @Nullable
                public final DtsZephyrBinding invoke(@NotNull DtsNode p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DtsZephyrBindingProvider)this.receiver).getBinding(p0);
                }
            }, 2, null);
            if (nodeBinding2 != null || !fallbackBinding) {
                return nodeBinding2;
            }
            return DtsZephyrBundledBindings.Companion.getInstance().getBinding("fallback");
        }

        public static /* synthetic */ DtsZephyrBinding bindingFor$default(Companion companion, DtsNode dtsNode, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.bindingFor(dtsNode, bl);
        }

        @Nullable
        public final DtsZephyrPropertyBinding bindingFor(@NotNull DtsProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            DtsNode dtsNode = DtsTreeUtil.INSTANCE.parentNode(property2);
            if (dtsNode == null) {
                return null;
            }
            DtsNode parent2 = dtsNode;
            Object object = com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider$Companion.bindingFor$default(this, parent2, false, 2, null);
            return object != null && (object = ((DtsZephyrBinding)object).getProperties()) != null ? (DtsZephyrPropertyBinding)object.get(property2.getDtsName()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

