/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.settings.DtsSettingsInputStatus;
import com.intellij.dts.util.Either;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0004J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J:\u0010\u0017\u001a\u001d\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a\u0012\u0004\u0012\u00028\u00010\u0018j\b\u0012\u0004\u0012\u00028\u0001`\u001b2\u0015\u0010\u001c\u001a\u00110\u0019\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001fH\u0004J:\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00028\u00002!\u0010\"\u001a\u001d\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a\u0012\u0004\u0012\u00028\u00010\u0018j\b\u0012\u0004\u0012\u00028\u0001`\u001bH\u0014\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0011H\u0002J0\u0010)\u001a\u001d\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a\u0012\u0004\u0012\u00028\u00010\u0018j\b\u0012\u0004\u0012\u00028\u0001`\u001b2\u0006\u0010!\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010*J\r\u0010+\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010,J0\u0010-\u001a\u001d\u0012\t\u0012\u00070\u0019\u00a2\u0006\u0002\b\u001a\u0012\u0004\u0012\u00028\u00010\u0018j\b\u0012\u0004\u0012\u00028\u0001`\u001b2\u0006\u0010\"\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/dts/settings/DtsSettingsInputStatus;", "State", "T", "", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "listeners", "", "Lkotlin/Function1;", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "cancel", "", "check", "enableAndCheck", "error", "Lcom/intellij/dts/util/Either;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/dts/settings/Result;", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DtsBundle", "evaluate", "state", "result", "(Ljava/lang/Object;Lcom/intellij/dts/util/Either;)Lcom/intellij/openapi/ui/ValidationInfo;", "installOn", "component", "Ljavax/swing/JComponent;", "notify", "info", "performCheck", "(Ljava/lang/Object;)Lcom/intellij/dts/util/Either;", "readState", "()Ljava/lang/Object;", "success", "intellij.dts"})
public abstract class DtsSettingsInputStatus<State, T> {
    @Nullable
    private final Disposable disposable;
    @NotNull
    private final List<Function1<ValidationInfo, Unit>> listeners;
    @NotNull
    private final Alarm alarm;
    private boolean isEnabled;

    public DtsSettingsInputStatus(@Nullable Disposable disposable) {
        this.disposable = disposable;
        this.listeners = new ArrayList();
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
        this.isEnabled = true;
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    protected abstract State readState();

    @NotNull
    protected abstract Either<String, T> performCheck(State var1);

    @Nullable
    protected ValidationInfo evaluate(State state, @NotNull Either<String, ? extends T> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return (ValidationInfo)result.fold(evaluate.1.INSTANCE, evaluate.2.INSTANCE);
    }

    @NotNull
    protected final Either<String, T> success(T result) {
        return new Either.Right<T>(result);
    }

    @NotNull
    protected final Either<String, T> error(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new Either.Left<String>(DtsBundle.Companion.message(key, new Object[0]));
    }

    @NotNull
    protected final Void cancel() {
        throw new CancellationException();
    }

    public final void check() {
        this.alarm.cancelAllRequests();
        State state = this.readState();
        this.alarm.addRequest(() -> DtsSettingsInputStatus.check$lambda$2(this, state), 300);
    }

    private final void notify(ValidationInfo info) {
        if (!this.isEnabled) {
            return;
        }
        for (Function1<ValidationInfo, Unit> listener2 : this.listeners) {
            listener2.invoke((Object)info);
        }
    }

    public final void installOn(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Disposable disposable = this.disposable;
        if (disposable == null) {
            return;
        }
        Disposable disposable2 = disposable;
        ComponentValidator validator = new ComponentValidator(disposable2).installOn(component);
        this.listeners.add(new Function1<ValidationInfo, Unit>(validator, component){
            final /* synthetic */ ComponentValidator $validator;
            final /* synthetic */ JComponent $component;
            {
                this.$validator = $validator;
                this.$component = $component;
                super(1);
            }

            public final void invoke(@Nullable ValidationInfo info) {
                ValidationInfo validationInfo = info;
                this.$validator.updateInfo(validationInfo != null ? validationInfo.forComponent(this.$component) : null);
            }
        });
    }

    public final void enableAndCheck() {
        this.isEnabled = true;
        this.check();
    }

    private static final void check$lambda$2$lambda$0(DtsSettingsInputStatus this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.notify(null);
    }

    private static final void check$lambda$2$lambda$1(DtsSettingsInputStatus this$0, Object $state, Either $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        this$0.notify(this$0.evaluate($state, $result));
    }

    private static final void check$lambda$2(DtsSettingsInputStatus this$0, Object $state) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            either = this$0.performCheck($state);
        }
        catch (CancellationException e) {
            UIUtil.invokeLaterIfNeeded(() -> DtsSettingsInputStatus.check$lambda$2$lambda$0(this$0));
            return;
        }
        Either result = either;
        UIUtil.invokeLaterIfNeeded(() -> DtsSettingsInputStatus.check$lambda$2$lambda$1(this$0, $state, result));
    }
}

