/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.settings.BoardComboBox;
import com.intellij.dts.settings.DtsSettings;
import com.intellij.dts.settings.DtsSettingsConfigurable;
import com.intellij.dts.settings.DtsSettingsDisabler;
import com.intellij.dts.settings.DtsSettingsInputStatus;
import com.intellij.dts.settings.RootComboBox;
import com.intellij.dts.util.DtsUtil;
import com.intellij.dts.util.Either;
import com.intellij.dts.zephyr.DtsZephyrFileUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J+\u0010\u000e\u001a\u001d\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u0011\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J+\u0010\u0014\u001a\u001d\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u0011\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dts/settings/DtsSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "enableSync", "", "state", "Lcom/intellij/dts/settings/DtsSettings$State;", "apply", "", "createActualPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createPanel", "validateBoard", "Lcom/intellij/dts/util/Either;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/dts/settings/Result;", "path", "validateRoot", "intellij.dts"})
public final class DtsSettingsConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final DtsSettings.State state;
    private final boolean enableSync;

    public DtsSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(DtsBundle.Companion.message("settings.name", new Object[0]), "devitree.zephyr.settings", "com.intellij.dts.settings.DtsSettingsConfigurable");
        this.project = project;
        this.state = DtsSettings.Companion.of(this.project).getState();
        this.enableSync = DtsUtil.INSTANCE.isCMakeAvailable(this.project);
    }

    private final Either<String, String> validateRoot(String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            VirtualFile virtualFile = DtsZephyrFileUtil.INSTANCE.searchForRoot(this.project);
            if (virtualFile == null) {
                return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.not_found", new Object[0]));
            }
            VirtualFile root = virtualFile;
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return new Either.Right<String>(string);
        }
        VirtualFile virtualFile = DtsUtil.INSTANCE.findFileAndRefresh(path, new String[0]);
        if (virtualFile == null) {
            return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.not_found", new Object[0]));
        }
        VirtualFile root = virtualFile;
        if (!DtsZephyrFileUtil.INSTANCE.isValid(root)) {
            return new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.root.invalid", new Object[0]));
        }
        return new Either.Right<String>(path);
    }

    private final Either<String, String> validateBoard(String path) {
        return DtsUtil.INSTANCE.findFileAndRefresh(path, new String[0]) == null ? (Either)new Either.Left<String>(DtsBundle.Companion.message("settings.zephyr.board.not_found", new Object[0])) : (Either)new Either.Right<String>(path);
    }

    @NotNull
    public DialogPanel createPanel() {
        if (DtsSettingsDisabler.Companion.shouldBeDisabled$intellij_dts(this.project)) {
            return BuilderKt.panel((Function1)createPanel.1.INSTANCE);
        }
        return this.createActualPanel();
    }

    private final DialogPanel createActualPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DtsSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                JCheckBox syncInput = ComponentsKt.CheckBox$default((String)DtsBundle.Companion.message("settings.zephyr.sync_with_cmake", new Object[0]), (boolean)false, null, (int)6, null);
                syncInput.setEnabled(DtsSettingsConfigurable.access$getEnableSync$p(this.this$0));
                RootComboBox rootInput = new RootComboBox(DtsSettingsConfigurable.access$getDisposable(this.this$0));
                BoardComboBox boardInput = new BoardComboBox(DtsSettingsConfigurable.access$getDisposable(this.this$0), DtsSettingsConfigurable.access$getState$p(this.this$0).getZephyrBoard());
                Disposable disposable = DtsSettingsConfigurable.access$getDisposable(this.this$0);
                DtsSettingsInputStatus<String, String> rootStatus2 = new DtsSettingsInputStatus<String, String>(rootInput, this.this$0, disposable){
                    final /* synthetic */ RootComboBox $rootInput;
                    final /* synthetic */ DtsSettingsConfigurable this$0;
                    {
                        this.$rootInput = $rootInput;
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                        this.setEnabled(false);
                    }

                    @NotNull
                    protected String readState() {
                        String state = this.$rootInput.getText();
                        if (StringsKt.isBlank((CharSequence)state)) {
                            this.$rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.ongoing", new Object[0]));
                        } else {
                            this.$rootInput.setEmptyText("");
                        }
                        return state;
                    }

                    @NotNull
                    protected Either<String, String> performCheck(@NotNull String state) {
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        return DtsSettingsConfigurable.access$validateRoot(this.this$0, state);
                    }

                    @Nullable
                    protected ValidationInfo evaluate(@NotNull String state, @NotNull Either<String, String> result) {
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        if (StringsKt.isBlank((CharSequence)state)) {
                            result.fold((Function1)new Function1<String, Unit>(this.$rootInput){
                                final /* synthetic */ RootComboBox $rootInput;
                                {
                                    this.$rootInput = $rootInput;
                                    super(1);
                                }

                                public final void invoke(@NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    this.$rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.failed", new Object[0]));
                                }
                            }, (Function1)new Function1<String, Unit>(this.$rootInput){
                                final /* synthetic */ RootComboBox $rootInput;
                                {
                                    this.$rootInput = $rootInput;
                                    super(1);
                                }

                                public final void invoke(@NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    Object[] objectArray = new Object[]{it};
                                    this.$rootInput.setEmptyText(DtsBundle.Companion.message("settings.zephyr.root.detecting.success", objectArray));
                                }
                            });
                        }
                        return super.evaluate(state, result);
                    }
                };
                Disposable disposable2 = DtsSettingsConfigurable.access$getDisposable(this.this$0);
                DtsSettingsInputStatus<String, String> boardStatus2 = new DtsSettingsInputStatus<String, String>(boardInput, this.this$0, disposable2){
                    final /* synthetic */ BoardComboBox $boardInput;
                    final /* synthetic */ DtsSettingsConfigurable this$0;
                    {
                        this.$boardInput = $boardInput;
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                        this.setEnabled(false);
                    }

                    @NotNull
                    protected String readState() {
                        return this.$boardInput.getText();
                    }

                    @NotNull
                    protected Either<String, String> performCheck(@NotNull String state) {
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        return DtsSettingsConfigurable.access$validateBoard(this.this$0, state);
                    }
                };
                Disposable disposable3 = DtsSettingsConfigurable.access$getDisposable(this.this$0);
                DtsSettingsInputStatus<String, List<? extends String>> updateBoardList2 = new DtsSettingsInputStatus<String, List<? extends String>>(rootInput, this.this$0, boardInput, syncInput, disposable3){
                    final /* synthetic */ RootComboBox $rootInput;
                    final /* synthetic */ DtsSettingsConfigurable this$0;
                    final /* synthetic */ BoardComboBox $boardInput;
                    final /* synthetic */ JCheckBox $syncInput;
                    {
                        this.$rootInput = $rootInput;
                        this.this$0 = $receiver;
                        this.$boardInput = $boardInput;
                        this.$syncInput = $syncInput;
                        super($super_call_param$1);
                    }

                    @NotNull
                    protected String readState() {
                        return this.$rootInput.getText();
                    }

                    @NotNull
                    protected Either<String, List<String>> performCheck(@NotNull String state) {
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        return DtsSettingsConfigurable.access$validateRoot(this.this$0, state).mapRight(createActualPanel.updateBoardList.performCheck.1.INSTANCE);
                    }

                    @Nullable
                    protected ValidationInfo evaluate(@NotNull String state, @NotNull Either<String, ? extends List<String>> result) {
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        result.fold((Function1)new Function1<String, Unit>(this.$boardInput){
                            final /* synthetic */ BoardComboBox $boardInput;
                            {
                                this.$boardInput = $boardInput;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$boardInput.setEnabled(false);
                                this.$boardInput.clearBoards();
                            }
                        }, (Function1)new Function1<List<? extends String>, Unit>(this.$boardInput, this.$syncInput){
                            final /* synthetic */ BoardComboBox $boardInput;
                            final /* synthetic */ JCheckBox $syncInput;
                            {
                                this.$boardInput = $boardInput;
                                this.$syncInput = $syncInput;
                                super(1);
                            }

                            public final void invoke(@NotNull List<String> boards) {
                                Intrinsics.checkNotNullParameter(boards, (String)"boards");
                                this.$boardInput.setEnabled(!this.$syncInput.isSelected());
                                this.$boardInput.setBoards(boards);
                            }
                        });
                        return super.evaluate(state, result);
                    }
                };
                Panel.group$default((Panel)$this$panel, (String)DtsBundle.Companion.message("settings.zephyr.group", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(syncInput, this.this$0, rootInput, boardInput){
                    final /* synthetic */ JCheckBox $syncInput;
                    final /* synthetic */ DtsSettingsConfigurable this$0;
                    final /* synthetic */ RootComboBox $rootInput;
                    final /* synthetic */ BoardComboBox $boardInput;
                    {
                        this.$syncInput = $syncInput;
                        this.this$0 = $receiver;
                        this.$rootInput = $rootInput;
                        this.$boardInput = $boardInput;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.$syncInput, this.this$0){
                            final /* synthetic */ JCheckBox $syncInput;
                            final /* synthetic */ DtsSettingsConfigurable this$0;
                            {
                                this.$syncInput = $syncInput;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)this.$syncInput).bind((Function1)createActualPanel.1.INSTANCE, (Function2)new Function2<JCheckBox, Boolean, Unit>(this.this$0){
                                    final /* synthetic */ DtsSettingsConfigurable this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull JCheckBox input, boolean value) {
                                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                                        input.setSelected(value && DtsSettingsConfigurable.access$getEnableSync$p(this.this$0));
                                    }
                                }, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(DtsSettingsConfigurable.access$getState$p(this.this$0)){

                                    @Nullable
                                    public Object get() {
                                        return ((DtsSettings.State)this.receiver).getZephyrCMakeSync();
                                    }

                                    public void set(@Nullable Object value) {
                                        ((DtsSettings.State)this.receiver).setZephyrCMakeSync((Boolean)value);
                                    }
                                })));
                            }
                        }), (int)1, null);
                        $this$group.row(DtsBundle.Companion.message("settings.zephyr.root", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.$rootInput, this.this$0){
                            final /* synthetic */ RootComboBox $rootInput;
                            final /* synthetic */ DtsSettingsConfigurable this$0;
                            {
                                this.$rootInput = $rootInput;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)((Object)this.$rootInput)).resizableColumn().bind((Function1)createActualPanel.1.INSTANCE, (Function2)createActualPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(DtsSettingsConfigurable.access$getState$p(this.this$0)){

                                    @Nullable
                                    public Object get() {
                                        return ((DtsSettings.State)this.receiver).getZephyrRoot();
                                    }

                                    public void set(@Nullable Object value) {
                                        ((DtsSettings.State)this.receiver).setZephyrRoot((String)value);
                                    }
                                }))).align((Align)AlignX.FILL.INSTANCE);
                            }
                        });
                        $this$group.row(DtsBundle.Companion.message("settings.zephyr.board", new Object[0]) + ":", (Function1)new Function1<Row, Unit>(this.$boardInput, this.this$0){
                            final /* synthetic */ BoardComboBox $boardInput;
                            final /* synthetic */ DtsSettingsConfigurable this$0;
                            {
                                this.$boardInput = $boardInput;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)((Object)this.$boardInput)).resizableColumn().bind((Function1)createActualPanel.1.INSTANCE, (Function2)createActualPanel.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(DtsSettingsConfigurable.access$getState$p(this.this$0)){

                                    @Nullable
                                    public Object get() {
                                        return ((DtsSettings.State)this.receiver).getZephyrBoard();
                                    }

                                    public void set(@Nullable Object value) {
                                        ((DtsSettings.State)this.receiver).setZephyrBoard((String)value);
                                    }
                                }))).align((Align)AlignX.FILL.INSTANCE);
                            }
                        });
                    }
                }), (int)2, null);
                rootStatus2.installOn((JComponent)((Object)rootInput));
                rootInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)rootStatus2){

                    public final void invoke() {
                        (this.receiver).check();
                    }
                }));
                rootInput.onFocusLost((Function0<Unit>)((Function0)new Function0<Unit>((Object)rootStatus2){

                    public final void invoke() {
                        (this.receiver).enableAndCheck();
                    }
                }));
                boardStatus2.installOn((JComponent)((Object)boardInput));
                boardInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)boardStatus2){

                    public final void invoke() {
                        (this.receiver).check();
                    }
                }));
                boardInput.onFocusLost((Function0<Unit>)((Function0)new Function0<Unit>((Object)boardStatus2){

                    public final void invoke() {
                        (this.receiver).enableAndCheck();
                    }
                }));
                rootInput.onTextChanged((Function0<Unit>)((Function0)new Function0<Unit>((Object)updateBoardList2){

                    public final void invoke() {
                        (this.receiver).check();
                    }
                }));
                syncInput.addChangeListener(arg_0 -> createActualPanel.1.invoke$lambda$0(syncInput, rootInput, boardInput, updateBoardList2, arg_0));
                rootStatus2.check();
                updateBoardList2.check();
                if (syncInput.isSelected()) {
                    rootInput.setEnabled(false);
                    boardInput.setEnabled(false);
                }
            }

            private static final void invoke$lambda$0(JCheckBox $syncInput, RootComboBox $rootInput, BoardComboBox $boardInput, createActualPanel.updateBoardList.1 $updateBoardList, ChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)$syncInput, (String)"$syncInput");
                Intrinsics.checkNotNullParameter((Object)((Object)$rootInput), (String)"$rootInput");
                Intrinsics.checkNotNullParameter((Object)((Object)$boardInput), (String)"$boardInput");
                Intrinsics.checkNotNullParameter((Object)$updateBoardList, (String)"$updateBoardList");
                if ($syncInput.isSelected()) {
                    $rootInput.setEnabled(false);
                    $boardInput.setEnabled(false);
                } else {
                    $rootInput.setEnabled(!$syncInput.isSelected());
                    $updateBoardList.check();
                }
            }
        }));
    }

    public void apply() {
        super.apply();
        DtsSettings.Companion.of(this.project).update((Function1<? super DtsSettings.State, Unit>)((Function1)new Function1<DtsSettings.State, Unit>(this){
            final /* synthetic */ DtsSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DtsSettings.State $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                $this$update.setZephyrRoot(DtsSettingsConfigurable.access$getState$p(this.this$0).getZephyrRoot());
                $this$update.setZephyrBoard(DtsSettingsConfigurable.access$getState$p(this.this$0).getZephyrBoard());
                $this$update.setZephyrCMakeSync(DtsSettingsConfigurable.access$getState$p(this.this$0).getZephyrCMakeSync());
            }
        }));
    }

    public static final /* synthetic */ boolean access$getEnableSync$p(DtsSettingsConfigurable $this) {
        return $this.enableSync;
    }

    public static final /* synthetic */ Disposable access$getDisposable(DtsSettingsConfigurable $this) {
        return $this.getDisposable();
    }

    public static final /* synthetic */ DtsSettings.State access$getState$p(DtsSettingsConfigurable $this) {
        return $this.state;
    }

    public static final /* synthetic */ Either access$validateRoot(DtsSettingsConfigurable $this, String path) {
        return $this.validateRoot(path);
    }

    public static final /* synthetic */ Either access$validateBoard(DtsSettingsConfigurable $this, String path) {
        return $this.validateBoard(path);
    }
}

