/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.dts.lang.DtsLanguage;
import com.intellij.dts.settings.DtsCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/settings/DtsCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsProvider;", "()V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "getConfigurableDisplayName", "", "Configurable", "MainPanel", "intellij.dts"})
public final class DtsCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public String getConfigurableDisplayName() {
        return DtsLanguage.INSTANCE.getDisplayName();
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        return new DtsCodeStyleSettings(settings2);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings2, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        return (CodeStyleConfigurable)new Configurable(settings2, modelSettings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dts/settings/DtsCodeStyleSettingsProvider$Configurable;", "Lcom/intellij/application/options/CodeStyleAbstractConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "createPanel", "Lcom/intellij/application/options/CodeStyleAbstractPanel;", "getHelpTopic", "", "intellij.dts"})
    private static final class Configurable
    extends CodeStyleAbstractConfigurable {
        public Configurable(@NotNull CodeStyleSettings settings2, @NotNull CodeStyleSettings modelSettings) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
            super(settings2, modelSettings, DtsLanguage.INSTANCE.getDisplayName());
        }

        @NotNull
        public String getHelpTopic() {
            return "devicetree.codestyle.settings";
        }

        @NotNull
        protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCurrentSettings(...)");
            return (CodeStyleAbstractPanel)new MainPanel(codeStyleSettings, settings2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/dts/settings/DtsCodeStyleSettingsProvider$MainPanel;", "Lcom/intellij/application/options/TabbedLanguageCodeStylePanel;", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "intellij.dts"})
    private static final class MainPanel
    extends TabbedLanguageCodeStylePanel {
        public MainPanel(@NotNull CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)currentSettings, (String)"currentSettings");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            super((Language)DtsLanguage.INSTANCE, currentSettings, settings2);
        }
    }
}

