/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.resolve;

import com.intellij.dts.lang.psi.FileInclude;
import com.intellij.dts.lang.psi.PsiFileInclude;
import com.intellij.dts.util.DtsTextRangeKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/dts/lang/resolve/FileIncludeReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "textRange", "Lcom/intellij/openapi/util/TextRange;", "include", "Lcom/intellij/dts/lang/psi/FileInclude;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/dts/lang/psi/FileInclude;)V", "getInclude", "()Lcom/intellij/dts/lang/psi/FileInclude;", "resolve", "Companion", "intellij.dts"})
public final class FileIncludeReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileInclude include;

    private FileIncludeReference(PsiElement element, TextRange textRange, FileInclude include) {
        super(element, textRange, true);
        this.include = include;
    }

    @NotNull
    public final FileInclude getInclude() {
        return this.include;
    }

    @Nullable
    public PsiElement resolve() {
        PsiFile psiFile = this.getElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return (PsiElement)this.include.resolve(psiFile);
    }

    public /* synthetic */ FileIncludeReference(PsiElement element, TextRange textRange, FileInclude include, DefaultConstructorMarker $constructor_marker) {
        this(element, textRange, include);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/dts/lang/resolve/FileIncludeReference$Companion;", "", "()V", "create", "Lcom/intellij/dts/lang/resolve/FileIncludeReference;", "element", "Lcom/intellij/dts/lang/psi/PsiFileInclude;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FileIncludeReference create(@NotNull PsiFileInclude element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            TextRange textRange = element.getFileIncludeRange();
            if (textRange == null) {
                return null;
            }
            TextRange range = textRange;
            FileInclude fileInclude = element.getFileInclude();
            if (fileInclude == null) {
                return null;
            }
            FileInclude include = fileInclude;
            PsiElement psiElement = element;
            TextRange textRange2 = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
            return new FileIncludeReference(psiElement, DtsTextRangeKt.relativeTo(range, textRange2), include, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

