/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.dts.documentation.DtsBindingDocumentation;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsString;
import com.intellij.dts.lang.symbols.DtsBindingSymbol;
import com.intellij.dts.lang.symbols.DtsDocumentationSymbol;
import com.intellij.dts.util.DtsTextRangeKt;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.util.DtsUtil;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dts/lang/resolve/DtsBindingReference;", "Lcom/intellij/model/psi/PsiSymbolReference;", "Lcom/intellij/model/psi/PsiCompletableReference;", "element", "Lcom/intellij/dts/lang/psi/DtsString;", "(Lcom/intellij/dts/lang/psi/DtsString;)V", "getCompletionVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "resolveReference", "", "Lcom/intellij/model/Symbol;", "intellij.dts"})
public final class DtsBindingReference
implements PsiSymbolReference,
PsiCompletableReference {
    @NotNull
    private final DtsString element;

    public DtsBindingReference(@NotNull DtsString element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
    }

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.element.getDtsValueRange();
        TextRange textRange2 = this.element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
        return DtsTextRangeKt.relativeTo(textRange, textRange2);
    }

    @NotNull
    public Collection<Symbol> resolveReference() {
        DtsNode dtsNode = DtsTreeUtil.INSTANCE.parentNode(this.element);
        if (dtsNode == null) {
            return CollectionsKt.emptyList();
        }
        DtsNode node = dtsNode;
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DtsZephyrBindingProvider provider = DtsZephyrBindingProvider.Companion.of(project);
        DtsZephyrBinding dtsZephyrBinding = provider.getBinding(node, CollectionsKt.listOf(this.element.dtsParse()));
        if (dtsZephyrBinding == null) {
            return CollectionsKt.emptyList();
        }
        DtsZephyrBinding binding = dtsZephyrBinding;
        return DtsUtil.INSTANCE.singleResult((Function0)new Function0<DtsBindingSymbol>(binding){
            final /* synthetic */ DtsZephyrBinding $binding;
            {
                this.$binding = $binding;
                super(0);
            }

            @Nullable
            public final DtsBindingSymbol invoke() {
                return new DtsBindingSymbol(this.$binding);
            }
        });
    }

    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        Project project = this.element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        List variants = new ArrayList();
        DtsZephyrBindingProvider provider = DtsZephyrBindingProvider.Companion.of(project2);
        for (DtsZephyrBinding binding : provider.getAllBindings()) {
            String compatible;
            if (binding.getCompatible() == null) continue;
            Pointer<? extends Symbol> symbol = DtsDocumentationSymbol.Companion.from(new DtsBindingDocumentation(project2, binding));
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(symbol, (String)compatible);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
            variants.add(lookupElementBuilder);
        }
        return variants;
    }
}

