/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.DtsUnitNameInspectionKt;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.dts.util.DtsUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/dts/inspections/DtsUnitNameInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkNodeName", "", "node", "Lcom/intellij/dts/lang/psi/DtsSubNode;", "intellij.dts"})
public final class DtsUnitNameInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsSubNode.class), (Function1)new Function1<DtsSubNode, Unit>(this, holder){
            final /* synthetic */ DtsUnitNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull DtsSubNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DtsUnitNameInspection.access$checkNodeName(this.this$0, it, this.$holder);
            }
        });
    }

    private final void checkNodeName(DtsSubNode node, ProblemsHolder holder) {
        Pair<String, String> pair = DtsUtil.INSTANCE.splitName(node.getDtsName());
        String baseName = (String)pair.component1();
        String addr = (String)pair.component2();
        if (addr == null) {
            return;
        }
        if (StringsKt.startsWith$default((String)addr, (String)"0x", (boolean)false, (int)2, null)) {
            DtsInspectionsUtilKt.registerProblem$default(holder, node, "inspections.unit_name.leading_0x", null, TextRange.from((int)(baseName.length() + 1), (int)addr.length()), null, 20, null);
            return;
        }
        if (DtsUnitNameInspectionKt.access$getLeading0s$p().matchesAt((CharSequence)addr, 0)) {
            DtsInspectionsUtilKt.registerProblem$default(holder, node, "inspections.unit_name.leading_0s", null, TextRange.from((int)(baseName.length() + 1), (int)addr.length()), null, 20, null);
        }
    }

    public static final /* synthetic */ void access$checkNodeName(DtsUnitNameInspection $this, DtsSubNode node, ProblemsHolder holder) {
        $this.checkNodeName(node, holder);
    }
}

