/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.inspections.DtsInspectionsUtilKt;
import com.intellij.dts.inspections.fixes.DtsRemovePropertyFix;
import com.intellij.dts.inspections.fixes.DtsRemoveSubNodeFix;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsVisitorKt;
import com.intellij.psi.PsiElementVisitor;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/inspections/DtsDuplicateElementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkProperties", "", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "checkSubNodes", "intellij.dts"})
public final class DtsDuplicateElementInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return DtsVisitorKt.dtsVisitor(Reflection.getOrCreateKotlinClass(DtsNode.class), (Function1)new Function1<DtsNode, Unit>(this, holder){
            final /* synthetic */ DtsDuplicateElementInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull DtsNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DtsDuplicateElementInspection.access$checkProperties(this.this$0, it, this.$holder);
                DtsDuplicateElementInspection.access$checkSubNodes(this.this$0, it, this.$holder);
            }
        });
    }

    private final void checkProperties(DtsNode node, ProblemsHolder holder) {
        Set properties = new LinkedHashSet();
        for (DtsProperty property2 : node.getDtsProperties()) {
            if (properties.add(property2.getDtsName())) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, property2, "inspections.duplicate_element.property_error", null, null, (LocalQuickFix)(property2.getDtsIsComplete() ? DtsRemovePropertyFix.INSTANCE : null), 12, null);
        }
    }

    private final void checkSubNodes(DtsNode node, ProblemsHolder holder) {
        Set subNodes = new LinkedHashSet();
        for (DtsSubNode subNode : node.getDtsSubNodes()) {
            if (subNodes.add(subNode.getDtsName())) continue;
            DtsInspectionsUtilKt.registerProblem$default(holder, subNode, "inspections.duplicate_element.sub_node_error", null, null, (LocalQuickFix)(subNode.getDtsIsComplete() ? DtsRemoveSubNodeFix.INSTANCE : null), 12, null);
        }
    }

    public static final /* synthetic */ void access$checkProperties(DtsDuplicateElementInspection $this, DtsNode node, ProblemsHolder holder) {
        $this.checkProperties(node, holder);
    }

    public static final /* synthetic */ void access$checkSubNodes(DtsDuplicateElementInspection $this, DtsNode node, ProblemsHolder holder) {
        $this.checkSubNodes(node, holder);
    }
}

