/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.highlighting;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.highlighting.DtsSyntaxAnnotator;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.util.DtsUtil;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\f\u001a\u00020\r*\u00020\b2\u0015\u0010\u000e\u001a\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/dts/highlighting/DtsSyntaxAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateChar", "annotatePHandle", "annotateString", "newAnnotation", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "bundleKey", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DtsBundle", "intellij.dts"})
public final class DtsSyntaxAnnotator
implements Annotator {
    private final AnnotationBuilder newAnnotation(AnnotationHolder $this$newAnnotation, String bundleKey) {
        AnnotationBuilder annotationBuilder = $this$newAnnotation.newAnnotation(HighlightSeverity.ERROR, DtsBundle.Companion.message(bundleKey, new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"newAnnotation(...)");
        return annotationBuilder;
    }

    private final void annotateChar(PsiElement element, AnnotationHolder holder) {
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.endsWith$default((CharSequence)string, (char)'\'', (boolean)false, (int)2, null)) {
            this.newAnnotation(holder, "syntax.unterminated_char").range(TextRange.from((int)PsiTreeUtilKt.getEndOffset((PsiElement)element), (int)0)).create();
        } else {
            String string2 = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            char[] cArray = new char[]{'\''};
            if (((CharSequence)StringsKt.trim((String)string2, (char[])cArray)).length() == 0) {
                this.newAnnotation(holder, "syntax.empty_char").range(element).create();
            }
        }
    }

    private final void annotateString(PsiElement element, AnnotationHolder holder) {
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.endsWith$default((CharSequence)string, (char)'\"', (boolean)false, (int)2, null)) {
            this.newAnnotation(holder, "syntax.unterminated_string").range(TextRange.from((int)PsiTreeUtilKt.getEndOffset((PsiElement)element), (int)0)).afterEndOfLine().create();
        }
    }

    private final void annotatePHandle(PsiElement element, AnnotationHolder holder) {
        Sequence whitespace2 = SequencesKt.filter((Sequence)DtsUtil.children$default(DtsUtil.INSTANCE, element, false, true, 2, null), (Function1)annotatePHandle.whitespace.1.INSTANCE);
        for (PsiElement child : whitespace2) {
            this.newAnnotation(holder, "syntax.invalid_whitespace").range(child).create();
        }
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)element);
        if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.CHAR_LITERAL)) {
            this.annotateChar(element, holder);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.STRING_LITERAL) ? true : Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.INCLUDE_PATH)) {
            this.annotateString(element, holder);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.P_HANDLE)) {
            this.annotatePHandle(element, holder);
        }
    }
}

