/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.formatting;

import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsArray;
import com.intellij.dts.lang.psi.DtsContainer;
import com.intellij.dts.lang.psi.DtsNodeContent;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPropertyContent;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.psi.DtsValue;
import com.intellij.dts.settings.DtsCodeStyleSettings;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00112\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\rH$J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\rH$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "getSettings", "()Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "getAlignment", "Lcom/intellij/formatting/Alignment;", "parent", "Lcom/intellij/formatting/Block;", "child", "Lcom/intellij/lang/ASTNode;", "Lcom/intellij/psi/PsiElement;", "getWrap", "Lcom/intellij/formatting/Wrap;", "Array", "Companion", "Container", "Null", "PropertyContent", "intellij.dts"})
public abstract class DtsWrappingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DtsCodeStyleSettings settings;

    public DtsWrappingBuilder(@NotNull DtsCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        this.settings = settings2;
    }

    @NotNull
    protected final DtsCodeStyleSettings getSettings() {
        return this.settings;
    }

    @Nullable
    public final Wrap getWrap(@Nullable Block parent2, @NotNull ASTNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        PsiElement parentElement = ASTBlock.getPsiElement((Block)parent2);
        PsiElement psiElement = child.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement childElement = psiElement;
        if (DtsTokenSets.INSTANCE.getComments().contains(child.getElementType())) {
            return null;
        }
        return this.getWrap(parentElement, childElement);
    }

    @Nullable
    public final Alignment getAlignment(@Nullable Block parent2, @NotNull ASTNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        PsiElement parentElement = ASTBlock.getPsiElement((Block)parent2);
        PsiElement psiElement = child.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement childElement = psiElement;
        if (DtsTokenSets.INSTANCE.getComments().contains(child.getElementType())) {
            return null;
        }
        return this.getAlignment(parentElement, childElement);
    }

    @Nullable
    protected abstract Wrap getWrap(@Nullable PsiElement var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Alignment getAlignment(@Nullable PsiElement var1, @NotNull PsiElement var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Array;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "alignment", "Lcom/intellij/formatting/Alignment;", "kotlin.jvm.PlatformType", "wrap", "Lcom/intellij/formatting/Wrap;", "getAlignment", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getWrap", "intellij.dts"})
    private static final class Array
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public Array(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
            this.alignment = Alignment.createAlignment();
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent2 instanceof DtsArray && child instanceof DtsValue) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_VALUES && parent2 instanceof DtsArray && child instanceof DtsValue) {
                return this.alignment;
            }
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Companion;", "", "()V", "childBuilder", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "parent", "Lcom/intellij/formatting/Block;", "current", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtsWrappingBuilder childBuilder(@NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            CustomCodeStyleSettings customCodeStyleSettings = settings2.getCustomSettings(DtsCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            return new Null((DtsCodeStyleSettings)customCodeStyleSettings);
        }

        @NotNull
        public final DtsWrappingBuilder childBuilder(@Nullable Block parent2, @NotNull DtsWrappingBuilder current) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            PsiElement element = ASTBlock.getPsiElement((Block)parent2);
            if (element instanceof DtsContainer) {
                return new Container(current.getSettings());
            }
            IElementType iElementType = ASTBlock.getElementType((Block)parent2);
            return Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.PROPERTY_CONTENT) ? (DtsWrappingBuilder)new PropertyContent(current.getSettings()) : ((Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.CELL_ARRAY) ? true : Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.BYTE_ARRAY)) ? (DtsWrappingBuilder)new Array(current.getSettings()) : current);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Container;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "alignment", "Lcom/intellij/formatting/Alignment;", "kotlin.jvm.PlatformType", "wrap", "Lcom/intellij/formatting/Wrap;", "getAlignment", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getWrap", "intellij.dts"})
    private static final class Container
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public Container(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            this.alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent2 instanceof DtsNodeContent) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_ASSIGNMENT && parent2 instanceof DtsProperty && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)DtsTypes.ASSIGN)) {
                return this.alignment;
            }
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0014J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Null;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "getAlignment", "Lcom/intellij/formatting/Alignment;", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getWrap", "Lcom/intellij/formatting/Wrap;", "intellij.dts"})
    private static final class Null
    extends DtsWrappingBuilder {
        public Null(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$PropertyContent;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "alignment", "Lcom/intellij/formatting/Alignment;", "kotlin.jvm.PlatformType", "wrap", "Lcom/intellij/formatting/Wrap;", "getAlignment", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getWrap", "intellij.dts"})
    private static final class PropertyContent
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public PropertyContent(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
            this.alignment = Alignment.createAlignment((boolean)true);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent2 instanceof DtsPropertyContent && child instanceof DtsValue) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent2, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_VALUES && parent2 instanceof DtsPropertyContent && child instanceof DtsValue) {
                return this.alignment;
            }
            return null;
        }
    }
}

