/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.formatting;

import com.intellij.dts.lang.DtsLanguage;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsEntry;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.settings.DtsCodeStyleSettings;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/dts/formatting/DtsSpacingBuilder;", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "builder", "Lcom/intellij/formatting/SpacingBuilder;", "common", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "Lorg/jetbrains/annotations/NotNull;", "custom", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "getBlankLinesRange", "Lcom/intellij/dts/formatting/DtsSpacingBuilder$BlankLinesRang;", "child1", "Lcom/intellij/psi/PsiElement;", "child2", "getEntryLinesRange", "element", "getSpacing", "Lcom/intellij/formatting/Spacing;", "parent", "Lcom/intellij/formatting/Block;", "BlankLinesRang", "intellij.dts"})
public final class DtsSpacingBuilder {
    @NotNull
    private final CommonCodeStyleSettings common;
    @NotNull
    private final DtsCodeStyleSettings custom;
    @NotNull
    private final SpacingBuilder builder;

    public DtsSpacingBuilder(@NotNull CodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = settings2.getCommonSettings((Language)DtsLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        this.common = commonCodeStyleSettings;
        CustomCodeStyleSettings customCodeStyleSettings = settings2.getCustomSettings(DtsCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        this.custom = (DtsCodeStyleSettings)customCodeStyleSettings;
        IElementType[] iElementTypeArray = new IElementType[]{DtsTypes.LES, DtsTypes.GRT, DtsTypes.LEQ, DtsTypes.GEQ, DtsTypes.EQ, DtsTypes.NEQ};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        TokenSet relationalOperators = tokenSet;
        IElementType[] iElementTypeArray2 = new IElementType[]{DtsTypes.AND, DtsTypes.OR, DtsTypes.XOR};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray2);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        TokenSet bitWiseOperators = tokenSet2;
        IElementType[] iElementTypeArray3 = new IElementType[]{DtsTypes.ADD, DtsTypes.SUB};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray3);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        TokenSet additiveOperators = tokenSet3;
        IElementType[] iElementTypeArray4 = new IElementType[]{DtsTypes.MUL, DtsTypes.DIV, DtsTypes.MOD};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray4);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(...)");
        TokenSet multiplicativeOperators = tokenSet4;
        IElementType[] iElementTypeArray5 = new IElementType[]{DtsTypes.LSH, DtsTypes.RSH};
        TokenSet tokenSet5 = TokenSet.create((IElementType[])iElementTypeArray5);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"create(...)");
        TokenSet shiftOperators = tokenSet5;
        IElementType[] iElementTypeArray6 = new IElementType[]{DtsTypes.L_AND, DtsTypes.L_OR};
        TokenSet tokenSet6 = TokenSet.create((IElementType[])iElementTypeArray6);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet6, (String)"create(...)");
        TokenSet logicalOperators = tokenSet6;
        IElementType[] iElementTypeArray7 = new IElementType[]{DtsTypes.BYTE, DtsTypes.PP_MACRO};
        TokenSet tokenSet7 = TokenSet.create((IElementType[])iElementTypeArray7);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet7, (String)"create(...)");
        TokenSet byteArrayValues = tokenSet7;
        IElementType[] iElementTypeArray8 = new IElementType[]{DtsTypes.INT, DtsTypes.CHAR, DtsTypes.EXPR_VALUE, DtsTypes.P_HANDLE, DtsTypes.PP_MACRO};
        TokenSet tokenSet8 = TokenSet.create((IElementType[])iElementTypeArray8);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet8, (String)"create(...)");
        TokenSet cellArrayValues = tokenSet8;
        SpacingBuilder spacingBuilder = new SpacingBuilder(settings2, (Language)DtsLanguage.INSTANCE).around(DtsTypes.ASSIGN).spaceIf(this.common.SPACE_AROUND_ASSIGNMENT_OPERATORS).around(relationalOperators).spaceIf(this.common.SPACE_AROUND_RELATIONAL_OPERATORS).around(additiveOperators).spaceIf(this.common.SPACE_AROUND_ADDITIVE_OPERATORS).around(multiplicativeOperators).spaceIf(this.common.SPACE_AROUND_MULTIPLICATIVE_OPERATORS).around(bitWiseOperators).spaceIf(this.common.SPACE_AROUND_BITWISE_OPERATORS).around(shiftOperators).spaceIf(this.common.SPACE_AROUND_SHIFT_OPERATORS).around(logicalOperators).spaceIf(this.common.SPACE_AROUND_LOGICAL_OPERATORS).between(DtsTypes.HANDLE, DtsTypes.NAME).none().between(DtsTypes.HANDLE, DtsTypes.LBRACE).none().between(DtsTypes.LBRACE, DtsTypes.NODE_CONTENT).lineBreakInCode().between(DtsTypes.NODE_CONTENT, DtsTypes.RBRACE).lineBreakInCode().betweenInside(DtsTypes.BYTE, DtsTypes.BYTE, DtsTypes.BYTE_ARRAY).spaceIf(this.custom.SPACE_BETWEEN_BYTES).betweenInside(byteArrayValues, byteArrayValues, DtsTypes.BYTE_ARRAY).spaces(1).betweenInside(cellArrayValues, cellArrayValues, DtsTypes.CELL_ARRAY).spaces(1).betweenInside(DtsTypes.SLASH, DtsTypes.NAME, DtsTypes.PATH).none().betweenInside(DtsTypes.NAME, DtsTypes.SLASH, DtsTypes.PATH).none().withinPair(DtsTypes.LBRACKET, DtsTypes.RBRACKET).spaceIf(this.common.SPACE_WITHIN_BRACKETS).withinPair(DtsTypes.LPAREN, DtsTypes.RPAREN).spaceIf(this.common.SPACE_WITHIN_PARENTHESES).withinPair(DtsTypes.LANGL, DtsTypes.RANGL).spaceIf(this.custom.SPACE_WITHIN_ANGULAR_BRACKETS).withinPairInside(DtsTypes.LBRACE, DtsTypes.RBRACE, DtsTypes.ROOT_NODE).spaceIf(this.custom.SPACE_WITHIN_EMPTY_NODE).withinPairInside(DtsTypes.LBRACE, DtsTypes.RBRACE, DtsTypes.SUB_NODE).spaceIf(this.custom.SPACE_WITHIN_EMPTY_NODE).withinPairInside(DtsTypes.LBRACE, DtsTypes.RBRACE, DtsTypes.P_HANDLE).none().after(DtsTypes.COMMA).spaceIf(this.common.SPACE_AFTER_COMMA).after(DtsTypes.LABEL).spaceIf(this.custom.SPACE_AFTER_LABEL).after(DtsTokenSets.INSTANCE.getCompilerDirectives()).spaces(1).before(DtsTypes.COMMA).spaceIf(this.common.SPACE_BEFORE_COMMA).before(DtsTypes.LBRACE).spaces(1).before(DtsTypes.SEMICOLON).none().before(DtsTypes.SEMICOLON).lineBreakInCode();
        Intrinsics.checkNotNullExpressionValue((Object)spacingBuilder, (String)"lineBreakInCode(...)");
        this.builder = spacingBuilder;
    }

    private final BlankLinesRang getEntryLinesRange(PsiElement element) {
        BlankLinesRang blankLinesRang;
        if (!(element instanceof DtsEntry)) {
            return null;
        }
        DtsStatement dtsStatement = ((DtsEntry)element).getDtsStatement();
        if (dtsStatement instanceof DtsStatement.CompilerDirective) {
            blankLinesRang = new BlankLinesRang(0, this.common.KEEP_BLANK_LINES_IN_CODE);
        } else if (dtsStatement instanceof DtsStatement.Node) {
            blankLinesRang = BlankLinesRang.Companion.fromSettings(this.custom.MIN_BLANK_LINES_BETWEEN_NODES, this.custom.MAX_BLANK_LINES_BETWEEN_NODES);
        } else if (dtsStatement instanceof DtsStatement.Property) {
            blankLinesRang = BlankLinesRang.Companion.fromSettings(this.custom.MIN_BLANK_LINES_BETWEEN_PROPERTIES, this.custom.MAX_BLANK_LINES_BETWEEN_PROPERTIES);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return blankLinesRang;
    }

    private final BlankLinesRang getBlankLinesRange(PsiElement child1, PsiElement child2) {
        if (DtsTokenSets.INSTANCE.getComments().contains(PsiTreeUtilKt.getElementType((PsiElement)child1)) || DtsTokenSets.INSTANCE.getComments().contains(PsiTreeUtilKt.getElementType((PsiElement)child2))) {
            return new BlankLinesRang(0, this.common.KEEP_BLANK_LINES_IN_CODE);
        }
        BlankLinesRang range1 = this.getEntryLinesRange(child1);
        BlankLinesRang range2 = this.getEntryLinesRange(child2);
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        return new BlankLinesRang(Math.max(range1.getLineFeeds(), range2.getLineFeeds()), Math.min(range1.getBlankLines(), range2.getBlankLines()));
    }

    @Nullable
    public final Spacing getSpacing(@Nullable Block parent2, @Nullable Block child1, @Nullable Block child2) {
        PsiElement psiElement = ASTBlock.getPsiElement((Block)child1);
        if (psiElement == null) {
            return null;
        }
        PsiElement child1Element = psiElement;
        PsiElement psiElement2 = ASTBlock.getPsiElement((Block)child2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement child2Element = psiElement2;
        BlankLinesRang range = this.getBlankLinesRange(child1Element, child2Element);
        if (range != null) {
            return range.getSpacing();
        }
        return this.builder.getSpacing(parent2, child1, child2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dts/formatting/DtsSpacingBuilder$BlankLinesRang;", "", "lineFeeds", "", "blankLines", "(II)V", "getBlankLines", "()I", "getLineFeeds", "component1", "component2", "copy", "equals", "", "other", "getSpacing", "Lcom/intellij/formatting/Spacing;", "hashCode", "toString", "", "Companion", "intellij.dts"})
    private static final class BlankLinesRang {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int lineFeeds;
        private final int blankLines;

        public BlankLinesRang(int lineFeeds, int blankLines) {
            this.lineFeeds = lineFeeds;
            this.blankLines = blankLines;
        }

        public final int getLineFeeds() {
            return this.lineFeeds;
        }

        public final int getBlankLines() {
            return this.blankLines;
        }

        @NotNull
        public final Spacing getSpacing() {
            Spacing spacing = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.lineFeeds, (boolean)true, (int)this.blankLines);
            Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
            return spacing;
        }

        public final int component1() {
            return this.lineFeeds;
        }

        public final int component2() {
            return this.blankLines;
        }

        @NotNull
        public final BlankLinesRang copy(int lineFeeds, int blankLines) {
            return new BlankLinesRang(lineFeeds, blankLines);
        }

        public static /* synthetic */ BlankLinesRang copy$default(BlankLinesRang blankLinesRang, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = blankLinesRang.lineFeeds;
            }
            if ((n3 & 2) != 0) {
                n2 = blankLinesRang.blankLines;
            }
            return blankLinesRang.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "BlankLinesRang(lineFeeds=" + this.lineFeeds + ", blankLines=" + this.blankLines + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.lineFeeds);
            result = result * 31 + Integer.hashCode(this.blankLines);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlankLinesRang)) {
                return false;
            }
            BlankLinesRang blankLinesRang = (BlankLinesRang)other;
            if (this.lineFeeds != blankLinesRang.lineFeeds) {
                return false;
            }
            return this.blankLines == blankLinesRang.blankLines;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/dts/formatting/DtsSpacingBuilder$BlankLinesRang$Companion;", "", "()V", "fromSettings", "Lcom/intellij/dts/formatting/DtsSpacingBuilder$BlankLinesRang;", "minBlankLines", "", "maxBlankLines", "intellij.dts"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BlankLinesRang fromSettings(int minBlankLines, int maxBlankLines) {
                return new BlankLinesRang(minBlankLines + 1, maxBlankLines);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

