/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.documentation;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.api.DtsPath;
import com.intellij.dts.documentation.DtsDocumentationHtmlBuilder;
import com.intellij.dts.lang.DtsPropertyType;
import com.intellij.dts.lang.DtsPropertyValue;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.util.DtsHtmlChunk;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrPropertyBinding;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0004J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0016H\u0004J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/intellij/dts/documentation/DtsDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildDeclaredIn", "", "html", "Lcom/intellij/dts/documentation/DtsDocumentationHtmlBuilder;", "parent", "Lcom/intellij/dts/lang/psi/DtsNode;", "buildDocumentation", "buildNodeBinding", "binding", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "buildNodeName", "node", "name", "", "buildPropertyBinding", "Lcom/intellij/dts/zephyr/binding/DtsZephyrPropertyBinding;", "buildPropertyName", "buildPropertyType", "buildPropertyValue", "Lcom/intellij/openapi/util/text/HtmlChunk;", "propertyType", "Lcom/intellij/dts/lang/DtsPropertyType;", "propertyValue", "Lcom/intellij/dts/lang/DtsPropertyValue;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsDocumentationTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsDocumentationTarget.kt\ncom/intellij/dts/documentation/DtsDocumentationTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1549#2:181\n1620#2,3:182\n1549#2:185\n1620#2,3:186\n1549#2:189\n1620#2,3:190\n1549#2:193\n1620#2,3:194\n*S KotlinDebug\n*F\n+ 1 DtsDocumentationTarget.kt\ncom/intellij/dts/documentation/DtsDocumentationTarget\n*L\n80#1:181\n80#1:182,3\n88#1:185\n88#1:186,3\n93#1:189\n93#1:190,3\n132#1:193\n132#1:194,3\n*E\n"})
public abstract class DtsDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final Project project;

    public DtsDocumentationTarget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    protected abstract void buildDocumentation(@NotNull DtsDocumentationHtmlBuilder var1);

    @NotNull
    public final DocumentationResult computeDocumentation() {
        DtsDocumentationHtmlBuilder builder = new DtsDocumentationHtmlBuilder();
        this.buildDocumentation(builder);
        return (DocumentationResult)DocumentationResult.Companion.documentation(builder.build());
    }

    protected final void buildPropertyName(@NotNull DtsDocumentationHtmlBuilder html, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.property")};
        html.definition(htmlChunkArray);
        htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.propertyName(name)};
        html.appendToDefinition(htmlChunkArray);
    }

    protected final void buildNodeName(@NotNull DtsDocumentationHtmlBuilder html, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.node")};
        html.definition(htmlChunkArray);
        htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.nodeName(name)};
        html.appendToDefinition(htmlChunkArray);
    }

    protected final void buildNodeName(@NotNull DtsDocumentationHtmlBuilder html, @NotNull DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.node")};
        html.definition(htmlChunkArray);
        htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.node(node)};
        html.appendToDefinition(htmlChunkArray);
    }

    protected final void buildDeclaredIn(@NotNull DtsDocumentationHtmlBuilder html, @NotNull DtsNode parent2) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        DtsPath dtsPath = DtsPsiUtilKt.getDtsPath(parent2);
        if (dtsPath == null) {
            return;
        }
        DtsPath path = dtsPath;
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.declared_in")};
        html.definition(htmlChunkArray);
        htmlChunkArray = new HtmlChunk[2];
        htmlChunkArray[0] = DtsHtmlChunk.INSTANCE.path(path);
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)(" (" + parent2.getContainingFile().getName() + ")")).wrapWith(DocumentationMarkup.GRAYED_ELEMENT), (String)"wrapWith(...)");
        html.appendToDefinition(htmlChunkArray);
    }

    /*
     * WARNING - void declaration
     */
    private final HtmlChunk buildPropertyValue(DtsPropertyType propertyType, DtsPropertyValue propertyValue) {
        HtmlChunk htmlChunk;
        if (propertyValue == null || !propertyValue.getAssignableTo().contains((Object)propertyType)) {
            return null;
        }
        DtsPropertyValue dtsPropertyValue = propertyValue;
        if (dtsPropertyValue instanceof DtsPropertyValue.String) {
            char c = '\"';
            String string = ((DtsPropertyValue.String)propertyValue).getValue();
            htmlChunk = DtsHtmlChunk.INSTANCE.string(c + string + "\"");
        } else if (dtsPropertyValue instanceof DtsPropertyValue.Int) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.append("<").append(DtsHtmlChunk.INSTANCE.int(String.valueOf(((DtsPropertyValue.Int)propertyValue).getValue()))).append(">");
            htmlChunk = builder.toFragment();
        } else if (dtsPropertyValue instanceof DtsPropertyValue.StringList) {
            Collection<HtmlChunk> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            HtmlBuilder builder = new HtmlBuilder();
            Iterable iterable = ((DtsPropertyValue.StringList)propertyValue).getValue();
            DtsHtmlChunk dtsHtmlChunk = DtsHtmlChunk.INSTANCE;
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)", ");
            HtmlBuilder htmlBuilder = builder;
            boolean $i$f$map = false;
            void var8_24 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(dtsHtmlChunk.string((String)p0));
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk2, (Iterable)collection);
            htmlChunk = builder.toFragment();
        } else if (dtsPropertyValue instanceof DtsPropertyValue.IntList) {
            HtmlBuilder builder = new HtmlBuilder();
            if (propertyType == DtsPropertyType.Bytes) {
                Collection<HtmlChunk> collection;
                builder.append("[");
                Iterable $this$map$iv = ((DtsPropertyValue.IntList)propertyValue).asByteList();
                DtsHtmlChunk dtsHtmlChunk = DtsHtmlChunk.INSTANCE;
                HtmlChunk htmlChunk3 = HtmlChunk.text((String)" ");
                HtmlBuilder htmlBuilder = builder;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String p0 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(dtsHtmlChunk.int(p0));
                }
                collection = (List)destination$iv$iv;
                htmlBuilder.appendWithSeparators(htmlChunk3, (Iterable)collection);
                builder.append("]");
            } else {
                Collection<HtmlChunk> collection;
                builder.append("<");
                Iterable $this$map$iv = ((DtsPropertyValue.IntList)propertyValue).asIntList();
                DtsHtmlChunk dtsHtmlChunk = DtsHtmlChunk.INSTANCE;
                HtmlChunk htmlChunk4 = HtmlChunk.text((String)" ");
                HtmlBuilder htmlBuilder = builder;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String p0 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(dtsHtmlChunk.int(p0));
                }
                collection = (List)destination$iv$iv;
                htmlBuilder.appendWithSeparators(htmlChunk4, (Iterable)collection);
                builder.append(">");
            }
            htmlChunk = builder.toFragment();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return htmlChunk;
    }

    private final void buildPropertyType(DtsDocumentationHtmlBuilder html, DtsZephyrPropertyBinding binding) {
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.property_type")};
        html.definition(htmlChunkArray);
        HtmlChunk htmlChunk = this.buildPropertyValue(binding.getType(), binding.getConst());
        if (htmlChunk != null) {
            HtmlChunk htmlChunk2 = HtmlChunk.text((String)(" (" + DtsBundle.Companion.message("documentation.property_type.hint_const", new Object[0]) + ")"));
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
            HtmlChunk hint = htmlChunk2;
            HtmlChunk[] htmlChunkArray2 = new HtmlChunk[2];
            htmlChunkArray2[0] = htmlChunk;
            Intrinsics.checkNotNullExpressionValue((Object)hint.wrapWith(DocumentationMarkup.GRAYED_ELEMENT), (String)"wrapWith(...)");
            html.appendToDefinition(htmlChunkArray2);
            return;
        }
        HtmlChunk hint = new HtmlChunk[1];
        Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)binding.getType().getTypeName()), (String)"text(...)");
        html.appendToDefinition((HtmlChunk[])hint);
        if (binding.getRequired()) {
            HtmlChunk htmlChunk3 = HtmlChunk.text((String)(" (" + DtsBundle.Companion.message("documentation.property_type.hint_required", new Object[0]) + ")"));
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"text(...)");
            hint = htmlChunk3;
            HtmlChunk[] htmlChunkArray3 = new HtmlChunk[1];
            Intrinsics.checkNotNullExpressionValue((Object)hint.wrapWith(DocumentationMarkup.GRAYED_ELEMENT), (String)"wrapWith(...)");
            html.appendToDefinition(htmlChunkArray3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void buildPropertyBinding(@NotNull DtsDocumentationHtmlBuilder html, @NotNull DtsZephyrPropertyBinding binding) {
        block3: {
            HtmlChunk[] htmlChunkArray;
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            this.buildPropertyType(html, binding);
            List<DtsPropertyValue> list = binding.getEnum();
            if (list != null) {
                Collection<HtmlChunk> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<DtsPropertyValue> list2 = list;
                boolean bl = false;
                HtmlBuilder builder = new HtmlBuilder();
                builder.append("{ ");
                HtmlChunk[] htmlChunkArray2 = (HtmlChunk[])list2;
                HtmlChunk htmlChunk = HtmlChunk.text((String)", ");
                HtmlBuilder htmlBuilder = builder;
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DtsPropertyValue dtsPropertyValue = (DtsPropertyValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.buildPropertyValue(binding.getType(), (DtsPropertyValue)it));
                }
                collection = (List)destination$iv$iv;
                htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
                builder.append(" }");
                htmlChunkArray2 = new HtmlChunk[2];
                htmlChunkArray2[0] = DtsHtmlChunk.INSTANCE.definitionName("documentation.property_enum");
                Intrinsics.checkNotNullExpressionValue((Object)builder.toFragment(), (String)"toFragment(...)");
                html.definition(htmlChunkArray2);
            }
            HtmlChunk htmlChunk = this.buildPropertyValue(binding.getType(), binding.getDefault());
            if (htmlChunk != null) {
                HtmlChunk htmlChunk2 = htmlChunk;
                boolean bl = false;
                htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.property_default"), htmlChunk2};
                html.definition(htmlChunkArray);
            }
            String string = binding.getDescription();
            if (string == null) break block3;
            String description = string;
            boolean bl = false;
            htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.binding(this.project, description)};
            html.content(htmlChunkArray);
        }
    }

    protected final void buildNodeBinding(@NotNull DtsDocumentationHtmlBuilder html, @NotNull DtsZephyrBinding binding) {
        block5: {
            HtmlChunk[] htmlChunkArray;
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            String string = binding.getCompatible();
            if (string != null) {
                String compatible = string;
                boolean bl = false;
                if (binding.isChild()) {
                    htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.compatible_child")};
                    html.definition(htmlChunkArray);
                } else {
                    htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.compatible")};
                    html.definition(htmlChunkArray);
                }
                htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.string(compatible)};
                html.appendToDefinition(htmlChunkArray);
                String string2 = binding.getOnBus();
                if (string2 != null) {
                    String bus = string2;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{bus};
                    String value = DtsBundle.Companion.message("documentation.compatible_on_bus", objectArray);
                    HtmlChunk.Element element = HtmlChunk.text((String)(" (" + value + ")")).wrapWith(DocumentationMarkup.GRAYED_ELEMENT);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
                    HtmlChunk.Element chunk = element;
                    HtmlChunk[] htmlChunkArray2 = new HtmlChunk[]{chunk};
                    html.appendToDefinition(htmlChunkArray2);
                }
            }
            if (!((Collection)binding.getBuses()).isEmpty()) {
                HtmlChunk htmlChunk = HtmlChunk.text((String)CollectionsKt.joinToString$default((Iterable)binding.getBuses(), null, null, null, (int)0, null, null, (int)63, null));
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
                HtmlChunk chunk = htmlChunk;
                HtmlChunk[] htmlChunkArray3 = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.definitionName("documentation.bus_controller"), chunk};
                html.definition(htmlChunkArray3);
            }
            String string3 = binding.getDescription();
            if (string3 == null) break block5;
            String description = string3;
            boolean bl = false;
            htmlChunkArray = new HtmlChunk[]{DtsHtmlChunk.INSTANCE.binding(this.project, description)};
            html.content(htmlChunkArray);
        }
    }
}

