/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.dts.DtsBundle;
import com.intellij.dts.DtsIcons;
import com.intellij.dts.completion.DtsPatternsKt;
import com.intellij.dts.completion.provider.DtsCompletionPrefixKt;
import com.intellij.dts.completion.provider.DtsInsertHandler;
import com.intellij.dts.documentation.DtsNodeBindingDocumentationTarget;
import com.intellij.dts.lang.psi.DtsContainer;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.lang.symbols.DtsDocumentationSymbol;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBundledBindings;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dts/completion/provider/DtsNodeNameProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.dts"})
public final class DtsNodeNameProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final DtsNodeNameProvider INSTANCE = new DtsNodeNameProvider();

    private DtsNodeNameProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        DtsContainer container = DtsPatternsKt.getDtsContainer(context);
        CompletionResultSet resultSet = DtsCompletionPrefixKt.withDtsPrefixMatcher(result, parameters);
        PsiElement psiElement = container.getParent();
        DtsNode dtsNode = psiElement instanceof DtsNode ? (DtsNode)psiElement : null;
        if (dtsNode == null) {
            return;
        }
        DtsNode node = dtsNode;
        if (!DtsPsiUtilKt.isDtsRootNode(node)) {
            return;
        }
        DtsZephyrBundledBindings provider = DtsZephyrBundledBindings.Companion.getInstance();
        for (String name : DtsZephyrBundledBindings.Companion.getNODE_BINDINGS()) {
            LookupElementBuilder lookup;
            DtsZephyrBinding binding;
            if (provider.getBinding(name) == null) continue;
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Pointer<? extends Symbol> symbol = DtsDocumentationSymbol.Companion.from(new DtsNodeBindingDocumentationTarget(project, name, binding));
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create(symbol, (String)name).withTypeText(DtsBundle.Companion.message("documentation.node.lookup_type", new Object[0])).withIcon(DtsIcons.Node).withInsertHandler(DtsInsertHandler.INSTANCE.getSUB_NODE()), (String)"withInsertHandler(...)");
            resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)lookup), (double)1.0));
        }
    }
}

