/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.completion;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.dts.completion.DtsSemicolonEnterHandler;
import com.intellij.dts.lang.DtsFile;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsEntry;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dts/completion/DtsSemicolonEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "findEntry", "Lcom/intellij/dts/lang/psi/DtsEntry;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findInsertPosition", "", "statement", "Lcom/intellij/dts/lang/psi/DtsStatement;", "isCommentOrWhitespace", "", "token", "Lcom/intellij/psi/tree/IElementType;", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsSemicolonEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsSemicolonEnterHandler.kt\ncom/intellij/dts/completion/DtsSemicolonEnterHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,74:1\n1099#2,3:75\n*S KotlinDebug\n*F\n+ 1 DtsSemicolonEnterHandler.kt\ncom/intellij/dts/completion/DtsSemicolonEnterHandler\n*L\n68#1:75,3\n*E\n"})
public final class DtsSemicolonEnterHandler
extends EnterHandlerDelegateAdapter {
    private final boolean isCommentOrWhitespace(IElementType token) {
        return DtsTokenSets.INSTANCE.getComments().contains(token) || Intrinsics.areEqual((Object)token, (Object)TokenType.WHITE_SPACE);
    }

    private final DtsEntry findEntry(PsiFile file, Editor editor2) {
        PsiElement element;
        PsiElement psiElement;
        int offset = editor2.getCaretModel().getOffset();
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.getEnd() >= offset && iterator.getStart() > 0) {
            iterator.retreat();
        }
        while (iterator.getStart() > 0) {
            IElementType iElementType = iterator.getTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
            if (!this.isCommentOrWhitespace(iElementType)) break;
            iterator.retreat();
        }
        return (psiElement = PsiTreeUtil.findFirstParent((PsiElement)(element = file.findElementAt(iterator.getStart())), arg_0 -> DtsSemicolonEnterHandler.findEntry$lambda$0(findEntry.1.INSTANCE, arg_0))) instanceof DtsEntry ? (DtsEntry)psiElement : null;
    }

    private final int findInsertPosition(DtsStatement statement, Editor editor2) {
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(PsiTreeUtilKt.getEndOffset((PsiElement)statement));
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        while (iterator.getStart() > 0) {
            IElementType iElementType = iterator.getTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
            if (!this.isCommentOrWhitespace(iElementType)) break;
            iterator.retreat();
        }
        return iterator.getEnd();
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof DtsFile) || !Registry.is((String)"dts.insert_semicolons")) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)((DtsFile)file).getProject()).commitDocument(editor2.getDocument());
        DtsEntry dtsEntry = this.findEntry(file, editor2);
        if (dtsEntry == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        DtsEntry entry = dtsEntry;
        DtsStatement statement = entry.getDtsStatement();
        if (entry.getHasDtsSemicolon()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!statement.getDtsIsComplete()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        int insertOffset = this.findInsertPosition(statement, editor2);
        int start = Math.min(insertOffset, caretOffset);
        int end = Math.max(insertOffset, caretOffset);
        CharSequence $this$count$iv = ((DtsFile)file).getText().subSequence(start, end);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        if (count$iv > 1) {
            return EnterHandlerDelegate.Result.Continue;
        }
        editor2.getDocument().insertString(insertOffset, (CharSequence)";");
        return EnterHandlerDelegate.Result.Default;
    }

    private static final boolean findEntry$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

