/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.clion;

import com.intellij.dts.clion.impl.DtsCMakeModelConfigurationDataProvider;
import com.intellij.dts.settings.DtsSettings;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.FlowPreview;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0018B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/dts/clion/DtsZephyrCMakeSync;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceListener;", "Lcom/intellij/dts/settings/DtsSettings$ChangeListener;", "Lcom/intellij/execution/ExecutionTargetListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "alarm", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "activeTargetChanged", "newTarget", "Lcom/intellij/execution/ExecutionTarget;", "reloadingFinished", "canceled", "", "settingsChanged", "settings", "Lcom/intellij/dts/settings/DtsSettings;", "syncSettings", "Companion", "intellij.dts"})
@FlowPreview
public final class DtsZephyrCMakeSync
implements CMakeWorkspaceListener,
DtsSettings.ChangeListener,
ExecutionTargetListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableSharedFlow<Unit> alarm;
    @NotNull
    private static final String ZEPHYR_BOARD_PATH_VARIABLE = "BOARD_DIR";
    @NotNull
    private static final String ZEPHYR_ROOT_PATH_VARIABLE = "ZEPHYR_BASE";
    @NotNull
    private static final Logger logger;

    public DtsZephyrCMakeSync(@NotNull Project project, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.project = project;
        this.alarm = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)parentScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DtsZephyrCMakeSync this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.alarm), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DtsZephyrCMakeSync this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.this$0.syncSettings();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void syncSettings() {
        String rootPath;
        CMakeConfigurator cMakeConfigurator;
        DtsSettings settings2 = DtsSettings.Companion.of(this.project);
        if (!settings2.getZephyrCMakeSync()) {
            return;
        }
        CMakeModelConfigurationData activeConfig = DtsCMakeModelConfigurationDataProvider.Companion.getFirstCMakeModelConfigurationData(this.project);
        if (activeConfig == null) {
            return;
        }
        try {
            cMakeConfigurator = activeConfig.getCacheConfigurator();
        }
        catch (Exception e) {
            logger.debug("failed to get cmake cache configurator", (Throwable)e);
            return;
        }
        CMakeConfigurator cache = cMakeConfigurator;
        CMakeVariable cMakeVariable = cache.findVariable(ZEPHYR_BOARD_PATH_VARIABLE);
        String boardPath = cMakeVariable != null ? cMakeVariable.getValue() : null;
        CMakeVariable cMakeVariable2 = cache.findVariable(ZEPHYR_ROOT_PATH_VARIABLE);
        String string = rootPath = cMakeVariable2 != null ? cMakeVariable2.getValue() : null;
        if (Intrinsics.areEqual((Object)settings2.getZephyrRoot(), (Object)rootPath) && Intrinsics.areEqual((Object)settings2.getZephyrBoard(), (Object)boardPath)) {
            return;
        }
        settings2.update((Function1<? super DtsSettings.State, Unit>)((Function1)new Function1<DtsSettings.State, Unit>(rootPath, boardPath){
            final /* synthetic */ String $rootPath;
            final /* synthetic */ String $boardPath;
            {
                this.$rootPath = $rootPath;
                this.$boardPath = $boardPath;
                super(1);
            }

            public final void invoke(@NotNull DtsSettings.State $this$update) {
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                String string = this.$rootPath;
                if (string == null) {
                    string = "";
                }
                $this$update.setZephyrRoot(string);
                String string2 = this.$boardPath;
                if (string2 == null) {
                    string2 = "";
                }
                $this$update.setZephyrBoard(string2);
            }
        }));
    }

    public void reloadingFinished(boolean canceled) {
        if (canceled) {
            return;
        }
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    @Override
    public void settingsChanged(@NotNull DtsSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    static {
        Logger logger = Logger.getInstance(DtsZephyrCMakeSync.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DtsZephyrCMakeSync.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/dts/clion/DtsZephyrCMakeSync$Companion;", "", "()V", "ZEPHYR_BOARD_PATH_VARIABLE", "", "ZEPHYR_ROOT_PATH_VARIABLE", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

