/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.api;

import com.intellij.dts.api.DtsFileVisitor;
import com.intellij.dts.api.DtsFileVisitorKt;
import com.intellij.dts.api.DtsNodeVisitor;
import com.intellij.dts.api.DtsPath;
import com.intellij.dts.lang.psi.DtsCompilerDirective;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsNodeContent;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.lang.psi.DtsRefNode;
import com.intellij.dts.lang.psi.DtsRootNode;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsSubNode;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.UtilKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J)\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0015H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/intellij/dts/api/FileVisitor;", "Lcom/intellij/dts/api/DtsFileVisitor;", "visitor", "Lcom/intellij/dts/api/DtsNodeVisitor;", "path", "Lcom/intellij/dts/api/DtsPath;", "forward", "", "(Lcom/intellij/dts/api/DtsNodeVisitor;Lcom/intellij/dts/api/DtsPath;Z)V", "getForward", "()Z", "getPath", "()Lcom/intellij/dts/api/DtsPath;", "getVisitor", "()Lcom/intellij/dts/api/DtsNodeVisitor;", "searchNode", "", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "segments", "", "", "maxOffset", "", "(Lcom/intellij/dts/lang/psi/DtsNode;Ljava/util/List;Ljava/lang/Integer;)V", "visitCompilerDirective", "directive", "Lcom/intellij/dts/lang/psi/DtsCompilerDirective;", "visitDeleteNode", "visitNode", "nodePath", "(Lcom/intellij/dts/lang/psi/DtsNode;Lcom/intellij/dts/api/DtsPath;Ljava/lang/Integer;)V", "visitRefNode", "Lcom/intellij/dts/lang/psi/DtsRefNode;", "(Lcom/intellij/dts/lang/psi/DtsRefNode;Ljava/lang/Integer;)V", "visitRootNode", "Lcom/intellij/dts/lang/psi/DtsRootNode;", "(Lcom/intellij/dts/lang/psi/DtsRootNode;Ljava/lang/Integer;)V", "walkContent", "walkDelete", "name", "intellij.dts"})
final class FileVisitor
implements DtsFileVisitor {
    @NotNull
    private final DtsNodeVisitor visitor;
    @NotNull
    private final DtsPath path;
    private final boolean forward;

    public FileVisitor(@NotNull DtsNodeVisitor visitor2, @NotNull DtsPath path, boolean forward) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.visitor = visitor2;
        this.path = path;
        this.forward = forward;
    }

    @NotNull
    public final DtsNodeVisitor getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final DtsPath getPath() {
        return this.path;
    }

    public final boolean getForward() {
        return this.forward;
    }

    @Override
    public void visitRootNode(@NotNull DtsRootNode node, @Nullable Integer maxOffset) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitNode(node, DtsPath.Companion.getRoot(), maxOffset);
    }

    @Override
    public void visitRefNode(@NotNull DtsRefNode node, @Nullable Integer maxOffset) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.visitNode(node, DtsPsiUtilKt.getDtsPath(node), maxOffset);
    }

    @Override
    public void visitDeleteNode(@NotNull DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DtsPath dtsPath = DtsPsiUtilKt.getDtsPath(node);
        if (dtsPath == null) {
            return;
        }
        DtsPath nodePath = dtsPath;
        if (nodePath.relativize(this.path) != null) {
            this.visitor.visitDelete();
        }
    }

    private final void visitNode(DtsNode node, DtsPath nodePath, Integer maxOffset) {
        if (nodePath == null) {
            return;
        }
        DtsPath dtsPath = nodePath.relativize(this.path);
        if (dtsPath == null) {
            return;
        }
        DtsPath relativePath = dtsPath;
        this.searchNode(node, relativePath.getSegments(), maxOffset);
    }

    private final void visitCompilerDirective(DtsCompilerDirective directive) {
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(directive.getDtsDirectiveArgs());
        if (psiElement == null) {
            return;
        }
        PsiElement arg = psiElement;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)arg), (Object)DtsTypes.NAME)) {
            return;
        }
        IElementType iElementType = directive.getDtsDirectiveType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.DELETE_PROP)) {
            String string = arg.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.visitor.visitDeleteProperty(string);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.DELETE_NODE)) {
            String string = arg.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.visitor.visitDeleteSubNode(string);
        }
    }

    private final void walkContent(DtsNode node) {
        boolean walkContent = this.visitor.visit(node);
        if (!walkContent) {
            return;
        }
        DtsNodeContent dtsNodeContent = node.getDtsContent();
        if (dtsNodeContent == null) {
            return;
        }
        DtsNodeContent content = dtsNodeContent;
        for (DtsStatement statement : content.getDtsStatements()) {
            DtsStatement dtsStatement = statement;
            if (dtsStatement instanceof DtsCompilerDirective) {
                this.visitCompilerDirective((DtsCompilerDirective)statement);
                continue;
            }
            if (dtsStatement instanceof DtsSubNode) {
                this.visitor.visitSubNode((DtsSubNode)statement);
                continue;
            }
            if (!(dtsStatement instanceof DtsProperty)) continue;
            this.visitor.visitProperty((DtsProperty)statement);
        }
    }

    private final void walkDelete(DtsCompilerDirective directive, String name) {
        if (!Intrinsics.areEqual((Object)directive.getDtsDirectiveType(), (Object)DtsTypes.DELETE_NODE)) {
            return;
        }
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(directive.getDtsDirectiveArgs());
        if (psiElement == null) {
            return;
        }
        PsiElement arg = psiElement;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)arg), (Object)DtsTypes.NAME) || !Intrinsics.areEqual((Object)arg.getText(), (Object)name)) {
            return;
        }
        this.visitor.visitDelete();
    }

    private final void searchNode(DtsNode node, List<String> segments, Integer maxOffset) {
        if (segments.isEmpty()) {
            this.walkContent(node);
            return;
        }
        Object object = node.getDtsContent();
        if (object == null || (object = object.getDtsStatements()) == null) {
            return;
        }
        Object statements = object;
        Pair pair = UtilKt.headTail(segments);
        String head = (String)pair.component1();
        List tail = (List)pair.component2();
        if (!this.forward) {
            statements = CollectionsKt.reversed((Iterable)((Iterable)statements));
        }
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            DtsStatement statement = (DtsStatement)iterator.next();
            if (DtsFileVisitorKt.afterMaxOffset(statement, maxOffset)) {
                return;
            }
            if (statement instanceof DtsSubNode && Intrinsics.areEqual((Object)((DtsSubNode)statement).getDtsName(), (Object)head)) {
                this.searchNode((DtsNode)statement, tail, maxOffset);
            }
            if (!tail.isEmpty() || !(statement instanceof DtsCompilerDirective)) continue;
            this.walkDelete((DtsCompilerDirective)statement, head);
        }
    }
}

