/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.jetbrains.cidr.radler.settings.RadSettingsDialog;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J2\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadSettingsDialogFactory;", "Lcom/intellij/openapi/options/newEditor/SettingsDialogFactory;", "()V", "create", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "configurable", "Lcom/intellij/openapi/options/Configurable;", "filter", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/options/ConfigurableGroup;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;)Lcom/intellij/openapi/ui/DialogWrapper;", "", "key", "showApplyButton", "", "showResetButton", "parent", "Ljava/awt/Component;", "intellij.rider.plugins.clion.radler"})
public final class RadSettingsDialogFactory
extends SettingsDialogFactory {
    @NotNull
    public DialogWrapper create(@Nullable Project project, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Project project2 = project;
        if (project2 == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project2);
        return (DialogWrapper)new RadSettingsDialog(project, key, configurable, showApplyButton, showResetButton, host);
    }

    @NotNull
    public DialogWrapper create(@NotNull Project project, @NotNull ConfigurableGroup[] groups, @Nullable Configurable configurable, @Nullable String filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        return this.create(project, CollectionsKt.mutableListOf((Object[])Arrays.copyOf(groups, groups.length)), configurable, filter);
    }

    @NotNull
    public DialogWrapper create(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project);
        return (DialogWrapper)new RadSettingsDialog(project, groups, configurable, filter, host);
    }

    @NotNull
    public DialogWrapper create(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        if (!showApplyButton) {
            return super.create(parent, key, configurable, showApplyButton, showResetButton);
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getOrCreate(project);
        return (DialogWrapper)new RadSettingsDialog(parent, key, configurable, showApplyButton, showResetButton, host);
    }
}

