/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB9\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB;\b\u0016\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010B=\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u0014\u0010\u0016\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadSettingsDialog;", "Lcom/intellij/openapi/options/newEditor/SettingsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "key", "", "configurable", "Lcom/intellij/openapi/options/Configurable;", "showApplyButton", "", "showResetButton", "settingsViewModelHost", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "parent", "Ljava/awt/Component;", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "filter", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;Lcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "areReSharperSettingsEnabled", "getAreReSharperSettingsEnabled", "()Z", "mySingleConfigurable", "doCancelAction", "", "doOKAction", "initialize", "Companion", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadSettingsDialog.kt\ncom/jetbrains/cidr/radler/settings/RadSettingsDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n13#2:128\n*S KotlinDebug\n*F\n+ 1 RadSettingsDialog.kt\ncom/jetbrains/cidr/radler/settings/RadSettingsDialog\n*L\n36#1:128\n*E\n"})
public final class RadSettingsDialog
extends SettingsDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsViewModelHost settingsViewModelHost;
    @Nullable
    private final Project project;
    @Nullable
    private final Configurable mySingleConfigurable;
    @NotNull
    private static final Logger logger;

    private final boolean getAreReSharperSettingsEnabled() {
        return this.mySingleConfigurable == null || ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper((Configurable)this.mySingleConfigurable);
    }

    public RadSettingsDialog(@Nullable Project project, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, key, configurable, showApplyButton, showResetButton);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = configurable;
        this.initialize();
    }

    public RadSettingsDialog(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(parent, key, configurable, showApplyButton, showResetButton);
        this.project = null;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = configurable;
        this.initialize();
    }

    public RadSettingsDialog(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, groups, configurable, filter);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySingleConfigurable = null;
        this.initialize();
    }

    private final void initialize() {
        if (!this.getAreReSharperSettingsEnabled()) {
            logger.info("Entered frontend-only settings dialog with mySingleConfigurable = " + this.mySingleConfigurable);
            return;
        }
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component2 = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component2, disposable);
        Lifetime currentDialogLifetime = this.settingsViewModelHost.getCurrentDialogLifetime();
        currentDialogLifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ RadSettingsDialog this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RadSettingsDialog.access$doCancelAction$s960858987(this.this$0);
            }
        });
        this.settingsViewModelHost.getCurrentDialog().view(currentDialogLifetime, (Function2)new Function2<Lifetime, OptionsDialog, Unit>(this){
            final /* synthetic */ RadSettingsDialog this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime dialogLifetime, @NotNull OptionsDialog dialog) {
                Intrinsics.checkNotNullParameter((Object)dialogLifetime, (String)"dialogLifetime");
                Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
                dialog.getSelectPage().advise(dialogLifetime, (Function1)new Function1<String, Unit>(this.this$0){
                    final /* synthetic */ RadSettingsDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Settings settings = (Settings)Settings.KEY.getData((DataProvider)this.this$0);
                        if (settings == null) {
                            return;
                        }
                        Settings settings2 = settings;
                        settings2.select(settings2.find(it));
                    }
                });
            }
        });
    }

    public void doOKAction() {
        TableCellEditor editor;
        Container parent;
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            ((JFormattedTextField)focusOwner).commitEdit();
        }
        Component component2 = focusOwner;
        Container container = parent = component2 != null ? component2.getParent() : null;
        if (parent instanceof JTable && (editor = ((JTable)parent).getCellEditor()) != null && !editor.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("RiderSettingsDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
        super.doOKAction();
        if (this.getAreReSharperSettingsEnabled()) {
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost == null) {
                throw new IllegalStateException("host".toString());
            }
            SettingsViewModelHost settingsHost = settingsViewModelHost;
            settingsHost.saveTo("Radler Settings");
            this.settingsViewModelHost.cancel();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        if (this.getAreReSharperSettingsEnabled()) {
            this.settingsViewModelHost.cancel();
        }
    }

    public static final /* synthetic */ void access$doCancelAction$s960858987(RadSettingsDialog $this) {
        super.doCancelAction();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadSettingsDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadSettingsDialog.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadSettingsDialog$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.clion.radler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

