/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.settings;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.settings.CidrCodeStylePreview;
import com.jetbrains.cidr.radler.RadBundle;
import com.jetbrains.cidr.radler.fileType.RadFileHighlighter;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadColorSettingsPage;", "Lcom/intellij/openapi/options/colors/RainbowColorSettingsPage;", "Lcom/intellij/application/options/colors/InspectionColorSettingsPage;", "Lcom/intellij/psi/codeStyle/DisplayPrioritySortable;", "()V", "getAdditionalHighlightingTagToDescriptorMap", "", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributeDescriptors", "", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "()[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getColorDescriptors", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "()[Lcom/intellij/openapi/options/colors/ColorDescriptor;", "getDemoText", "getDisplayName", "getHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "getIcon", "Ljavax/swing/Icon;", "getLanguage", "Lcom/intellij/lang/Language;", "getPriority", "Lcom/intellij/psi/codeStyle/DisplayPriority;", "isRainbowType", "", "type", "Companion", "intellij.rider.plugins.clion.radler"})
public final class RadColorSettingsPage
implements RainbowColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AttributesDescriptor[] COLOR_ATTRS;

    @NotNull
    public String getDisplayName() {
        String string = CppLanguage.INSTANCE.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public DisplayPriority getPriority() {
        return DisplayPriority.KEY_LANGUAGE_SETTINGS;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return COLOR_ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        Intrinsics.checkNotNullExpressionValue((Object)ColorDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)cLanguageKind, (String)"maxLanguage(...)");
        return (SyntaxHighlighter)new RadFileHighlighter((OCLanguageKind)cLanguageKind, OCLanguageStandard.Companion.latestCpp());
    }

    @NotNull
    public String getDemoText() {
        String string = CidrCodeStylePreview.getCodeSample((String)"Colors", (String)"cpp");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCodeSample(...)");
        String string2 = RainbowHighlighter.generatePaletteExample((String)"\n     * ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generatePaletteExample(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{$SEMANTIC_DEMO}", (String)string2, (boolean)false, (int)4, null), (String)"<cd_comment_tag_val>A</cd_comment_tag_val>", (String)"<cd_comment_tag_val><macro_par><cd_comment_tag_val>A</cd_comment_tag_val></macro_par></cd_comment_tag_val>", (boolean)false, (int)4, null), (String)"using namespace", (String)"#define <macro>STRINGIFY</macro>(<macro_par>x</macro_par>) #<macro_par>x</macro_par>\n\nusing namespace", (boolean)false, (int)4, null);
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map map = RainbowHighlighter.createRainbowHLM();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createRainbowHLM(...)");
        Map answer = map;
        answer.put("kw", OCHighlightingKeys.SELFSUPERTHIS);
        answer.put("evar", OCHighlightingKeys.EXTERN_VARIABLE);
        answer.put("gvar", OCHighlightingKeys.GLOBAL_VARIABLE);
        answer.put("lvar", OCHighlightingKeys.LOCAL_VARIABLE);
        answer.put("par", OCHighlightingKeys.PARAMETER);
        answer.put("fun_call", OCHighlightingKeys.FUNCTION_CALL);
        answer.put("fun_decl", OCHighlightingKeys.FUNCTION_DECLARATION);
        answer.put("op", OCHighlightingKeys.OVERLOADED_OPERATOR);
        answer.put("prop", OCHighlightingKeys.PROPERTY);
        answer.put("prop_attr", OCHighlightingKeys.PROPERTY_ATTRIBUTE);
        answer.put("sfield", OCHighlightingKeys.STRUCT_FIELD);
        answer.put("sel_call", OCHighlightingKeys.METHOD_CALL);
        answer.put("sel_decl", OCHighlightingKeys.METHOD_DECLARATION);
        answer.put("ifdef", OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED);
        answer.put("macro", OCHighlightingKeys.MACRONAME);
        answer.put("macro_par", OCHighlightingKeys.MACRO_PARAMETER);
        answer.put("ivar", OCHighlightingKeys.INSTANCE_VARIABLE);
        answer.put("struct", OCHighlightingKeys.STRUCT_LIKE);
        answer.put("cls", OCHighlightingKeys.CLASS_REFERENCE);
        answer.put("prt", OCHighlightingKeys.PROTOCOL_REFERENCE);
        answer.put("enum", OCHighlightingKeys.ENUM_CONST);
        answer.put("label", OCHighlightingKeys.LABEL);
        answer.put("def", OCHighlightingKeys.TYPEDEF);
        answer.put("fmt", OCHighlightingKeys.OC_FORMAT_STRING_TOKEN);
        answer.put("templt", OCHighlightingKeys.TEMPLATE_TYPE);
        answer.put("templv", OCHighlightingKeys.TEMPLATE_VALUE);
        answer.put("ns", OCHighlightingKeys.NAMESPACE_LIKE);
        answer.put("generic", OCHighlightingKeys.GENERIC_PARAMETER);
        answer.put("concept", OCHighlightingKeys.CONCEPT);
        answer.put("deduction_guide", OCHighlightingKeys.DEDUCTION_GUIDE);
        answer.put("cd_comment", OCHighlightingKeys.OC_DOC_COMMENT);
        answer.put("cd_comment_tag", OCHighlightingKeys.OC_DOC_COMMENT_TAG);
        answer.put("cd_comment_tag_val", OCHighlightingKeys.OC_DOC_COMMENT_TAG_VALUE);
        answer.put("std_init_list_braces", OCHighlightingKeys.STD_INIT_LIST_BRACES);
        answer.put("dep_code", OCHighlightingKeys.DEPENDENT_CODE);
        return answer;
    }

    public boolean isRainbowType(@Nullable TextAttributesKey type) {
        return Intrinsics.areEqual((Object)OCHighlightingKeys.LOCAL_VARIABLE, (Object)type) || Intrinsics.areEqual((Object)OCHighlightingKeys.PARAMETER, (Object)type);
    }

    @NotNull
    public Language getLanguage() {
        return (Language)CppLanguage.INSTANCE;
    }

    static {
        AttributesDescriptor[] attributesDescriptorArray = new AttributesDescriptor[]{new AttributesDescriptor(RadBundle.message("color.keyword", new Object[0]), OCHighlightingKeys.OC_KEYWORD), new AttributesDescriptor(RadBundle.message("color.this.keywords", new Object[0]), OCHighlightingKeys.SELFSUPERTHIS), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.number", (Object[])new Object[0]), OCHighlightingKeys.OC_NUMBER), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.string", (Object[])new Object[0]), OCHighlightingKeys.OC_STRING), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.valid.escape.in.string", (Object[])new Object[0]), OCHighlightingKeys.OC_VALID_STRING_ESCAPE), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.invalid.escape.in.string", (Object[])new Object[0]), OCHighlightingKeys.OC_INVALID_STRING_ESCAPE), new AttributesDescriptor(RadBundle.message("color.format.string.token", new Object[0]), OCHighlightingKeys.OC_FORMAT_STRING_TOKEN), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.operator.sign", (Object[])new Object[0]), OCHighlightingKeys.OC_OPERATION_SIGN), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.parentheses", (Object[])new Object[0]), OCHighlightingKeys.OC_PARENTHS), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.braces", (Object[])new Object[0]), OCHighlightingKeys.OC_BRACES), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.brackets", (Object[])new Object[0]), OCHighlightingKeys.OC_BRACKETS), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.comma", (Object[])new Object[0]), OCHighlightingKeys.OC_COMMA), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.semicolon", (Object[])new Object[0]), OCHighlightingKeys.OC_SEMICOLON), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.dot", (Object[])new Object[0]), OCHighlightingKeys.OC_DOT), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.bad.character", (Object[])new Object[0]), OCHighlightingKeys.OC_BAD_CHARACTER), new AttributesDescriptor(RadBundle.message("color.concept", new Object[0]), OCHighlightingKeys.CONCEPT), new AttributesDescriptor(RadBundle.message("color.dependent_code", new Object[0]), OCHighlightingKeys.DEPENDENT_CODE), new AttributesDescriptor(RadBundle.message("color.enum.const", new Object[0]), OCHighlightingKeys.ENUM_CONST), new AttributesDescriptor(RadBundle.message("color.function.call", new Object[0]), OCHighlightingKeys.FUNCTION_CALL), new AttributesDescriptor(RadBundle.message("color.function.declaration", new Object[0]), OCHighlightingKeys.FUNCTION_DECLARATION), new AttributesDescriptor(RadBundle.message("color.global.variable", new Object[0]), OCHighlightingKeys.GLOBAL_VARIABLE), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.local.variable", (Object[])new Object[0]), OCHighlightingKeys.LOCAL_VARIABLE), new AttributesDescriptor(RadBundle.message("color.macro.name", new Object[0]), OCHighlightingKeys.MACRONAME), new AttributesDescriptor(RadBundle.message("color.macro.parameter", new Object[0]), OCHighlightingKeys.MACRO_PARAMETER), new AttributesDescriptor(RadBundle.message("color.namespace", new Object[0]), OCHighlightingKeys.NAMESPACE_LIKE), new AttributesDescriptor(RadBundle.message("color.conditionally.non-compiled", new Object[0]), OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.line.comment", (Object[])new Object[0]), OCHighlightingKeys.OC_LINE_COMMENT), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.block.comment", (Object[])new Object[0]), OCHighlightingKeys.OC_BLOCK_COMMENT), new AttributesDescriptor(RadBundle.message("color.doxygen.comment", new Object[0]), OCHighlightingKeys.OC_DOC_COMMENT), new AttributesDescriptor(RadBundle.message("color.doxygen.tag", new Object[0]), OCHighlightingKeys.OC_DOC_COMMENT_TAG), new AttributesDescriptor(RadBundle.message("color.doxygen.tag.value", new Object[0]), OCHighlightingKeys.OC_DOC_COMMENT_TAG_VALUE), new AttributesDescriptor(RadBundle.message("color.preprocessor.directive", new Object[0]), OCHighlightingKeys.OC_DIRECTIVE), new AttributesDescriptor(RadBundle.message("color.preprocessor.path", new Object[0]), OCHighlightingKeys.OC_HEADER_PATH), new AttributesDescriptor(RadBundle.message("color.overloaded.operator", new Object[0]), OCHighlightingKeys.OVERLOADED_OPERATOR), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.parameter", (Object[])new Object[0]), OCHighlightingKeys.PARAMETER), new AttributesDescriptor(RadBundle.message("color.struct.field", new Object[0]), OCHighlightingKeys.STRUCT_FIELD), new AttributesDescriptor(RadBundle.message("color.struct.union", new Object[0]), OCHighlightingKeys.STRUCT_LIKE), new AttributesDescriptor(RadBundle.message("color.template.type", new Object[0]), OCHighlightingKeys.TEMPLATE_TYPE), new AttributesDescriptor(RadBundle.message("color.template.non.type", new Object[0]), OCHighlightingKeys.TEMPLATE_VALUE), new AttributesDescriptor(RadBundle.message("color.typedef", new Object[0]), OCHighlightingKeys.TYPEDEF), new AttributesDescriptor(RadBundle.message("color.deduction_guide", new Object[0]), OCHighlightingKeys.DEDUCTION_GUIDE)};
        COLOR_ATTRS = attributesDescriptorArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadColorSettingsPage$Companion;", "", "()V", "COLOR_ATTRS", "", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "intellij.rider.plugins.clion.radler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

