/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.lang.daemon.ProjectSourceLocationKind;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.model.CppProjectModel;
import com.jetbrains.rider.model.CppProjectModel_PregeneratedKt;
import com.jetbrains.rider.model.FileKind;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/radler/search/RadFileScopeProvider;", "Lcom/jetbrains/cidr/lang/daemon/OCFileScopeProvider;", "()V", "getProjectSourceLocationKind", "Lcom/jetbrains/cidr/lang/daemon/ProjectSourceLocationKind;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rider.plugins.clion.radler"})
public final class RadFileScopeProvider
implements OCFileScopeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @RequiresReadLock
    @NotNull
    public ProjectSourceLocationKind getProjectSourceLocationKind(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index = projectFileIndex;
        if (index.isInLibrary(file2)) {
            return ProjectSourceLocationKind.PROJECT_OR_LIBRARY_SOURCE;
        }
        if (!index.isInContent(file2)) {
            return ProjectSourceLocationKind.OUT_OF_PROJECT_OR_LIBRARY_SOURCE;
        }
        Solution solution = SolutionHostExtensionsKt.getSolution((Project)project);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)solution.isLoaded()))) {
            return ProjectSourceLocationKind.UNKNOWN;
        }
        CppProjectModel model = CppProjectModel_PregeneratedKt.getCppProjectModel((Solution)solution);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)model.getLoaded()))) {
            return ProjectSourceLocationKind.UNKNOWN;
        }
        FileKind fileKind = (FileKind)RdTaskUtilKt.callWithCancellation$default((IRdCall)((IRdCall)model.getGetFileKind()), (Object)file2.getPath(), (long)0L, (int)2, null);
        switch (WhenMappings.$EnumSwitchMapping$0[fileKind.ordinal()]) {
            case 1: {
                return ProjectSourceLocationKind.PROJECT_OR_LIBRARY_SOURCE;
            }
            case 2: {
                return ProjectSourceLocationKind.PROJECT_OR_LIBRARY_PARSED_WITH_ERROR;
            }
            case 3: {
                return ProjectSourceLocationKind.PROJECT_OR_LIBRARY_NOT_PARSED;
            }
            case 4: {
                return ProjectSourceLocationKind.OUT_OF_PROJECT_OR_LIBRARY_SOURCE;
            }
            case 5: {
                return ProjectSourceLocationKind.OUT_OF_PROJECT_OR_LIBRARY_PARSED_WITH_ERROR;
            }
            case 6: {
                return ProjectSourceLocationKind.OUT_OF_PROJECT_OR_LIBRARY_NOT_PARSED;
            }
        }
        throw new NotImplementedError("Unexpected enum " + fileKind);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/radler/search/RadFileScopeProvider$Companion;", "", "()V", "isExternalFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.clion.radler"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExternalFile(@NotNull Project project, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex index = projectFileIndex;
            return !index.isInContent(file2) || index.isInLibrary(file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileKind.values().length];
            try {
                nArray[FileKind.InProjectParsed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileKind.InProjectDummy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileKind.InProjectNotParsed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileKind.OutOfProjectParsed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileKind.OutOfProjectDummy.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileKind.OutOfProjectNotParsed.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

