/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.cpp.fileType.CppHeaderFileType;
import com.jetbrains.rider.cpp.utils.ProtocolUtilsKt;
import com.jetbrains.rider.model.CppIncludeGraph_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\b\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadResolveConfigurationProvider;", "Lcom/jetbrains/cidr/execution/CidrResolveConfigurationProvider;", "()V", "findRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "getAllResolveConfigurationsForFile", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "Lcom/intellij/psi/PsiFile;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Util", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadResolveConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadResolveConfigurationProvider.kt\ncom/jetbrains/cidr/radler/projectmodel/RadResolveConfigurationProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,66:1\n23#2:67\n*S KotlinDebug\n*F\n+ 1 RadResolveConfigurationProvider.kt\ncom/jetbrains/cidr/radler/projectmodel/RadResolveConfigurationProvider\n*L\n50#1:67\n*E\n"})
public final class RadResolveConfigurationProvider
implements CidrResolveConfigurationProvider {
    @NotNull
    public Collection<OCResolveConfiguration> getAllResolveConfigurationsForFile(@NotNull PsiFile file2, @Nullable ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = file2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Collection<VirtualFile> roots = this.findRoots(project2, virtualFile);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        HashSet configurations = new HashSet();
        for (VirtualFile root : roots) {
            configurations.addAll(OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)project2));
        }
        return configurations;
    }

    @NotNull
    public Collection<VirtualFile> findRoots(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!FileTypeManager.getInstance().isFileOfType(file2, (FileType)CppHeaderFileType.INSTANCE)) {
            Set<VirtualFile> set = Collections.singleton(file2);
            Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
            return set;
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        Object object = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)file2, (Project)project));
        if (object == null || (object = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)object, (Project)project)) == null) {
            return new ArrayList();
        }
        int header = (Integer)object;
        List rootIds = (List)ProtocolUtilsKt.callWithCancellation$default((RdCall)CppIncludeGraph_PregeneratedKt.getCppIncludeGraph((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectHeaderRoots(), (IProtocol)ApplicationProtocolKt.getProtocol((Project)project), (Object)header, (long)0L, (int)4, null);
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        Iterator iterator = rootIds.iterator();
        while (iterator.hasNext()) {
            VirtualFile f;
            int fileId = ((Number)iterator.next()).intValue();
            ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity((WorkspaceModel)workspaceModel, (int)fileId);
            VirtualFile virtualFile = projectModelEntity != null && (projectModelEntity = projectModelEntity.getUrl()) != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)projectModelEntity) : (f = null);
            if (f == null) {
                RadResolveConfigurationProvider $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(RadResolveConfigurationProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("could not find file for id " + fileId);
                continue;
            }
            roots.add(f);
        }
        return roots;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadResolveConfigurationProvider$Util;", "", "()V", "getResolveConfigurationOrFallback", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.clion.radler"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final OCResolveConfiguration getResolveConfigurationOrFallback(@NotNull Project project, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            List list = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(file2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurationsForFile(...)");
            List configs = list;
            OCResolveConfiguration oCResolveConfiguration = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)((Collection)configs)).first;
            if (oCResolveConfiguration == null) {
                oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)file2, (Project)project);
            }
            return oCResolveConfiguration;
        }
    }
}

