/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.radler.projectmodel.RadResolveConfigurationProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadLanguageKindCalculatorHelper;", "Lcom/jetbrains/cidr/lang/workspace/OCLanguageKindCalculatorHelper;", "()V", "calculateLanguageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "file", "Lcom/intellij/psi/PsiFile;", "resolveConfig", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLanguageByExtension", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "getLanguageByPsiFile", "getSpecifiedLanguage", "intellij.rider.plugins.clion.radler"})
public final class RadLanguageKindCalculatorHelper
implements OCLanguageKindCalculatorHelper {
    @NotNull
    public OCLanguageKind getLanguageByPsiFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.calculateLanguageKind(file2);
    }

    @Nullable
    public OCLanguageKind getSpecifiedLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return null;
    }

    @Nullable
    public OCLanguageKind getLanguageByExtension(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return OCFileTypeHelpers.getLanguageKind((String)name);
    }

    private final OCLanguageKind calculateLanguageKind(PsiFile file2) {
        VirtualFile vf = file2.getVirtualFile();
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)vf);
        OCResolveConfiguration resolveConfig = RadResolveConfigurationProvider.Util.INSTANCE.getResolveConfigurationOrFallback(project, vf);
        return this.calculateLanguageKind(resolveConfig, vf);
    }

    private final OCLanguageKind calculateLanguageKind(OCResolveConfiguration resolveConfig, VirtualFile virtualFile) {
        OCLanguageKind oCLanguageKind;
        OCLanguageKind oCLanguageKind2;
        OCResolveConfiguration oCResolveConfiguration = resolveConfig;
        Object object = oCLanguageKind2 = oCResolveConfiguration != null ? oCResolveConfiguration.getDeclaredLanguageKind(virtualFile) : null;
        if (oCLanguageKind2 == null) {
            OCResolveConfiguration oCResolveConfiguration2 = resolveConfig;
            OCLanguageKind oCLanguageKind3 = OCLanguageKindCalculatorBase.findLanguageKind((Set)(oCResolveConfiguration2 != null ? oCResolveConfiguration2.getEnabledLanguageKinds() : null), (String)virtualFile.getName(), (boolean)false);
            oCLanguageKind = oCLanguageKind3;
            Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind3, (String)"findLanguageKind(...)");
        } else {
            oCLanguageKind = oCLanguageKind2;
        }
        return oCLanguageKind;
    }
}

