/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.radler.projectmodel.ParsedDefine;
import com.jetbrains.cidr.radler.projectmodel.RadDefinesParserKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadDefinesParser;", "", "()V", "extractMacroDefinitions", "", "", "preprocessorDefines", "isCIDRProvidedFileNameMacro", "", "content", "parseDefine", "Lcom/jetbrains/cidr/radler/projectmodel/ParsedDefine;", "line", "shouldSendMacroToBackend", "name", "intellij.rider.plugins.clion.radler"})
public final class RadDefinesParser {
    @NotNull
    public static final RadDefinesParser INSTANCE = new RadDefinesParser();

    private RadDefinesParser() {
    }

    @NotNull
    public final List<String> extractMacroDefinitions(@NotNull List<String> preprocessorDefines) {
        Intrinsics.checkNotNullParameter(preprocessorDefines, (String)"preprocessorDefines");
        List macrosToExtract = CollectionsKt.minus((Iterable)preprocessorDefines, (Iterable)RadDefinesParserKt.access$getCompilerMacrosToIgnore$p());
        HashMap nameToContent = new HashMap();
        for (String line : macrosToExtract) {
            Intrinsics.checkNotNull((Object)line);
            if (StringsKt.startsWith$default((String)line, (String)"#define", (boolean)false, (int)2, null)) {
                String content;
                ParsedDefine parsedDefine;
                String name;
                if (this.parseDefine(line) == null || !this.shouldSendMacroToBackend(name = parsedDefine.component1(), content = parsedDefine.component2())) continue;
                ((Map)nameToContent).put(name, content);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"#undef", (boolean)false, (int)2, null)) {
                String undefMacroName = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)"#undef"))).toString();
                if (((CharSequence)undefMacroName).length() == 0) {
                    RadDefinesParserKt.access$getLogger$p().info("could not parse #undef line: " + line);
                    continue;
                }
                nameToContent.remove(undefMacroName);
                continue;
            }
            RadDefinesParserKt.access$getLogger$p().trace("unrecognized line in preprocessor defines: " + line);
        }
        Collection collection = nameToContent.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)collection));
    }

    private final ParsedDefine parseDefine(String line) {
        boolean bl = StringsKt.startsWith$default((String)line, (String)"#define", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int nameStart = StringUtil.skipWhitespaceForward((CharSequence)line, (int)7);
        Object[] objectArray = new String[]{" ", "("};
        int nameEnd = StringsKt.indexOfAny$default((CharSequence)line, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)nameStart, (boolean)false, (int)4, null);
        if (nameEnd == -1) {
            nameEnd = line.length();
        }
        if (nameEnd == nameStart) {
            RadDefinesParserKt.access$getLogger$p().info("could not parse #define: empty name. line was: " + line);
            return null;
        }
        int lhsEnd = nameEnd;
        int maybeParamStart = StringUtil.skipWhitespaceForward((CharSequence)line, (int)nameEnd);
        boolean bl2 = 0 <= maybeParamStart ? maybeParamStart < line.length() : false;
        if (bl2 && line.charAt(maybeParamStart) == '(') {
            int maybeParamEnd = StringsKt.indexOf$default((CharSequence)line, (char)')', (int)maybeParamStart, (boolean)false, (int)4, null);
            if (maybeParamEnd == -1) {
                RadDefinesParserKt.access$getLogger$p().info("could not parse #define: parameters were not closed. line was: " + line);
                return null;
            }
            lhsEnd = maybeParamEnd + 1;
        }
        String string = line.substring(nameStart, nameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String name = string;
        CharSequence key = StringsKt.trim((CharSequence)line.subSequence(nameStart, lhsEnd));
        CharSequence definition = StringsKt.trim((CharSequence)line.subSequence(lhsEnd, line.length()));
        String content = key + "=" + definition;
        return new ParsedDefine(name, content);
    }

    private final boolean shouldSendMacroToBackend(String name, String content) {
        if (StringsKt.startsWith$default((String)name, (String)"__CIDR_clang", (boolean)false, (int)2, null) || this.isCIDRProvidedFileNameMacro(content)) {
            return false;
        }
        return !RadDefinesParserKt.access$getMacrosWithBackendSupport$p().contains(name);
    }

    private final boolean isCIDRProvidedFileNameMacro(String content) {
        return Intrinsics.areEqual((Object)content, (Object)"__FILE_NAME__=\"_file_name_short_\"");
    }
}

