/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.cidr.lang.formatting.CidrProjectWizardFilesFormatter;
import com.jetbrains.cidr.radler.format.RadProjectWizardFormatter;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.model.CppProjectModel_PregeneratedKt;
import com.jetbrains.rider.model.FormatterModel_PregeneratedKt;
import com.jetbrains.rider.model.RdStringRange;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/radler/format/RadProjectWizardFormatter;", "Lcom/jetbrains/cidr/lang/formatting/CidrProjectWizardFilesFormatter;", "()V", "reformatProjectFiles", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "sendRequestToFormatSourceFile", "document", "Lcom/intellij/openapi/editor/Document;", "filePath", "", "Companion", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadProjectWizardFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/jetbrains/cidr/radler/format/RadProjectWizardFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n766#2:99\n857#2,2:100\n13#3:102\n*S KotlinDebug\n*F\n+ 1 RadProjectWizardFormatter.kt\ncom/jetbrains/cidr/radler/format/RadProjectWizardFormatter\n*L\n49#1:99\n49#1:100,2\n29#1:102\n*E\n"})
public final class RadProjectWizardFormatter
extends CidrProjectWizardFilesFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public void reformatProjectFiles(@NotNull List<? extends VirtualFile> files, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!CidrProjectWizardFilesFormatter.isSourceFile((VirtualFile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sourceFiles = (List)destination$iv$iv;
        Set otherFiles = CollectionsKt.subtract((Iterable)files, (Iterable)CollectionsKt.toSet((Iterable)sourceFiles));
        LinkedHashMap<String, Pair<Document, Long>> sourceFilesToReformat = new LinkedHashMap<String, Pair<Document, Long>>();
        for (VirtualFile file2 : sourceFiles) {
            String string;
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                logger.warn("Cannot format project file: document is null");
                continue;
            }
            Map map = sourceFilesToReformat;
            Intrinsics.checkNotNullExpressionValue((Object)file2.getPath(), (String)"getPath(...)");
            Pair pair = new Pair((Object)document, (Object)document.getModificationStamp());
            map.put(string, pair);
        }
        SourceExKt.adviseOnce((ISource)CppProjectModel_PregeneratedKt.getCppProjectModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getLoaded().getChange(), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Function1)((Function1)new Function1<Boolean, Unit>(project, sourceFilesToReformat, this, (Set<? extends VirtualFile>)otherFiles){
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashMap<String, Pair<Document, Long>> $sourceFilesToReformat;
            final /* synthetic */ RadProjectWizardFormatter this$0;
            final /* synthetic */ Set<VirtualFile> $otherFiles;
            {
                this.$project = $project;
                this.$sourceFilesToReformat = $sourceFilesToReformat;
                this.this$0 = $receiver;
                this.$otherFiles = $otherFiles;
                super(1);
            }

            public final void invoke(boolean it) {
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$project, this.$sourceFilesToReformat, this.this$0, this.$otherFiles){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ LinkedHashMap<String, Pair<Document, Long>> $sourceFilesToReformat;
                    final /* synthetic */ RadProjectWizardFormatter this$0;
                    final /* synthetic */ Set<VirtualFile> $otherFiles;
                    {
                        this.$project = $project;
                        this.$sourceFilesToReformat = $sourceFilesToReformat;
                        this.this$0 = $receiver;
                        this.$otherFiles = $otherFiles;
                        super(0);
                    }

                    public final void invoke() {
                        RadProjectWizardFormatter.Companion.createClangFormatConfigurationIfNeed(this.$project);
                        for (Map.Entry<K, V> entry2 : ((Map)this.$sourceFilesToReformat).entrySet()) {
                            String filePath = (String)entry2.getKey();
                            Pair documentToModificationStamp = (Pair)entry2.getValue();
                            Document document = (Document)documentToModificationStamp.getFirst();
                            long modificationStamp = ((Number)documentToModificationStamp.getSecond()).longValue();
                            if (document.getModificationStamp() != modificationStamp) {
                                RadProjectWizardFormatter.Companion.getLogger().info("Cannot format project file: already changed");
                                continue;
                            }
                            RadProjectWizardFormatter.access$sendRequestToFormatSourceFile(this.this$0, document, filePath, this.$project);
                        }
                        RadProjectWizardFormatter.access$runFormatAction$s-1749229853(this.$project, () -> reformatProjectFiles.1.invoke$lambda$0(this.$otherFiles, this.$project));
                    }

                    private static final void invoke$lambda$0(Set $otherFiles, Project $project) {
                        Intrinsics.checkNotNullParameter((Object)$otherFiles, (String)"$otherFiles");
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        RadProjectWizardFormatter.access$reformatTextFiles$s-1749229853($otherFiles, RadProjectWizardFormatter.Companion.getLogger(), $project);
                    }
                }), (int)1, null);
            }
        }));
    }

    private final void sendRequestToFormatSourceFile(Document document, String filePath, Project project) {
        IdeBackend backend = IdeBackend.Companion.getInstance(project);
        RdLanguage language = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)((Language)CppLanguage.INSTANCE));
        TextRange textRange = TextRange.create((int)0, (int)document.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        RdStringRange request = new RdStringRange(string, filePath, RangeUtilKt.toRdTextRange((TextRange)range), language);
        SourceExKt.adviseOnce((ISource)((ISource)FormatterModel_PregeneratedKt.getFormatterModel((Solution)backend.getSolution()).getDoFormatText().start(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Object)request).getResult()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (Function1)((Function1)new Function1<RdTaskResult<? extends String>, Unit>(document){
            final /* synthetic */ Document $document;
            {
                this.$document = $document;
                super(1);
            }

            public final void invoke(@NotNull RdTaskResult<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                RdTaskResult<String> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    WriteAction.run(() -> sendRequestToFormatSourceFile.1.invoke$lambda$0(this.$document, it));
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    RadProjectWizardFormatter.Companion.getLogger().warn("Cannot format project file", ((RdTaskResult.Fault)it).getError().getCause());
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    RadProjectWizardFormatter.Companion.getLogger().info("Cannot format project file: Task cancelled");
                }
            }

            private static final void invoke$lambda$0(Document $document, RdTaskResult $it) {
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                $document.setText((CharSequence)((RdTaskResult.Success)$it).getValue());
            }
        }));
    }

    @JvmStatic
    public static final void createClangFormatConfigurationIfNeed(@NotNull Project project) {
        Companion.createClangFormatConfigurationIfNeed(project);
    }

    public static final /* synthetic */ void access$sendRequestToFormatSourceFile(RadProjectWizardFormatter $this, Document document, String filePath, Project project) {
        $this.sendRequestToFormatSourceFile(document, filePath, project);
    }

    public static final /* synthetic */ void access$runFormatAction$s-1749229853(Project p0, Runnable p1) {
        CidrProjectWizardFilesFormatter.runFormatAction((Project)p0, (Runnable)p1);
    }

    public static final /* synthetic */ void access$reformatTextFiles$s-1749229853(Collection p0, Logger p1, Project p2) {
        CidrProjectWizardFilesFormatter.reformatTextFiles((Collection)p0, (Logger)p1, (Project)p2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadProjectWizardFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadProjectWizardFormatter.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/radler/format/RadProjectWizardFormatter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "createClangFormatConfigurationIfNeed", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.clion.radler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public final void createClangFormatConfigurationIfNeed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Optional optional = ExternalFormatProcessor.findExternalFormatter((String)"ClangFormat");
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findExternalFormatter(...)");
            Optional findExternalFormatter = optional;
            findExternalFormatter.ifPresent(arg_0 -> Companion.createClangFormatConfigurationIfNeed$lambda$0((Function1)new Function1<ExternalFormatProcessor, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull ExternalFormatProcessor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)this.$project).getCustomSettings(ClangFormatSettings.class);
                        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
                        ClangFormatSettings cfSettings = (ClangFormatSettings)customCodeStyleSettings;
                        if (cfSettings.ENABLED) {
                            it.createConfiguration(this.$project);
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                }
            }, arg_0));
        }

        private static final void createClangFormatConfigurationIfNeed$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

