/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.cidr.radler.clangd.RadClangAnnotatorUtilKt;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.services.RdActionsSupport;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/radler/clangd/ClangdActionsHandler;", "", "()V", "mayWorkViaClangdActionIds", "", "", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "shouldHandleBackendAction", "", "backendActionId", "psiFile", "shouldHandleFrontendAction", "frontendActionId", "intellij.rider.plugins.clion.radler"})
public final class ClangdActionsHandler {
    @NotNull
    public static final ClangdActionsHandler INSTANCE = new ClangdActionsHandler();
    @NotNull
    private static final Set<String> mayWorkViaClangdActionIds;

    private ClangdActionsHandler() {
    }

    public final boolean shouldHandleBackendAction(@NotNull String backendActionId, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)backendActionId, (String)"backendActionId");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        String frontendActionId = RdActionsSupport.Companion.getInstance().getFrontendActionId(backendActionId);
        return mayWorkViaClangdActionIds.contains(frontendActionId) && RadClangAnnotatorUtilKt.shouldSupportViaClangd(psiFile);
    }

    public final boolean shouldHandleFrontendAction(@NotNull String frontendActionId, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!mayWorkViaClangdActionIds.contains(frontendActionId)) {
            return false;
        }
        Project project = DataContextKt.getProject((DataContext)dataContext);
        PsiFile psiFile = (PsiFile)ApplicationKt.getApplication().runReadAction(() -> ClangdActionsHandler.shouldHandleFrontendAction$lambda$0(dataContext));
        return project != null && psiFile != null && RadClangAnnotatorUtilKt.shouldSupportViaClangd(psiFile);
    }

    private final PsiFile getPsiFile(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor2 = editor;
        if ((editor2 != null ? DocumentExKt.getTextControlId((Editor)editor2) : null) != null && project != null) {
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
    }

    private static final PsiFile shouldHandleFrontendAction$lambda$0(DataContext $dataContext) {
        Intrinsics.checkNotNullParameter((Object)$dataContext, (String)"$dataContext");
        return INSTANCE.getPsiFile($dataContext);
    }

    static {
        Object[] objectArray = new String[]{"QuickJavaDoc", "EditorEnter", "ParameterInfo", "CommentByLineComment"};
        mayWorkViaClangdActionIds = SetsKt.setOf((Object[])objectArray);
    }
}

