/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.handler.codec.http.HttpResponse;
import java.net.SocketAddress;
import java.util.Objects;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import reactor.util.annotation.Nullable;

final class AccessLogArgProviderH1
extends AbstractAccessLogArgProvider<AccessLogArgProviderH1> {
    HttpServerRequest request;
    HttpResponse response;

    AccessLogArgProviderH1(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH1 request(HttpServerRequest request2) {
        this.request = Objects.requireNonNull(request2, "request");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH1 response(HttpResponse response2) {
        this.response = Objects.requireNonNull(response2, "response");
        return this.get();
    }

    @Override
    @Nullable
    public CharSequence status() {
        return this.response == null ? null : this.response.status().codeAsText();
    }

    @Override
    @Nullable
    public CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.request == null ? null : this.request.requestHeaders().get(name);
    }

    @Override
    @Nullable
    public CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.response == null ? null : this.response.headers().get(name);
    }

    @Override
    void onRequest() {
        if (this.request != null) {
            this.accessDateTime = this.request.timestamp();
            this.zonedDateTime = this.accessDateTime.format(DATE_TIME_FORMATTER);
            this.startTime = this.accessDateTime.toInstant().toEpochMilli();
            this.method = this.request.method().name();
            this.uri = this.request.uri();
            this.protocol = this.request.protocol();
            this.cookies = this.request.cookies();
            this.connectionInfo = this.request;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.request = null;
        this.response = null;
    }

    AccessLogArgProviderH1 contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.get();
    }

    @Override
    public AccessLogArgProviderH1 get() {
        return this;
    }
}

