/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.OperatorDisposables;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class FluxRefCount<T>
extends Flux<T>
implements Scannable,
Fuseable {
    final ConnectableFlux<? extends T> source;
    final int n;
    @Nullable
    RefCountMonitor<T> connection;

    FluxRefCount(ConnectableFlux<? extends T> source, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > 0 required but it was " + n);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.n = n;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        RefCountMonitor<T> conn;
        RefCountInner<T> inner = new RefCountInner<T>(actual);
        this.source.subscribe((CoreSubscriber<? super T>)inner);
        boolean connect = false;
        FluxRefCount fluxRefCount = this;
        synchronized (fluxRefCount) {
            conn = this.connection;
            if (conn == null || conn.terminated) {
                this.connection = conn = new RefCountMonitor(this);
            }
            long c = conn.subscribers;
            conn.subscribers = c + 1L;
            if (!conn.connected && c + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        inner.setRefCountMonitor(conn);
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefCountMonitor rc) {
        Disposable dispose = null;
        FluxRefCount fluxRefCount = this;
        synchronized (fluxRefCount) {
            long c;
            if (rc.terminated) {
                return;
            }
            rc.subscribers = c = rc.subscribers - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (rc == this.connection) {
                dispose = RefCountMonitor.DISCONNECT.getAndSet(rc, Disposables.disposed());
                this.connection = null;
            }
        }
        if (dispose != null) {
            dispose.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefCountMonitor rc) {
        FluxRefCount fluxRefCount = this;
        synchronized (fluxRefCount) {
            if (!rc.terminated) {
                rc.terminated = true;
                this.connection = null;
            }
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key2) {
        if (key2 == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key2 == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key2 == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    static final class RefCountInner<T>
    implements Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        RefCountMonitor<T> connection;
        Subscription s;
        Fuseable.QueueSubscription<T> qs;
        Throwable error;
        static final int MONITOR_SET_FLAG = 0x20000000;
        static final int TERMINATED_FLAG = 0x40000000;
        static final int CANCELLED_FLAG = Integer.MIN_VALUE;
        volatile int state;
        static final AtomicIntegerFieldUpdater<RefCountInner> STATE = AtomicIntegerFieldUpdater.newUpdater(RefCountInner.class, "state");

        RefCountInner(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key2) {
            if (key2 == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key2 == Scannable.Attr.TERMINATED) {
                return RefCountInner.isTerminated(this.state);
            }
            if (key2 == Scannable.Attr.CANCELLED) {
                return RefCountInner.isCancelled(this.state);
            }
            if (key2 == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
            }
        }

        void setRefCountMonitor(RefCountMonitor<T> connection) {
            int previousState;
            this.connection = connection;
            this.actual.onSubscribe(this);
            do {
                if (RefCountInner.isCancelled(previousState = this.state)) {
                    return;
                }
                if (!RefCountInner.isTerminated(previousState)) continue;
                connection.upstreamFinished();
                Throwable e = this.error;
                if (e != null) {
                    this.actual.onError(e);
                } else {
                    this.actual.onComplete();
                }
                return;
            } while (!STATE.compareAndSet(this, previousState, previousState | 0x20000000));
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            int previousState;
            this.error = t;
            do {
                if (!RefCountInner.isTerminated(previousState = this.state) && !RefCountInner.isCancelled(previousState)) continue;
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            } while (!STATE.compareAndSet(this, previousState, previousState | 0x40000000));
            if (RefCountInner.isMonitorSet(previousState)) {
                this.connection.upstreamFinished();
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            int previousState;
            do {
                if (!RefCountInner.isTerminated(previousState = this.state) && !RefCountInner.isCancelled(previousState)) continue;
                return;
            } while (!STATE.compareAndSet(this, previousState, previousState | 0x40000000));
            if (RefCountInner.isMonitorSet(previousState)) {
                this.connection.upstreamFinished();
                this.actual.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
            int previousState = this.state;
            if (RefCountInner.isTerminated(previousState) || RefCountInner.isCancelled(previousState)) {
                return;
            }
            if (STATE.compareAndSet(this, previousState, previousState | Integer.MIN_VALUE)) {
                this.connection.innerCancelled();
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if (this.s instanceof Fuseable.QueueSubscription) {
                this.qs = (Fuseable.QueueSubscription)this.s;
                return this.qs.requestFusion(requestedMode);
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            return (T)this.qs.poll();
        }

        @Override
        public int size() {
            return this.qs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
        }

        static boolean isTerminated(int state) {
            return (state & 0x40000000) == 0x40000000;
        }

        static boolean isCancelled(int state) {
            return (state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }

        static boolean isMonitorSet(int state) {
            return (state & 0x20000000) == 0x20000000;
        }
    }

    static final class RefCountMonitor<T>
    implements Consumer<Disposable> {
        final FluxRefCount<? extends T> parent;
        long subscribers;
        boolean terminated;
        boolean connected;
        volatile Disposable disconnect;
        static final AtomicReferenceFieldUpdater<RefCountMonitor, Disposable> DISCONNECT = AtomicReferenceFieldUpdater.newUpdater(RefCountMonitor.class, Disposable.class, "disconnect");

        RefCountMonitor(FluxRefCount<? extends T> parent) {
            this.parent = parent;
        }

        @Override
        public void accept(Disposable r) {
            OperatorDisposables.replace(DISCONNECT, this, r);
        }

        void innerCancelled() {
            this.parent.cancel(this);
        }

        void upstreamFinished() {
            this.parent.terminated(this);
        }
    }
}

