/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.number.FormattedNumberRange;
import com.ibm.icu.number.FractionPrecision;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.LocalizedNumberRangeFormatter;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.NumberRangeFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.Scale;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.ConstrainedFieldPosition;
import com.ibm.icu.text.FormattedValue;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.MeasureUnit;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.intl.NumberFormatFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.NumberFormatPrototypeBuiltins;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSNumberFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("NumberFormat");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("NumberFormat.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.NumberFormat");
    public static final TruffleString GET_FORMAT_NAME = Strings.constant("get format");
    static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey(Strings.toJavaString(CLASS_NAME));
    public static final JSNumberFormat INSTANCE = new JSNumberFormat();
    private static final Set<String> historicalCurrenciesInJDK = Set.of("ADP", "BEF", "BYB", "BYR", "ESP", "GRD", "ITL", "LUF", "MGF", "PTE", "ROL", "TPE", "TRL");
    private static final LazyValue<UnmodifiableEconomicMap<NumberFormat.Field, String>> fieldToTypeMap = new LazyValue<UnmodifiableEconomicMap>(JSNumberFormat::initializeFieldToTypeMap);

    private JSNumberFormat() {
    }

    public static boolean isJSNumberFormat(Object obj) {
        return obj instanceof JSNumberFormatObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject numberFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(numberFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, numberFormatPrototype, NumberFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, numberFormatPrototype, NumberFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(numberFormatPrototype, TO_STRING_TAG);
        return numberFormatPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static int currencyDigits(JSContext context, String currencyCode) {
        if (context.isOptionV8CompatibilityMode()) {
            return Currency.getInstance((String)currencyCode).getDefaultFractionDigits();
        }
        if (historicalCurrenciesInJDK.contains(currencyCode)) {
            return 2;
        }
        try {
            int digits = java.util.Currency.getInstance(currencyCode).getDefaultFractionDigits();
            return digits == -1 ? 2 : digits;
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, NumberFormatFunctionBuiltins.BUILTINS);
    }

    public static JSNumberFormatObject create(JSContext context, JSRealm realm) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getNumberFormatFactory();
        JSNumberFormatObject obj = new JSNumberFormatObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        return context.trackAllocation(obj);
    }

    private static Notation notationToICUNotation(String notation, String compactDisplay) {
        return switch (notation) {
            case "standard" -> Notation.simple();
            case "scientific" -> Notation.scientific();
            case "engineering" -> Notation.engineering();
            case "compact" -> "long".equals(compactDisplay) ? Notation.compactLong() : Notation.compactShort();
            default -> throw Errors.shouldNotReachHere(notation);
        };
    }

    private static NumberFormatter.UnitWidth currencyDisplayToUnitWidth(String currencyDisplay) {
        return switch (currencyDisplay) {
            case "code" -> NumberFormatter.UnitWidth.ISO_CODE;
            case "symbol" -> NumberFormatter.UnitWidth.SHORT;
            case "narrowSymbol" -> NumberFormatter.UnitWidth.NARROW;
            case "name" -> NumberFormatter.UnitWidth.FULL_NAME;
            default -> throw Errors.shouldNotReachHere(currencyDisplay);
        };
    }

    private static NumberFormatter.UnitWidth unitDisplayToUnitWidth(String unitDisplay) {
        return switch (unitDisplay) {
            case "short" -> NumberFormatter.UnitWidth.SHORT;
            case "narrow" -> NumberFormatter.UnitWidth.NARROW;
            case "long" -> NumberFormatter.UnitWidth.FULL_NAME;
            default -> throw Errors.shouldNotReachHere(unitDisplay);
        };
    }

    private static NumberFormatter.GroupingStrategy useGroupingToGroupingStrategy(Object useGrouping) {
        NumberFormatter.GroupingStrategy strategy;
        if (Boolean.FALSE.equals(useGrouping)) {
            strategy = NumberFormatter.GroupingStrategy.OFF;
        } else if ("min2".equals(useGrouping)) {
            strategy = NumberFormatter.GroupingStrategy.MIN2;
        } else if ("auto".equals(useGrouping)) {
            strategy = NumberFormatter.GroupingStrategy.AUTO;
        } else {
            assert ("always".equals(useGrouping));
            strategy = NumberFormatter.GroupingStrategy.ON_ALIGNED;
        }
        return strategy;
    }

    private static RoundingMode roundingModeToICURoundingMode(String roundingMode) {
        return switch (roundingMode) {
            case "ceil" -> RoundingMode.CEILING;
            case "floor" -> RoundingMode.FLOOR;
            case "expand" -> RoundingMode.UP;
            case "trunc" -> RoundingMode.DOWN;
            case "halfCeil" -> RoundingMode.HALF_UP;
            case "halfFloor" -> RoundingMode.HALF_DOWN;
            case "halfExpand" -> RoundingMode.HALF_UP;
            case "halfTrunc" -> RoundingMode.HALF_DOWN;
            case "halfEven" -> RoundingMode.HALF_EVEN;
            default -> throw Errors.shouldNotReachHere(roundingMode);
        };
    }

    private static MeasureUnit unitToMeasureUnit(String unit) {
        return switch (unit) {
            case "acre" -> MeasureUnit.ACRE;
            case "bit" -> MeasureUnit.BIT;
            case "byte" -> MeasureUnit.BYTE;
            case "celsius" -> MeasureUnit.CELSIUS;
            case "centimeter" -> MeasureUnit.CENTIMETER;
            case "day" -> MeasureUnit.DAY;
            case "degree" -> MeasureUnit.DEGREE;
            case "fahrenheit" -> MeasureUnit.FAHRENHEIT;
            case "fluid-ounce" -> MeasureUnit.FLUID_OUNCE;
            case "foot" -> MeasureUnit.FOOT;
            case "gallon" -> MeasureUnit.GALLON;
            case "gigabit" -> MeasureUnit.GIGABIT;
            case "gigabyte" -> MeasureUnit.GIGABYTE;
            case "gram" -> MeasureUnit.GRAM;
            case "hectare" -> MeasureUnit.HECTARE;
            case "hour" -> MeasureUnit.HOUR;
            case "inch" -> MeasureUnit.INCH;
            case "kilobit" -> MeasureUnit.KILOBIT;
            case "kilobyte" -> MeasureUnit.KILOBYTE;
            case "kilogram" -> MeasureUnit.KILOGRAM;
            case "kilometer" -> MeasureUnit.KILOMETER;
            case "liter" -> MeasureUnit.LITER;
            case "megabit" -> MeasureUnit.MEGABIT;
            case "megabyte" -> MeasureUnit.MEGABYTE;
            case "meter" -> MeasureUnit.METER;
            case "microsecond" -> MeasureUnit.MICROSECOND;
            case "mile" -> MeasureUnit.MILE;
            case "mile-scandinavian" -> MeasureUnit.MILE_SCANDINAVIAN;
            case "milliliter" -> MeasureUnit.MILLILITER;
            case "millimeter" -> MeasureUnit.MILLIMETER;
            case "millisecond" -> MeasureUnit.MILLISECOND;
            case "minute" -> MeasureUnit.MINUTE;
            case "month" -> MeasureUnit.MONTH;
            case "nanosecond" -> MeasureUnit.NANOSECOND;
            case "ounce" -> MeasureUnit.OUNCE;
            case "percent" -> MeasureUnit.PERCENT;
            case "petabyte" -> MeasureUnit.PETABYTE;
            case "pound" -> MeasureUnit.POUND;
            case "second" -> MeasureUnit.SECOND;
            case "stone" -> MeasureUnit.STONE;
            case "terabit" -> MeasureUnit.TERABIT;
            case "terabyte" -> MeasureUnit.TERABYTE;
            case "week" -> MeasureUnit.WEEK;
            case "yard" -> MeasureUnit.YARD;
            case "year" -> MeasureUnit.YEAR;
            default -> throw Errors.shouldNotReachHere(unit);
        };
    }

    private static NumberFormatter.SignDisplay signDisplay(String signDisplay, boolean accounting) {
        switch (signDisplay) {
            case "auto": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING : NumberFormatter.SignDisplay.AUTO;
            }
            case "never": {
                return NumberFormatter.SignDisplay.NEVER;
            }
            case "always": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS : NumberFormatter.SignDisplay.ALWAYS;
            }
            case "exceptZero": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING_EXCEPT_ZERO : NumberFormatter.SignDisplay.EXCEPT_ZERO;
            }
            case "negative": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING_NEGATIVE : NumberFormatter.SignDisplay.NEGATIVE;
            }
        }
        throw Errors.shouldNotReachHere(signDisplay);
    }

    private static FormattedValue formattedValue(InternalState state, Number x) {
        LocalizedNumberFormatter numberFormatter = state.getNumberFormatter(x.doubleValue() < 0.0);
        return numberFormatter.format(x);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString format(JSNumberFormatObject numberFormatObj, Object n) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        return Strings.fromJavaString(JSNumberFormat.formattedValue(state, x).toString());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatMV(JSNumberFormatObject numberFormatObj, Number mv) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        return Strings.fromJavaString(JSNumberFormat.formattedValue(state, mv).toString());
    }

    private static FormattedNumberRange formatRangeImpl(JSNumberFormatObject numberFormatObj, Number x, Number y) {
        boolean xNegative;
        if (JSRuntime.isNaN(x) || JSRuntime.isNaN(y)) {
            throw Errors.createRangeError("invalid range");
        }
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        boolean bl = x instanceof BigDecimal ? ((BigDecimal)x).signum() == -1 : (xNegative = (Double)x < 0.0);
        boolean yNegative = y instanceof BigDecimal ? ((BigDecimal)y).signum() == -1 : (Double)y < 0.0;
        LocalizedNumberRangeFormatter formatter = state.getNumberRangeFormatter(xNegative, yNegative);
        return formatter.formatRange(x, y);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString formatRange(JSNumberFormatObject numberFormatObj, Number x, Number y) {
        return Strings.fromJavaString(JSNumberFormat.formatRangeImpl(numberFormatObj, x, y).toString());
    }

    @CompilerDirectives.TruffleBoundary
    public static JSArrayObject formatRangeToParts(JSContext context, JSRealm realm, JSNumberFormatObject numberFormatObj, Number x, Number y) {
        FormattedNumberRange formattedRange = JSNumberFormat.formatRangeImpl(numberFormatObj, x, y);
        String formattedString = formattedRange.toString();
        ArrayList<JSObject> parts = new ArrayList<JSObject>();
        int startRangeStart = 0;
        int startRangeLimit = 0;
        int endRangeStart = 0;
        int endRangeLimit = 0;
        int lastLimit = 0;
        boolean seenGroupingSeparator = false;
        ConstrainedFieldPosition cfPos = new ConstrainedFieldPosition();
        while (formattedRange.nextPosition(cfPos)) {
            int start = cfPos.getStart();
            int limit = cfPos.getLimit();
            Format.Field field = cfPos.getField();
            if (lastLimit < start) {
                String type;
                String literal = formattedString.substring(lastLimit, start);
                String source = IntlUtil.sourceString(lastLimit, start, startRangeStart, startRangeLimit, endRangeStart, endRangeLimit);
                if (field == NumberFormat.Field.GROUPING_SEPARATOR) {
                    type = "integer";
                    seenGroupingSeparator = true;
                } else {
                    type = "literal";
                }
                parts.add(IntlUtil.makePart(context, realm, type, literal, null, source));
                lastLimit = start;
            }
            if (field instanceof NumberRangeFormatter.SpanField) {
                Object fieldValue = cfPos.getFieldValue();
                if (fieldValue.equals(0)) {
                    startRangeStart = start;
                    startRangeLimit = limit;
                    continue;
                }
                if (fieldValue.equals(1)) {
                    endRangeStart = start;
                    endRangeLimit = limit;
                    continue;
                }
                throw Errors.shouldNotReachHere(fieldValue.toString());
            }
            if (field instanceof NumberFormat.Field) {
                String type;
                int effectiveStart;
                if (field == NumberFormat.Field.INTEGER && seenGroupingSeparator) {
                    effectiveStart = lastLimit;
                    seenGroupingSeparator = false;
                } else {
                    assert (!seenGroupingSeparator || field == NumberFormat.Field.GROUPING_SEPARATOR);
                    effectiveStart = start;
                }
                String value2 = formattedString.substring(effectiveStart, limit);
                String source = IntlUtil.sourceString(start, limit, startRangeStart, startRangeLimit, endRangeStart, endRangeLimit);
                if (field == NumberFormat.Field.SIGN) {
                    type = JSNumberFormat.isPlusSign(value2) ? "plusSign" : "minusSign";
                } else if (field == NumberFormat.Field.INTEGER) {
                    Number val;
                    Number number = val = "endRange".equals(source) ? (Number)y : (Number)y;
                    type = JSRuntime.isNaN(val) ? "nan" : (val instanceof Double && Double.isInfinite((Double)val) ? "infinity" : "integer");
                } else {
                    type = JSNumberFormat.fieldToType((NumberFormat.Field)field);
                    assert (type != null) : field;
                }
                parts.add(IntlUtil.makePart(context, realm, type, value2, null, source));
                lastLimit = limit;
                continue;
            }
            throw Errors.shouldNotReachHere(field.toString());
        }
        int length2 = formattedString.length();
        if (lastLimit < length2) {
            String literal = formattedString.substring(lastLimit, length2);
            String source = IntlUtil.sourceString(lastLimit, length2, startRangeStart, startRangeLimit, endRangeStart, endRangeLimit);
            parts.add(IntlUtil.makePart(context, realm, "literal", literal, null, source));
        }
        return JSArray.createConstant(context, realm, parts.toArray());
    }

    private static UnmodifiableEconomicMap<NumberFormat.Field, String> initializeFieldToTypeMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<NumberFormat.Field, String> map2 = EconomicMap.create(6);
        map2.put(NumberFormat.Field.DECIMAL_SEPARATOR, "decimal");
        map2.put(NumberFormat.Field.FRACTION, "fraction");
        map2.put(NumberFormat.Field.GROUPING_SEPARATOR, "group");
        map2.put(NumberFormat.Field.CURRENCY, "currency");
        map2.put(NumberFormat.Field.MEASURE_UNIT, "unit");
        map2.put(NumberFormat.Field.EXPONENT_SYMBOL, "exponentSeparator");
        map2.put(NumberFormat.Field.EXPONENT_SIGN, "exponentMinusSign");
        map2.put(NumberFormat.Field.EXPONENT, "exponentInteger");
        map2.put(NumberFormat.Field.COMPACT, "compact");
        map2.put(NumberFormat.Field.APPROXIMATELY_SIGN, "approximatelySign");
        return map2;
    }

    private static String fieldToType(NumberFormat.Field field) {
        return fieldToTypeMap.get().get(field);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject formatToParts(JSContext context, JSRealm realm, JSDynamicObject numberFormatObj, Object n) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        FormattedValue formattedValue = JSNumberFormat.formattedValue(state, x);
        AttributedCharacterIterator fit = formattedValue.toCharacterIterator();
        String formatted = formattedValue.toString();
        List<JSDynamicObject> resultParts = JSNumberFormat.innerFormatToParts(context, realm, fit, x.doubleValue(), formatted, null, "percent".equals(state.getStyle()));
        return JSArray.createConstant(context, realm, resultParts.toArray());
    }

    static List<JSDynamicObject> innerFormatToParts(JSContext context, JSRealm realm, AttributedCharacterIterator iterator, double value2, String formattedValue, String unit, boolean stylePercent) {
        ArrayList<JSDynamicObject> resultParts = new ArrayList<JSDynamicObject>();
        int i = iterator.getBeginIndex();
        while (i < iterator.getEndIndex()) {
            iterator.setIndex(i);
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Set<AttributedCharacterIterator.Attribute> attKeySet = attributes.keySet();
            if (!attKeySet.isEmpty()) {
                Iterator<AttributedCharacterIterator.Attribute> iterator2 = attKeySet.iterator();
                if (!iterator2.hasNext()) continue;
                AttributedCharacterIterator.Attribute a = iterator2.next();
                if (a instanceof NumberFormat.Field) {
                    String type;
                    String run2 = formattedValue.substring(iterator.getRunStart(), iterator.getRunLimit());
                    if (a == NumberFormat.Field.INTEGER) {
                        type = Double.isNaN(value2) ? "nan" : (Double.isInfinite(value2) ? "infinity" : "integer");
                    } else if (a == NumberFormat.Field.SIGN) {
                        type = JSNumberFormat.isPlusSign(run2) ? "plusSign" : "minusSign";
                    } else if (a == NumberFormat.Field.PERCENT) {
                        type = stylePercent ? "percentSign" : "unit";
                    } else {
                        type = JSNumberFormat.fieldToType((NumberFormat.Field)a);
                        assert (type != null) : a;
                    }
                    resultParts.add(IntlUtil.makePart(context, realm, type, run2, unit));
                    i = iterator.getRunLimit();
                    continue;
                }
                throw Errors.shouldNotReachHere();
            }
            String run3 = formattedValue.substring(iterator.getRunStart(), iterator.getRunLimit());
            resultParts.add(IntlUtil.makePart(context, realm, "literal", run3, unit));
            i = iterator.getRunLimit();
        }
        return resultParts;
    }

    private static boolean isPlusSign(String str) {
        return str.length() == 1 && str.charAt(0) == '+';
    }

    private static Number toInternalNumberRepresentation(Object o) {
        if (o instanceof SafeInteger) {
            return ((SafeInteger)o).doubleValue();
        }
        if (o instanceof Double) {
            return Double.isNaN((Double)o) ? Double.NaN : (Double)o;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof BigInt) {
            return ((BigInt)o).bigIntegerValue();
        }
        throw Errors.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public static JSDynamicObject resolvedOptions(JSContext context, JSRealm realm, JSDynamicObject numberFormatObj) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        return state.toResolvedOptionsObject(context, realm);
    }

    public static InternalState getInternalState(JSDynamicObject obj) {
        assert (JSNumberFormat.isJSNumberFormat(obj));
        return ((JSNumberFormatObject)obj).getInternalState();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getNumberFormatPrototype();
    }

    public static class InternalState
    extends BasicInternalState {
        private LocalizedNumberFormatter positiveNumberFormatter;
        private LocalizedNumberFormatter negativeNumberFormatter;
        private LocalizedNumberRangeFormatter[] numberRangeFormatter;
        private String style;
        private String currency;
        private String currencyDisplay;
        private String currencySign;
        private String unit;
        private String unitDisplay;
        private Object useGrouping;
        private String notation;
        private String compactDisplay;
        private String signDisplay;
        JSDynamicObject boundFormatFunction;

        @Override
        void fillResolvedOptions(JSContext context, JSRealm realm, JSDynamicObject result2) {
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.getLocale()), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_NUMBERING_SYSTEM, Strings.fromJavaString(this.getNumberingSystem()), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_STYLE, Strings.fromJavaString(this.style), JSAttributes.getDefault());
            if (this.currency != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_CURRENCY, Strings.fromJavaString(this.currency), JSAttributes.getDefault());
            }
            if (this.currencyDisplay != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_CURRENCY_DISPLAY, Strings.fromJavaString(this.currencyDisplay), JSAttributes.getDefault());
            }
            if (this.currencySign != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_CURRENCY_SIGN, Strings.fromJavaString(this.currencySign), JSAttributes.getDefault());
            }
            if (this.unit != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_UNIT, Strings.fromJavaString(this.unit), JSAttributes.getDefault());
            }
            if (this.unitDisplay != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_UNIT_DISPLAY, Strings.fromJavaString(this.unitDisplay), JSAttributes.getDefault());
            }
            super.fillResolvedOptions(context, realm, result2);
            Object resolvedUseGrouping = this.useGrouping;
            if (this.useGrouping instanceof String && context.getEcmaScriptVersion() < 14) {
                resolvedUseGrouping = true;
            }
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_USE_GROUPING, resolvedUseGrouping instanceof String ? Strings.fromJavaString((String)resolvedUseGrouping) : resolvedUseGrouping, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_NOTATION, Strings.fromJavaString(this.notation), JSAttributes.getDefault());
            if (this.compactDisplay != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_COMPACT_DISPLAY, Strings.fromJavaString(this.compactDisplay), JSAttributes.getDefault());
            }
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_SIGN_DISPLAY, Strings.fromJavaString(this.signDisplay), JSAttributes.getDefault());
            String roundingType = this.getRoundingType();
            String resolvedRoundingType = "morePrecision".equals(roundingType) || "lessPrecision".equals(roundingType) ? roundingType : "auto";
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_ROUNDING_PRIORITY, Strings.fromJavaString(resolvedRoundingType), JSAttributes.getDefault());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initializeNumberFormatter() {
            super.initializeNumberFormatter();
            UnlocalizedNumberFormatter formatter = this.getUnlocalizedFormatter();
            formatter = (UnlocalizedNumberFormatter)formatter.notation(JSNumberFormat.notationToICUNotation(this.notation, this.compactDisplay));
            formatter = (UnlocalizedNumberFormatter)formatter.grouping(JSNumberFormat.useGroupingToGroupingStrategy(this.useGrouping));
            if ("currency".equals(this.style)) {
                formatter = (UnlocalizedNumberFormatter)formatter.unit((MeasureUnit)Currency.getInstance((String)this.currency));
                formatter = (UnlocalizedNumberFormatter)formatter.unitWidth(JSNumberFormat.currencyDisplayToUnitWidth(this.currencyDisplay));
            } else if ("percent".equals(this.style)) {
                formatter = (UnlocalizedNumberFormatter)formatter.unit(MeasureUnit.PERCENT);
                formatter = (UnlocalizedNumberFormatter)formatter.scale(Scale.powerOfTen((int)2));
            } else if ("unit".equals(this.style)) {
                String per = "-per-";
                int index = this.unit.indexOf(per);
                if (index == -1) {
                    formatter = (UnlocalizedNumberFormatter)formatter.unit(JSNumberFormat.unitToMeasureUnit(this.unit));
                } else {
                    String numerator = this.unit.substring(0, index);
                    String denominator = this.unit.substring(index + per.length());
                    formatter = (UnlocalizedNumberFormatter)formatter.unit(JSNumberFormat.unitToMeasureUnit(numerator));
                    formatter = (UnlocalizedNumberFormatter)formatter.perUnit(JSNumberFormat.unitToMeasureUnit(denominator));
                }
                formatter = (UnlocalizedNumberFormatter)formatter.unitWidth(JSNumberFormat.unitDisplayToUnitWidth(this.unitDisplay));
            }
            formatter = (UnlocalizedNumberFormatter)formatter.sign(JSNumberFormat.signDisplay(this.signDisplay, "accounting".equals(this.currencySign)));
            LocalizedNumberRangeFormatter rangeFormatter = NumberRangeFormatter.withLocale((Locale)this.getJavaLocale());
            this.numberRangeFormatter = new LocalizedNumberRangeFormatter[3];
            this.positiveNumberFormatter = formatter.locale(this.getJavaLocale());
            String roundingMode = this.getRoundingMode();
            if ("halfCeil".equals(roundingMode)) {
                negativeFormatter = (UnlocalizedNumberFormatter)formatter.roundingMode(RoundingMode.HALF_DOWN);
                this.numberRangeFormatter[0] = (LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterBoth(negativeFormatter);
                this.numberRangeFormatter[1] = (LocalizedNumberRangeFormatter)((LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterFirst(negativeFormatter)).numberFormatterSecond(formatter);
                this.numberRangeFormatter[2] = (LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterBoth(formatter);
                this.negativeNumberFormatter = (LocalizedNumberFormatter)this.positiveNumberFormatter.roundingMode(RoundingMode.HALF_DOWN);
            } else if ("halfFloor".equals(roundingMode)) {
                negativeFormatter = (UnlocalizedNumberFormatter)formatter.roundingMode(RoundingMode.HALF_UP);
                this.numberRangeFormatter[0] = (LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterBoth(negativeFormatter);
                this.numberRangeFormatter[1] = (LocalizedNumberRangeFormatter)((LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterFirst(negativeFormatter)).numberFormatterSecond(formatter);
                this.numberRangeFormatter[2] = (LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterBoth(formatter);
                this.negativeNumberFormatter = (LocalizedNumberFormatter)this.positiveNumberFormatter.roundingMode(RoundingMode.HALF_UP);
            } else {
                this.negativeNumberFormatter = this.positiveNumberFormatter;
                this.numberRangeFormatter[1] = this.numberRangeFormatter[2] = (LocalizedNumberRangeFormatter)rangeFormatter.numberFormatterBoth(formatter);
                this.numberRangeFormatter[0] = this.numberRangeFormatter[2];
            }
        }

        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setCurrencyDisplay(String currencyDisplay) {
            this.currencyDisplay = currencyDisplay;
        }

        public void setCurrencySign(String currencySign) {
            this.currencySign = currencySign;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setUnitDisplay(String unitDisplay) {
            this.unitDisplay = unitDisplay;
        }

        public void setGroupingUsed(Object useGrouping) {
            this.useGrouping = useGrouping;
        }

        public void setNotation(String notation) {
            this.notation = notation;
        }

        public void setCompactDisplay(String compactDisplay) {
            this.compactDisplay = compactDisplay;
        }

        public void setSignDisplay(String signDisplay) {
            this.signDisplay = signDisplay;
        }

        public LocalizedNumberFormatter getNumberFormatter(boolean forNegativeNumbers) {
            return forNegativeNumbers ? this.negativeNumberFormatter : this.positiveNumberFormatter;
        }

        public LocalizedNumberRangeFormatter getNumberRangeFormatter(boolean firstNegative, boolean secondNegative) {
            return this.numberRangeFormatter[secondNegative ? 0 : (firstNegative ? 1 : 2)];
        }

        public JSDynamicObject getBoundFormatFunction() {
            return this.boundFormatFunction;
        }

        public void setBoundFormatFunction(JSDynamicObject boundFormatFunction) {
            this.boundFormatFunction = boundFormatFunction;
        }
    }

    public static class BasicInternalState {
        private UnlocalizedNumberFormatter unlocalizedFormatter;
        private Locale javaLocale;
        private String locale;
        private String numberingSystem;
        private int minimumIntegerDigits;
        private Integer minimumFractionDigits;
        private Integer maximumFractionDigits;
        private Integer minimumSignificantDigits;
        private Integer maximumSignificantDigits;
        private String roundingType;
        private String roundingMode;
        private int roundingIncrement;
        private String trailingZeroDisplay;

        JSDynamicObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            JSObject resolvedOptions = JSOrdinary.create(context, realm);
            this.fillResolvedOptions(context, realm, resolvedOptions);
            return resolvedOptions;
        }

        void fillResolvedOptions(JSContext context, JSRealm realm, JSDynamicObject result2) {
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_MINIMUM_INTEGER_DIGITS, this.minimumIntegerDigits, JSAttributes.getDefault());
            if (this.minimumFractionDigits != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_MINIMUM_FRACTION_DIGITS, this.minimumFractionDigits, JSAttributes.getDefault());
            }
            if (this.maximumFractionDigits != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_MAXIMUM_FRACTION_DIGITS, this.maximumFractionDigits, JSAttributes.getDefault());
            }
            if (this.minimumSignificantDigits != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_MINIMUM_SIGNIFICANT_DIGITS, this.minimumSignificantDigits, JSAttributes.getDefault());
            }
            if (this.maximumSignificantDigits != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_MAXIMUM_SIGNIFICANT_DIGITS, this.maximumSignificantDigits, JSAttributes.getDefault());
            }
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_ROUNDING_MODE, Strings.fromJavaString(this.roundingMode), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_ROUNDING_INCREMENT, this.roundingIncrement, JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_TRAILING_ZERO_DISPLAY, Strings.fromJavaString(this.trailingZeroDisplay), JSAttributes.getDefault());
        }

        @CompilerDirectives.TruffleBoundary
        public void resolveLocaleAndNumberingSystem(JSContext ctx, String[] locales, String numberingSystemOpt) {
            Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
            Locale strippedLocale = selectedLocale.stripExtensions();
            if (strippedLocale.toLanguageTag().equals("und")) {
                selectedLocale = ctx.getLocale();
                strippedLocale = selectedLocale.stripExtensions();
            }
            Locale.Builder builder2 = new Locale.Builder();
            builder2.setLocale(strippedLocale);
            String nuType = selectedLocale.getUnicodeLocaleType("nu");
            if (nuType != null && IntlUtil.isValidNumberingSystem(nuType) && (numberingSystemOpt == null || numberingSystemOpt.equals(nuType))) {
                this.numberingSystem = nuType;
                builder2.setUnicodeLocaleKeyword("nu", nuType);
            }
            this.locale = builder2.build().toLanguageTag();
            if (numberingSystemOpt != null && IntlUtil.isValidNumberingSystem(numberingSystemOpt)) {
                this.numberingSystem = numberingSystemOpt;
                builder2.setUnicodeLocaleKeyword("nu", numberingSystemOpt);
            }
            this.javaLocale = builder2.build();
            if (this.numberingSystem == null) {
                this.numberingSystem = IntlUtil.defaultNumberingSystemName(ctx, this.javaLocale);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public void initializeNumberFormatter() {
            Precision precision;
            UnlocalizedNumberFormatter formatter = NumberFormatter.with();
            formatter = (UnlocalizedNumberFormatter)formatter.roundingMode(JSNumberFormat.roundingModeToICURoundingMode(this.roundingMode));
            formatter = (UnlocalizedNumberFormatter)formatter.symbols(NumberingSystem.getInstanceByName((String)this.numberingSystem));
            formatter = (UnlocalizedNumberFormatter)formatter.integerWidth(IntegerWidth.zeroFillTo((int)this.minimumIntegerDigits));
            if ("significantDigits".equals(this.roundingType)) {
                precision = Precision.minMaxSignificantDigits((int)this.minimumSignificantDigits, (int)this.maximumSignificantDigits);
            } else {
                FractionPrecision fractionPrecision = Precision.minMaxFraction((int)this.minimumFractionDigits, (int)this.maximumFractionDigits);
                if ("fractionDigits".equals(this.roundingType)) {
                    precision = fractionPrecision;
                } else {
                    boolean morePrecision = "morePrecision".equals(this.roundingType);
                    assert (morePrecision || "lessPrecision".equals(this.roundingType));
                    precision = fractionPrecision.withSignificantDigits(this.minimumSignificantDigits.intValue(), this.maximumSignificantDigits.intValue(), morePrecision ? NumberFormatter.RoundingPriority.RELAXED : NumberFormatter.RoundingPriority.STRICT);
                }
            }
            if (this.roundingIncrement != 1) {
                assert (Objects.equals(this.getMinimumFractionDigits(), this.getMaximumFractionDigits()));
                BigDecimal increment = BigDecimal.ONE.movePointLeft(this.getMaximumFractionDigits()).multiply(BigDecimal.valueOf(this.roundingIncrement));
                precision = Precision.increment((BigDecimal)increment);
            }
            if ("stripIfInteger".equals(this.trailingZeroDisplay)) {
                precision = precision.trailingZeroDisplay(NumberFormatter.TrailingZeroDisplay.HIDE_IF_WHOLE);
            }
            this.unlocalizedFormatter = formatter = (UnlocalizedNumberFormatter)formatter.precision(precision);
        }

        public UnlocalizedNumberFormatter getUnlocalizedFormatter() {
            return this.unlocalizedFormatter;
        }

        public Locale getJavaLocale() {
            return this.javaLocale;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getNumberingSystem() {
            return this.numberingSystem;
        }

        public void setMinimumIntegerDigits(int minimumIntegerDigits) {
            this.minimumIntegerDigits = minimumIntegerDigits;
        }

        public int getMinimumIntegerDigits() {
            return this.minimumIntegerDigits;
        }

        public void setMinimumFractionDigits(int minimumFractionDigits) {
            this.minimumFractionDigits = minimumFractionDigits;
        }

        public Integer getMinimumFractionDigits() {
            return this.minimumFractionDigits;
        }

        public void setMaximumFractionDigits(int maximumFractionDigits) {
            this.maximumFractionDigits = maximumFractionDigits;
        }

        public Integer getMaximumFractionDigits() {
            return this.maximumFractionDigits;
        }

        public void setMinimumSignificantDigits(int minimumSignificantDigits) {
            this.minimumSignificantDigits = minimumSignificantDigits;
        }

        public Integer getMinimumSignificantDigits() {
            return this.minimumSignificantDigits;
        }

        public void setMaximumSignificantDigits(int maximumSignificantDigits) {
            this.maximumSignificantDigits = maximumSignificantDigits;
        }

        public Integer getMaximumSignificantDigits() {
            return this.maximumSignificantDigits;
        }

        public void setRoundingType(String roundingType) {
            this.roundingType = roundingType;
        }

        public String getRoundingType() {
            return this.roundingType;
        }

        public void setRoundingMode(String roundingMode) {
            this.roundingMode = roundingMode;
        }

        public String getRoundingMode() {
            return this.roundingMode;
        }

        public void setRoundingIncrement(int roundingIncrement) {
            this.roundingIncrement = roundingIncrement;
        }

        public void setTrailingZeroDisplay(String trailingZeroDisplay) {
            this.trailingZeroDisplay = trailingZeroDisplay;
        }
    }
}

