/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WeakMapPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakMapObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.WeakMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class WeakMapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WeakMapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WeakMapPrototypeBuiltins();

    protected WeakMapPrototypeBuiltins() {
        super(JSWeakMap.PROTOTYPE_NAME, WeakMapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WeakMapPrototype builtinEnum) {
        switch (builtinEnum) {
            case delete: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapDeleteNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapSetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case get: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapGetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapHasNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static RuntimeException typeErrorKeyIsNotValid() {
        throw Errors.createTypeError("Invalid value used as weak map key");
    }

    protected static RuntimeException typeErrorWeakMapExpected() {
        throw Errors.createTypeError("WeakMap expected");
    }

    public static enum WeakMapPrototype implements BuiltinEnum<WeakMapPrototype>
    {
        delete(1),
        set(2),
        get(1),
        has(1);

        private final int length;

        private WeakMapPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapDeleteNode
    extends JSWeakMapBaseNode {
        public JSWeakMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected boolean delete(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached InlinedConditionProfile hasInvertedProfile) {
            WeakMap map2 = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapDeleteNode.getInvertedMap(key2, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapDeleteNode.castWeakHashMap(inverted);
                return Boundaries.mapRemove(invertedMap, map2) != null;
            }
            return false;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean deleteInvalidKey(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key2) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapSetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected Object set(JSWeakMapObject thisObj, Object key2, Object value2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedSetter, @Cached InlinedConditionProfile hasInvertedProfile) {
            WeakMap map2 = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapSetNode.getInvertedMap(key2, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapSetNode.castWeakHashMap(inverted);
                JSWeakMapSetNode.mapPut(invertedMap, map2, value2);
            } else {
                Map<WeakMap, Object> newInvertedMap = map2.newInvertedMapWithEntry(key2, value2);
                if (key2 instanceof JSObject) {
                    invertedSetter.put((JSObject)key2, WeakMap.INVERTED_WEAK_MAP_KEY, newInvertedMap);
                } else if (key2 instanceof Symbol) {
                    ((Symbol)key2).setInvertedMap(newInvertedMap);
                }
            }
            return thisObj;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static Object setInvalidKey(JSWeakMapObject thisObj, Object key2, Object value2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            throw WeakMapPrototypeBuiltins.typeErrorKeyIsNotValid();
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key2, Object value2) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapPut(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map2, Object value2) {
            return invertedMap.put(map2, value2);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapGetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected Object get(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached InlinedConditionProfile hasInvertedProfile) {
            WeakHashMap<WeakMap, Object> invertedMap;
            Object value2;
            WeakMap map2 = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapGetNode.getInvertedMap(key2, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null) && (value2 = JSWeakMapGetNode.mapGet(invertedMap = JSWeakMapGetNode.castWeakHashMap(inverted), map2)) != null) {
                return value2;
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static Object getInvalidKey(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key2) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapGet(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map2) {
            return invertedMap.get(map2);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapHasNode
    extends JSWeakMapBaseNode {
        public JSWeakMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected boolean has(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached InlinedConditionProfile hasInvertedProfile) {
            WeakMap map2 = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapHasNode.getInvertedMap(key2, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapHasNode.castWeakHashMap(inverted);
                return JSWeakMapHasNode.mapHas(invertedMap, map2);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static boolean mapHas(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map2) {
            return invertedMap.containsKey(map2);
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"}, limit="1")
        protected static boolean hasInvalidKey(JSWeakMapObject thisObj, Object key2, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key2) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    protected static abstract class JSWeakMapBaseNode
    extends JSBuiltinNode {
        protected JSWeakMapBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static Object getInvertedMap(Object key2, DynamicObjectLibrary library) {
            if (key2 instanceof JSObject) {
                return library.getOrDefault((JSObject)key2, WeakMap.INVERTED_WEAK_MAP_KEY, null);
            }
            if (key2 instanceof Symbol) {
                return ((Symbol)key2).getInvertedMap();
            }
            return null;
        }

        protected static WeakHashMap<WeakMap, Object> castWeakHashMap(Object map2) {
            return CompilerDirectives.castExact(map2, WeakHashMap.class);
        }
    }
}

