/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.action;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentFileNames;
import com.intellij.httpClient.postman.converter.HttpEnvResult;
import com.intellij.httpClient.postman.converter.PostmanEnvironmentConversionResult;
import com.intellij.httpClient.postman.converter.PostmanEnvironmentConverter;
import com.intellij.httpClient.postman.converter.action.HttpEnvironmentFiles;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\"\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003\u001a \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"environmentConverter", "Lcom/intellij/httpClient/postman/converter/PostmanEnvironmentConverter;", "getEnvironmentConverter", "()Lcom/intellij/httpClient/postman/converter/PostmanEnvironmentConverter;", "findHttpEnvFiles", "Lcom/intellij/httpClient/postman/converter/action/HttpEnvironmentFiles;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "saveEnvAndReformat", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "saveHttpEnvAndReformat", "result", "Lcom/intellij/httpClient/postman/converter/PostmanEnvironmentConversionResult;", "postmanParent", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nConvertEnvironmentActionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertEnvironmentActionUtil.kt\ncom/intellij/httpClient/postman/converter/action/ConvertEnvironmentActionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class ConvertEnvironmentActionUtilKt {
    @NotNull
    private static final PostmanEnvironmentConverter environmentConverter = new PostmanEnvironmentConverter();

    @NotNull
    public static final PostmanEnvironmentConverter getEnvironmentConverter() {
        return environmentConverter;
    }

    @Nullable
    public static final HttpEnvironmentFiles findHttpEnvFiles(@NotNull VirtualFile file) {
        VirtualFile privateEnvFile;
        VirtualFile virtualFile;
        VirtualFile publicEnvFile;
        block6: {
            VirtualFile virtualFile2;
            int n;
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentFileNames.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
                Object[] objectArray = HttpRequestEnvironmentFileNames.ENV_FILE_NAMES;
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    String it = (String)objectArray[i];
                    boolean bl = false;
                    virtualFile2 = file.getParent().findChild(it);
                    if (virtualFile2 == null) {
                        continue;
                    }
                    break block5;
                }
                virtualFile2 = null;
            }
            publicEnvFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentFileNames.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
            Object[] objectArray = HttpRequestEnvironmentFileNames.ENV_PRIVATE_FILE_NAMES;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                String it = (String)objectArray[n];
                boolean bl = false;
                virtualFile = file.getParent().findChild(it);
                if (virtualFile == null) {
                    continue;
                }
                break block6;
            }
            virtualFile = null;
        }
        if ((privateEnvFile = virtualFile) == null && publicEnvFile == null) {
            return null;
        }
        return new HttpEnvironmentFiles(publicEnvFile, privateEnvFile);
    }

    @RequiresWriteLock
    @NotNull
    public static final HttpEnvironmentFiles saveHttpEnvAndReformat(@NotNull PostmanEnvironmentConversionResult result2, @NotNull VirtualFile postmanParent, @NotNull Project project) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)postmanParent, (String)"postmanParent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HttpEnvResult httpEnvResult = result2.getPublicHttpEnvResult();
        if (httpEnvResult != null) {
            HttpEnvResult publicHttpEnvResult = httpEnvResult;
            boolean bl = false;
            VirtualFile virtualFile3 = publicHttpEnvResult.getFile();
            if (virtualFile3 == null) {
                VirtualFile virtualFile4 = postmanParent.createChildData(null, "http-client.env.json");
                virtualFile3 = virtualFile4;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildData(...)");
            }
            VirtualFile publicHttpEnvFile = virtualFile3;
            virtualFile2 = ConvertEnvironmentActionUtilKt.saveEnvAndReformat(project, publicHttpEnvFile, publicHttpEnvResult.getText());
        } else {
            virtualFile2 = null;
        }
        VirtualFile publicFile = virtualFile2;
        HttpEnvResult httpEnvResult2 = result2.getPrivateHttpEnvResult();
        if (httpEnvResult2 != null) {
            HttpEnvResult privateHttpEnvResult = httpEnvResult2;
            boolean bl = false;
            VirtualFile virtualFile5 = privateHttpEnvResult.getFile();
            if (virtualFile5 == null) {
                VirtualFile virtualFile6 = postmanParent.createChildData(null, "http-client.private.env.json");
                virtualFile5 = virtualFile6;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile6, (String)"createChildData(...)");
            }
            VirtualFile publicHttpEnvFile = virtualFile5;
            virtualFile = ConvertEnvironmentActionUtilKt.saveEnvAndReformat(project, publicHttpEnvFile, privateHttpEnvResult.getText());
        } else {
            virtualFile = null;
        }
        VirtualFile privateFile = virtualFile;
        return new HttpEnvironmentFiles(publicFile, privateFile);
    }

    @RequiresWriteLock
    private static final VirtualFile saveEnvAndReformat(Project project, VirtualFile file, String text2) {
        ProgressManager.checkCanceled();
        VfsUtil.saveText((VirtualFile)file, (String)text2);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile envPsiFile = psiFile;
        ReformatCodeProcessor reformatCodeProcessor = new ReformatCodeProcessor(project, envPsiFile, null, false);
        reformatCodeProcessor.run();
        return envPsiFile.getVirtualFile();
    }
}

