/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.intellij.httpClient.postman.converter.PostmanComboboxModel;
import com.intellij.httpClient.postman.converter.PostmanFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.util.List;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u0004\u0018\u00010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/postman/converter/PostmanCombobox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/httpClient/postman/converter/PostmanFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/intellij/httpClient/postman/converter/PostmanComboboxModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPath", "getTextEditor", "Ljavax/swing/JTextField;", "setHistory", "", "history", "", "setTextAndAddToHistory", "path", "intellij.restClient"})
final class PostmanCombobox
extends ComboBox<PostmanFile> {
    @NotNull
    private final Project project;
    @NotNull
    private final PostmanComboboxModel model;

    public PostmanCombobox(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.model = new PostmanComboboxModel();
        this.setModel(this.model);
        this.setEditable(true);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JTextField getTextEditor() {
        Component component2 = this.getEditor().getEditorComponent();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        return (JTextField)component2;
    }

    public final void setHistory(@NotNull List<PostmanFile> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.model.setItems(history);
    }

    @Nullable
    public final PostmanFile getPath() {
        return this.model.getSelectedItem();
    }

    public final void setTextAndAddToHistory(@NotNull PostmanFile path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.getTextEditor().setText(path2.getView());
        this.model.addElement(path2);
        this.model.setSelectedItem(path2);
    }
}

