/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.codeInsight.HttpClientSwitchEnvironmentIntentionKt;
import com.intellij.httpClient.jsonPath.HttpClientUnresolvedVariableInspectionKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/jsonPath/SelectEnvFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "varName", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "intellij.restClient"})
final class SelectEnvFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String varName;

    public SelectEnvFix(@NotNull PsiElement element, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        super(element);
        this.varName = varName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.varName};
        String string = RestClientBundle.message("http.client.unresolved.variable.select.env.with.var.quickfix.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (editor2 == null) {
            return;
        }
        PsiFile psiFile = startElement.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile);
        List environments2 = HttpClientUnresolvedVariableInspectionKt.access$envsWithVariable(psiFile, this.varName);
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        HttpClientSwitchEnvironmentIntentionKt.showPopupAndSelectEnvironment(environments2, project, virtualFile, editor2);
    }
}

