/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.jsonpath.JsonPathLanguage;
import com.intellij.jsonpath.psi.JsonPathFile;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\bH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/jsonPath/HttpRequestJsonPathReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "(Lcom/intellij/psi/PsiElement;)V", "generateDummyFile", "Lcom/intellij/jsonpath/psi/JsonPathFile;", "name", "", "handleElementRename", "newElementName", "resolve", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestJsonPathReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestJsonPathReferenceContributor.kt\ncom/intellij/httpClient/jsonPath/HttpRequestJsonPathReference\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,125:1\n14#2:126\n*S KotlinDebug\n*F\n+ 1 HttpRequestJsonPathReferenceContributor.kt\ncom/intellij/httpClient/jsonPath/HttpRequestJsonPathReference\n*L\n90#1:126\n*E\n"})
public abstract class HttpRequestJsonPathReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    public HttpRequestJsonPathReference(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element, true);
    }

    @Nullable
    public PsiElement resolve() {
        Object object;
        Object[] objectArray = this.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"multiResolve(...)");
        Object[] resolveResults = objectArray;
        if (resolveResults.length > 1) {
            object = null;
        } else {
            ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])resolveResults);
            object = resolveResult != null ? resolveResult.getElement() : null;
        }
        return object;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        JsonPathFile file = this.generateDummyFile(newElementName);
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)file), this.getElement().getClass());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        PsiElement replaceElement = (PsiElement)CollectionsKt.firstOrNull((Iterable)collection);
        if (replaceElement == null) {
            Object[] objectArray = new Object[]{newElementName};
            throw new IncorrectOperationException(RestClientBundle.message("http.client.refactoring.invalid.variable.name", objectArray));
        }
        PsiElement psiElement = this.getElement().replace(replaceElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replace(...)");
        return psiElement;
    }

    private final JsonPathFile generateDummyFile(String name) {
        PsiFile created;
        Object text2 = this.getElement() instanceof JsonPathStringLiteral ? "['" + name + "']" : name;
        PsiFile $this$asSafely$iv = created = PsiFileFactory.getInstance((Project)this.getElement().getProject()).createFileFromText((Language)JsonPathLanguage.INSTANCE, (CharSequence)text2);
        boolean $i$f$asSafely = false;
        PsiFile psiFile = $this$asSafely$iv;
        if (!(psiFile instanceof JsonPathFile)) {
            psiFile = null;
        }
        return (JsonPathFile)psiFile;
    }
}

