/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.environment.HttpClientCustomVariable;
import com.intellij.httpClient.http.request.environment.HttpClientCustomVariableDeclarationProviders;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.microservices.endpoints.EmbeddedHttpClientEditor;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.httpClient.jsonPath.AddFileVariableQuickFix;
import com.intellij.httpClient.jsonPath.AddPreRequestHandlerInCurrentFileFix;
import com.intellij.httpClient.jsonPath.AddPreRequestHandlerInReferencedFile;
import com.intellij.httpClient.jsonPath.AddVariableFix;
import com.intellij.httpClient.jsonPath.CreateEnvFileFix;
import com.intellij.httpClient.jsonPath.HttpClientUnresolvedVariableInspection;
import com.intellij.httpClient.jsonPath.HttpClientUnresolvedVariableInspectionKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001f\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u00142\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/jsonPath/HttpClientUnresolvedVariableInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "env", "", "name", "element", "Lcom/intellij/psi/PsiElement;", "getKeyData", "Lcom/intellij/httpClient/jsonPath/HttpClientUnresolvedVariableInspection$KeyData;", "getMessage", "Lcom/intellij/codeInspection/util/InspectionMessage;", "variable", "hasVariable", "contextElement", "KeyData", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientUnresolvedVariableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientUnresolvedVariableInspection.kt\ncom/intellij/httpClient/jsonPath/HttpClientUnresolvedVariableInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n1#2:461\n1747#3,3:462\n*S KotlinDebug\n*F\n+ 1 HttpClientUnresolvedVariableInspection.kt\ncom/intellij/httpClient/jsonPath/HttpClientUnresolvedVariableInspection\n*L\n151#1:462,3\n*E\n"})
public final class HttpClientUnresolvedVariableInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (file.getVirtualFile() == null || !(file instanceof HttpRequestPsiFile) || EmbeddedHttpClientEditor.Companion.isInEmbeddedHttpClientEditor((PsiElement)file)) {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        } else {
            Project project = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HttpClientSelectedEnvironments httpClientSelectedEnvironments = HttpClientSelectedEnvironments.Companion.getInstance(project);
            VirtualFile virtualFile = holder.getFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            String env = httpClientSelectedEnvironments.get(virtualFile);
            if (HttpClientSelectedEnvironments.Companion.isSelectBeforeRun(env)) {
                PsiElementVisitor psiElementVisitor3 = PsiElementVisitor.EMPTY_VISITOR;
                Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor3, (String)"EMPTY_VISITOR");
                return psiElementVisitor3;
            }
            psiElementVisitor = new PsiElementVisitor(this, env, isOnTheFly, holder){
                final /* synthetic */ HttpClientUnresolvedVariableInspection this$0;
                final /* synthetic */ String $env;
                final /* synthetic */ boolean $isOnTheFly;
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.this$0 = $receiver;
                    this.$env = $env;
                    this.$isOnTheFly = $isOnTheFly;
                    this.$holder = $holder;
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof HttpVariable) {
                        String name = ((HttpVariable)element).getName();
                        CharSequence charSequence = name;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            return;
                        }
                        KeyData keyData = HttpClientUnresolvedVariableInspection.access$getKeyData(this.this$0, name);
                        if (!keyData.getShouldBeChecked()) {
                            return;
                        }
                        String keyName = keyData.getName();
                        if (!HttpClientUnresolvedVariableInspection.access$hasVariable(this.this$0, this.$env, element, keyName)) {
                            List fixes = HttpClientUnresolvedVariableInspection.access$createFixes(this.this$0, this.$isOnTheFly, this.$env, keyName, element);
                            String string = HttpClientUnresolvedVariableInspection.access$getMessage(this.this$0, this.$env, keyName);
                            Collection collection = fixes;
                            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                            LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                            this.$holder.registerProblem(element, string, ProblemHighlightType.WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                        }
                    } else if (element instanceof HttpMessageBody) {
                        void $this$forEach$iv;
                        Sequence undeclaredVariables2;
                        String messageBody = ((HttpMessageBody)element).getText();
                        List<TextRange> list2 = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody);
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"collectVariablesRangesInMessageBody(...)");
                        Sequence keyName = undeclaredVariables2 = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<TextRange, Pair<? extends TextRange, ? extends String>>(messageBody){
                            final /* synthetic */ String $messageBody;
                            {
                                this.$messageBody = $messageBody;
                                super(1);
                            }

                            @NotNull
                            public final Pair<TextRange, String> invoke(TextRange it) {
                                return TuplesKt.to((Object)it, (Object)HttpRequestPsiUtils.getVariableNameRange(this.$messageBody, it).substring(this.$messageBody));
                            }
                        })), (Function1)buildVisitor.visitElement.undeclaredVariables.2.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends TextRange, ? extends String>, Pair<? extends TextRange, ? extends String>>(this.this$0, this.$env, element){
                            final /* synthetic */ HttpClientUnresolvedVariableInspection this$0;
                            final /* synthetic */ String $env;
                            final /* synthetic */ PsiElement $element;
                            {
                                this.this$0 = $receiver;
                                this.$env = $env;
                                this.$element = $element;
                                super(1);
                            }

                            @Nullable
                            public final Pair<TextRange, String> invoke(@NotNull Pair<? extends TextRange, String> pair) {
                                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                                TextRange range = (TextRange)pair.component1();
                                String name = (String)pair.component2();
                                Intrinsics.checkNotNull((Object)name);
                                KeyData keyData = HttpClientUnresolvedVariableInspection.access$getKeyData(this.this$0, name);
                                if (!keyData.getShouldBeChecked()) {
                                    return null;
                                }
                                if (HttpClientUnresolvedVariableInspection.access$hasVariable(this.this$0, this.$env, this.$element, keyData.getName())) {
                                    return null;
                                }
                                return TuplesKt.to((Object)range, (Object)keyData.getName());
                            }
                        }));
                        HttpClientUnresolvedVariableInspection httpClientUnresolvedVariableInspection = this.this$0;
                        String string = this.$env;
                        ProblemsHolder problemsHolder = this.$holder;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            Pair pair = (Pair)element$iv;
                            boolean bl = false;
                            TextRange range = (TextRange)pair.component1();
                            String name = (String)pair.component2();
                            List fixes = HttpClientUnresolvedVariableInspection.access$createFixes(httpClientUnresolvedVariableInspection, true, string, name, element);
                            InspectionManager inspectionManager = problemsHolder.getManager();
                            String string2 = HttpClientUnresolvedVariableInspection.access$getMessage(httpClientUnresolvedVariableInspection, string, name);
                            Collection collection = fixes;
                            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                            LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
                            ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(element, range, string2, ProblemHighlightType.WEAK_WARNING, true, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                            ProblemDescriptor problem = problemDescriptor;
                            problemsHolder.registerProblem(problem);
                        }
                    }
                }
            };
        }
        return psiElementVisitor;
    }

    private final KeyData getKeyData(String name) {
        String path2 = HttpClientJsonVariablesHelperKt.compileJsonPathSafely(name);
        if (path2 == null) {
            return new KeyData(name, false);
        }
        if (StringsKt.startsWith$default((String)path2, (String)"$..", (boolean)false, (int)2, null)) {
            return new KeyData(name, false);
        }
        String bracesRegexp = "\\[(?<index>[0-9|\\*]+)]";
        Regex pathRegexp = new Regex("(\\['(?<keyName>[\\w-.]+)'])|(" + bracesRegexp + ")");
        Object object = Regex.find$default((Regex)pathRegexp, (CharSequence)path2, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, (String)"keyName")) == null || (object = object.getValue()) == null) {
            return new KeyData(name, false);
        }
        Object key2 = object;
        return new KeyData((String)key2, true);
    }

    private final List<LocalQuickFix> createFixes(boolean isOnTheFly, String env, String name, PsiElement element) {
        List list2;
        if (isOnTheFly) {
            Object[] objectArray = new LocalQuickFix[]{env != null ? new AddVariableFix(false, env, name, element) : null, env != null ? new AddVariableFix(true, env, name, element) : null, HttpClientUnresolvedVariableInspectionKt.access$selectEnvFixIfApplicable(element, name), env == null ? new CreateEnvFileFix(element, name) : null, new AddPreRequestHandlerInCurrentFileFix(element, name), new AddPreRequestHandlerInReferencedFile(element, name), new AddFileVariableQuickFix(name)};
            list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List fixes = list2;
        return fixes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasVariable(String env, PsiElement contextElement, String variable2) {
        HttpClientCustomVariable it;
        PsiFile psiFile = contextElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!((Collection)HttpClientFileVariableStorage.Companion.findVariableIn(psiFile, variable2)).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if (env != null) {
            boolean bl2;
            Set<String> set2;
            PsiFile psiFile2 = contextElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor = HttpClientEnvironmentsProvider.INSTANCE.getByName(psiFile2, env);
            if (environmentDescriptor != null && (set2 = environmentDescriptor.getVariables()) != null) {
                Set<String> it2 = set2;
                boolean bl3 = false;
                if (it2.contains(variable2)) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
        }
        boolean bl4 = false;
        boolean hasInIndex = bl4;
        if (hasInIndex) return true;
        Iterable<HttpClientCustomVariable> $this$any$iv = HttpClientCustomVariableDeclarationProviders.getAllCustomDeclarationForContext(variable2, contextElement);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<HttpClientCustomVariable> iterator = $this$any$iv.iterator();
        do {
            HttpClientCustomVariable element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl5 = false;
        } while (!Intrinsics.areEqual((Object)it.getName(), (Object)variable2));
        return true;
    }

    private final String getMessage(String env, String variable2) {
        String string;
        if (env != null) {
            Object[] objectArray = new Object[]{variable2, env};
            String string2 = RestClientBundle.message("http.client.unresolved.variable.with.dev.message", objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            Object[] objectArray = new Object[]{variable2};
            String string3 = RestClientBundle.message("http.client.unresolved.variable.without.dev.message", objectArray);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    public static final /* synthetic */ KeyData access$getKeyData(HttpClientUnresolvedVariableInspection $this, String name) {
        return $this.getKeyData(name);
    }

    public static final /* synthetic */ boolean access$hasVariable(HttpClientUnresolvedVariableInspection $this, String env, PsiElement contextElement, String variable2) {
        return $this.hasVariable(env, contextElement, variable2);
    }

    public static final /* synthetic */ List access$createFixes(HttpClientUnresolvedVariableInspection $this, boolean isOnTheFly, String env, String name, PsiElement element) {
        return $this.createFixes(isOnTheFly, env, name, element);
    }

    public static final /* synthetic */ String access$getMessage(HttpClientUnresolvedVariableInspection $this, String env, String variable2) {
        return $this.getMessage(env, variable2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/jsonPath/HttpClientUnresolvedVariableInspection$KeyData;", "", "name", "", "shouldBeChecked", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getShouldBeChecked", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class KeyData {
        @NotNull
        private final String name;
        private final boolean shouldBeChecked;

        public KeyData(@NotNull String name, boolean shouldBeChecked) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.shouldBeChecked = shouldBeChecked;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getShouldBeChecked() {
            return this.shouldBeChecked;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.shouldBeChecked;
        }

        @NotNull
        public final KeyData copy(@NotNull String name, boolean shouldBeChecked) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new KeyData(name, shouldBeChecked);
        }

        public static /* synthetic */ KeyData copy$default(KeyData keyData, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = keyData.name;
            }
            if ((n & 2) != 0) {
                bl = keyData.shouldBeChecked;
            }
            return keyData.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "KeyData(name=" + this.name + ", shouldBeChecked=" + this.shouldBeChecked + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.shouldBeChecked);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KeyData)) {
                return false;
            }
            KeyData keyData = (KeyData)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)keyData.name)) {
                return false;
            }
            return this.shouldBeChecked == keyData.shouldBeChecked;
        }
    }
}

