/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console.presentations;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.httpClient.http.request.run.console.HttpResponseCustomPresentation;
import com.intellij.httpClient.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplacePdfResponsePresentationKt;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.HttpInplaceSucceedResponsePresentation;
import com.intellij.httpClient.http.request.run.console.presentations.inPlace.PdfPreviewFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/http/request/run/console/presentations/HttpResponseFilePathPresentation;", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseCustomPresentation;", "()V", "order", "Lcom/intellij/httpClient/http/request/run/console/HttpResponseCustomPresentation$Order;", "getOrder", "()Lcom/intellij/httpClient/http/request/run/console/HttpResponseCustomPresentation$Order;", "print", "", "response", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "requestPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "printer", "Lcom/intellij/httpClient/http/request/run/console/HttpClientMessagePrinter;", "retrievePdfFile", "Lcom/intellij/httpClient/http/request/run/console/HttpSingleResponseConsole$HtmlPreviewFileEditorProvider$HtmlPreviewVirtualFile;", "body", "Lcom/intellij/httpClient/execution/common/CommonClientResponseBody;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpResponseFilePathPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpResponseFilePathPresentation.kt\ncom/intellij/httpClient/http/request/run/console/presentations/HttpResponseFilePathPresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class HttpResponseFilePathPresentation
implements HttpResponseCustomPresentation {
    @Override
    @NotNull
    public HttpResponseCustomPresentation.Order getOrder() {
        return HttpResponseCustomPresentation.Order.AFTER_FILE_PATH;
    }

    @Override
    public void print(@NotNull CommonClientResponse response2, @NotNull SmartPsiElementPointer<HttpRequest> requestPointer, @NotNull HttpClientMessagePrinter printer2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter(requestPointer, (String)"requestPointer");
        Intrinsics.checkNotNullParameter((Object)printer2, (String)"printer");
        if (!printer2.isPreviewSupported()) {
            return;
        }
        CommonClientResponseBody body2 = response2.getBody();
        boolean isHtml = HttpInplaceSucceedResponsePresentation.Companion.isHtml$intellij_restClient(body2);
        boolean isPdf = HttpInplacePdfResponsePresentationKt.isPdf(body2);
        if (!isHtml && !isPdf) {
            return;
        }
        printer2.print(" ", ConsoleViewContentType.NORMAL_OUTPUT);
        printer2.addInlineElementOnCurrentPosition(0, arg_0 -> HttpResponseFilePathPresentation.print$lambda$3(isHtml, this, body2, isPdf, requestPointer, arg_0));
    }

    private final HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile retrievePdfFile(CommonClientResponseBody body2) {
        Deferred<CommonClientResponseBody.Binary.Content> deferred = body2 instanceof CommonClientResponseBody.Binary ? (Deferred<CommonClientResponseBody.Binary.Content>)body2 : null;
        if (deferred == null || (deferred = deferred.getContentDescriptor()) == null || (deferred = deferred.getContent()) == null) {
            return null;
        }
        Deferred<CommonClientResponseBody.Binary.Content> pdfBody = deferred;
        if (!pdfBody.isCompleted()) {
            return null;
        }
        VirtualFile resultFile2 = ((CommonClientResponseBody.Binary.Content)pdfBody.getCompleted()).getFileWithContent();
        PdfPreviewFile pdfPreviewFile = new PdfPreviewFile(resultFile2);
        return new HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile("preview." + resultFile2.getName(), VfsUtil.loadText((VirtualFile)((VirtualFile)pdfPreviewFile)));
    }

    private static final void print$lambda$3$lambda$2$lambda$1(HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile $preview, SmartPsiElementPointer $requestPointer, MouseEvent mouseEvent, Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$requestPointer, (String)"$requestPointer");
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<anonymous parameter 0>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<anonymous parameter 1>");
            HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile htmlPreviewVirtualFile = $preview;
            if (htmlPreviewVirtualFile == null) break block0;
            HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile it = htmlPreviewVirtualFile;
            boolean bl = false;
            HttpSingleResponseConsole.openHtmlPreview(it, $requestPointer.getProject());
        }
    }

    private static final EditorCustomElementRenderer print$lambda$3(boolean $isHtml, HttpResponseFilePathPresentation this$0, CommonClientResponseBody $body, boolean $isPdf, SmartPsiElementPointer $requestPointer, Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
        Intrinsics.checkNotNullParameter((Object)$requestPointer, (String)"$requestPointer");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile preview = $isHtml ? (HttpSingleResponseConsole.HtmlPreviewFileEditorProvider.HtmlPreviewVirtualFile)((Object)editor2.getUserData(HttpSingleResponseConsole.HTTP_PREVIEW_FILE_DATA_KEY)) : this$0.retrievePdfFile($body);
        PresentationFactory $this$print_u24lambda_u243_u24lambda_u242 = new PresentationFactory(editor2);
        boolean bl = false;
        if ($isPdf && preview != null) {
            editor2.putUserData(HttpSingleResponseConsole.HTTP_PREVIEW_FILE_DATA_KEY, (Object)preview);
        }
        String string = RestClientBundle.message("action.HTTPClient.Preview.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        InlayPresentation presentation2 = $this$print_u24lambda_u243_u24lambda_u242.referenceOnHover($this$print_u24lambda_u243_u24lambda_u242.roundWithBackground($this$print_u24lambda_u243_u24lambda_u242.smallText(string)), (arg_0, arg_1) -> HttpResponseFilePathPresentation.print$lambda$3$lambda$2$lambda$1(preview, $requestPointer, arg_0, arg_1));
        return (EditorCustomElementRenderer)new PresentationRenderer(presentation2);
    }
}

