/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.highlighting.ReplacementInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/highlighting/AddRequestSeparatorFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "replacementInfo", "Lcom/intellij/httpClient/http/request/highlighting/ReplacementInfo;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/httpClient/http/request/highlighting/ReplacementInfo;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getText", "invoke", "", "startElement", "endElement", "textWithSeparator", "intellij.restClient"})
public final class AddRequestSeparatorFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final ReplacementInfo replacementInfo;

    public AddRequestSeparatorFix(@NotNull PsiElement element, @NotNull ReplacementInfo replacementInfo) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)replacementInfo, (String)"replacementInfo");
        super(element);
        this.replacementInfo = replacementInfo;
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.client.code.style.inspection.add.request.separator.fix.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        document2.replaceString(this.replacementInfo.getStartIndexInDocument(), this.replacementInfo.getEndIndexInDocument(), (CharSequence)this.textWithSeparator());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff(file.getFileType(), "", this.textWithSeparator());
    }

    private final String textWithSeparator() {
        String text2 = this.replacementInfo.getTextToReplace();
        return StringsKt.trimMargin((String)("\n        |" + HttpRequestPsiConverter.getSeparator() + "\n        |" + text2 + "\n      "), (String)"|");
    }
}

