/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironmentJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "HttpRequestEnvironmentJsonSchemaProvider", "intellij.restClient"})
public final class HttpRequestEnvironmentJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new HttpRequestEnvironmentJsonSchemaProvider[2];
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
        String string = RestClientBundle.message("http.request.private.env.file.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new HttpRequestEnvironmentJsonSchemaProvider(project, HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, "http-client.private.env-schema.json", string);
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
        String string2 = RestClientBundle.message("http.request.env.file.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new HttpRequestEnvironmentJsonSchemaProvider(project, HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, "http-client.env-schema.json", string2);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0006H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpRequestEnvironmentJsonSchemaProviderFactory$HttpRequestEnvironmentJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "envFileName", "", "", "schemaName", "_name", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "get_name", "()Ljava/lang/String;", "getEnvFileName", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSchemaName", "getName", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "isAvailable", "", "file", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestEnvironmentJsonSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestEnvironmentJsonSchemaProviderFactory.kt\ncom/intellij/httpClient/http/request/environment/HttpRequestEnvironmentJsonSchemaProviderFactory$HttpRequestEnvironmentJsonSchemaProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
    private static final class HttpRequestEnvironmentJsonSchemaProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project project;
        @NotNull
        private final String[] envFileName;
        @NotNull
        private final String schemaName;
        @NotNull
        private final String _name;

        public HttpRequestEnvironmentJsonSchemaProvider(@NotNull Project project, @NotNull String[] envFileName, @NotNull String schemaName, @Nls @NotNull String _name) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)envFileName, (String)"envFileName");
            Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
            Intrinsics.checkNotNullParameter((Object)_name, (String)"_name");
            this.project = project;
            this.envFileName = envFileName;
            this.schemaName = schemaName;
            this._name = _name;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String[] getEnvFileName() {
            return this.envFileName;
        }

        @NotNull
        public final String getSchemaName() {
            return this.schemaName;
        }

        @NotNull
        public final String get_name() {
            return this._name;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return ArraysKt.contains((Object[])this.envFileName, (Object)string) && !DumbService.Companion.isDumb(this.project) && (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ HttpRequestEnvironmentJsonSchemaProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return HttpRequestFileUtils.hasHttpFilesInProject(this.this$0.getProject());
                }
            })) != false;
        }

        @NotNull
        public String getName() {
            return this._name;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            VirtualFile virtualFile;
            URL uRL = this.getClass().getResource("/schemas/" + this.schemaName);
            if (uRL != null) {
                URL it = uRL;
                boolean bl = false;
                virtualFile = VfsUtil.findFileByURL((URL)it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }
}

