/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.codeInsight.HttpRequestWhitespaceInsideRequestTargetPathInspection$buildVisitor$1$visitNonSeparableElement$;
import com.intellij.httpClient.http.request.psi.HttpPathAbsolute;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterKey;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterValue;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpRequestWhitespaceInsideRequestTargetPathInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "RemoveSpaceFix", "intellij.restClient"})
public final class HttpRequestWhitespaceInsideRequestTargetPathInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(holder.getFile() instanceof HttpRequestPsiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new HttpVisitor(holder, isOnTheFly){
            @NotNull
            private final Set<IElementType> allowedForPath;
            @NotNull
            private final Set<IElementType> allowedForQueryName;
            @NotNull
            private final Set<IElementType> allowedForQueryValue;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
                this.allowedForPath = SetsKt.setOf((Object)HttpRequestElementTypes.SEPARATOR);
                Object[] objectArray = new IElementType[]{HttpRequestElementTypes.EQUALS, HttpRequestElementTypes.AND, HttpRequestElementTypes.QUESTION};
                this.allowedForQueryName = SetsKt.setOf((Object[])objectArray);
                objectArray = new IElementType[]{HttpRequestElementTypes.EQUALS, HttpRequestElementTypes.AND};
                this.allowedForQueryValue = SetsKt.setOf((Object[])objectArray);
            }

            public void visitPathAbsolute(@NotNull HttpPathAbsolute o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                HttpRequestCompositeElement httpRequestCompositeElement = o;
                Object[] objectArray = new Object[]{HttpRequestWhitespaceInsideRequestTargetPathInspection.Companion.getKeys$intellij_restClient()};
                String string = RestClientBundle.message("http.client.code.style.inspection.in.path.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.visitNonSeparableElement(httpRequestCompositeElement, string, this.allowedForPath);
            }

            public void visitQueryParameterKey(@NotNull HttpQueryParameterKey o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                HttpRequestCompositeElement httpRequestCompositeElement = o;
                Object[] objectArray = new Object[]{HttpRequestWhitespaceInsideRequestTargetPathInspection.Companion.getKeys$intellij_restClient()};
                String string = RestClientBundle.message("http.client.code.style.inspection.in.query.name.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.visitNonSeparableElement(httpRequestCompositeElement, string, this.allowedForQueryName);
            }

            public void visitQueryParameterValue(@NotNull HttpQueryParameterValue o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                HttpRequestCompositeElement httpRequestCompositeElement = o;
                Object[] objectArray = new Object[]{HttpRequestWhitespaceInsideRequestTargetPathInspection.Companion.getKeys$intellij_restClient()};
                String string = RestClientBundle.message("http.client.code.style.inspection.in.query.value.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.visitNonSeparableElement(httpRequestCompositeElement, string, this.allowedForQueryValue);
            }

            private final void visitNonSeparableElement(HttpRequestCompositeElement o, @InspectionMessage String inspectionMessage, Set<? extends IElementType> allowedSiblings) {
                ProgressManager.checkCanceled();
                if (o.getFirstChild() == null) {
                    return;
                }
                PsiElement psiElement = o.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
                Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)buildVisitor$1$visitNonSeparableElement$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                for (PsiWhiteSpace space : sequence) {
                    ProblemDescriptor problem;
                    Pair pair;
                    PsiElement psiElement2 = space.getPrevSibling();
                    if (psiElement2 == null || (psiElement2 = PsiTreeUtilKt.getElementType((PsiElement)psiElement2)) == null) continue;
                    PsiElement prevType = psiElement2;
                    PsiElement psiElement3 = space.getNextSibling();
                    if (psiElement3 == null || (psiElement3 = PsiTreeUtilKt.getElementType((PsiElement)psiElement3)) == null) continue;
                    PsiElement nextType = psiElement3;
                    if (allowedSiblings.contains(prevType) || allowedSiblings.contains(nextType)) continue;
                    String string = space.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Character c = StringsKt.firstOrNull((CharSequence)string);
                    char c2 = '\n';
                    if (c != null && c.charValue() == c2 && space.getPrevSibling() != null) {
                        PsiElement prev = space.getPrevSibling();
                        pair = TuplesKt.to((Object)prev, (Object)new TextRange(0, 1).shiftRight(prev.getTextLength() - 1));
                    } else {
                        pair = TuplesKt.to((Object)space, (Object)new TextRange(0, 1));
                    }
                    Pair pair2 = pair;
                    PsiElement anchor = (PsiElement)pair2.component1();
                    TextRange rangeInAnchor = (TextRange)pair2.component2();
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RemoveSpaceFix((PsiElement)space)};
                    Intrinsics.checkNotNullExpressionValue((Object)this.$holder.getManager().createProblemDescriptor(anchor, rangeInAnchor, inspectionMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, localQuickFixArray), (String)"createProblemDescriptor(...)");
                    this.$holder.registerProblem(problem);
                }
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpRequestWhitespaceInsideRequestTargetPathInspection$Companion;", "", "()V", "keys", "", "Lorg/jetbrains/annotations/Nls;", "getKeys$intellij_restClient", "()Ljava/lang/String;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestWhitespaceInsideRequestTargetPathInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestWhitespaceInsideRequestTargetPathInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/HttpRequestWhitespaceInsideRequestTargetPathInspection$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n11065#2:115\n11400#2,3:116\n*S KotlinDebug\n*F\n+ 1 HttpRequestWhitespaceInsideRequestTargetPathInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/HttpRequestWhitespaceInsideRequestTargetPathInspection$Companion\n*L\n111#1:115\n111#1:116,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final String getKeys$intellij_restClient() {
            void $this$mapTo$iv$iv;
            Shortcut[] shortcutArray = KeymapUtil.getActiveKeymapShortcuts((String)"EditorSplitLine").getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Object[] $this$map$iv = shortcutArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Shortcut shortcut = (Shortcut)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeymapUtil.getShortcutText((Shortcut)it));
            }
            String string = NlsMessages.formatOrList((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatOrList(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpRequestWhitespaceInsideRequestTargetPathInspection$RemoveSpaceFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "intellij.restClient"})
    private static final class RemoveSpaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public RemoveSpaceFix(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = RestClientBundle.message("http.client.code.style.inspection.remove.space.fix.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            boolean bl = startElement instanceof PsiWhiteSpace;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            Document document2 = document;
            document2.deleteString(PsiTreeUtilKt.getStartOffset((PsiElement)startElement), PsiTreeUtilKt.getEndOffset((PsiElement)startElement));
        }
    }
}

