/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.authentication.oauth2;

import com.intellij.httpClient.http.request.authentication.AuthFlowLogEntry;
import com.intellij.httpClient.http.request.authentication.ReferencedSecret;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004JD\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0012\"\u00020\b2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00100\u0014\u00a2\u0006\u0002\b\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J>\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00100\u0014\u00a2\u0006\u0002\b\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/http/request/authentication/oauth2/LoggingScope;", "", "logEntries", "Ljava/util/Queue;", "Lcom/intellij/httpClient/http/request/authentication/AuthFlowLogEntry;", "(Ljava/util/Queue;)V", "currentSecrets", "", "Lcom/intellij/httpClient/http/request/authentication/ReferencedSecret;", "entries", "getEntries", "()Ljava/util/List;", "log", "", "entry", "withSecrets", "T", "secrets", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "([Lcom/intellij/httpClient/http/request/authentication/ReferencedSecret;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.restClient"})
final class LoggingScope {
    @NotNull
    private final Queue<AuthFlowLogEntry> logEntries;
    @NotNull
    private List<ReferencedSecret> currentSecrets;

    public LoggingScope(@NotNull Queue<AuthFlowLogEntry> logEntries) {
        Intrinsics.checkNotNullParameter(logEntries, (String)"logEntries");
        this.logEntries = logEntries;
        this.currentSecrets = CollectionsKt.emptyList();
    }

    public /* synthetic */ LoggingScope(Queue queue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            queue = new ConcurrentLinkedQueue();
        }
        this(queue);
    }

    public final <T> T withSecrets(@NotNull List<ReferencedSecret> secrets, @NotNull Function1<? super LoggingScope, ? extends T> block) {
        Intrinsics.checkNotNullParameter(secrets, (String)"secrets");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withSecrets = false;
        LoggingScope newScope = new LoggingScope(this.logEntries);
        newScope.currentSecrets = CollectionsKt.plus((Collection)this.currentSecrets, (Iterable)secrets);
        return (T)block.invoke((Object)newScope);
    }

    public final <T> T withSecrets(@NotNull ReferencedSecret[] secrets, @NotNull Function1<? super LoggingScope, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withSecrets = false;
        LoggingScope newScope = new LoggingScope(this.logEntries);
        newScope.currentSecrets = CollectionsKt.plus((Collection)this.currentSecrets, (Object[])secrets);
        return (T)block.invoke((Object)newScope);
    }

    public final void log(@NotNull AuthFlowLogEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        ((Collection)this.logEntries).add(AuthFlowLogEntry.Companion.withSecrets(entry, this.currentSecrets));
    }

    @NotNull
    public final List<AuthFlowLogEntry> getEntries() {
        return CollectionsKt.toList((Iterable)this.logEntries);
    }

    public LoggingScope() {
        this(null, 1, null);
    }
}

